/*
 * Decompiled with CFR 0.152.
 */
package com.wynntils.screens.territorymanagement.widgets;

import com.wynntils.core.text.StyledText;
import com.wynntils.models.items.items.gui.TerritoryItem;
import com.wynntils.models.territories.type.GuildResource;
import com.wynntils.screens.base.TooltipProvider;
import com.wynntils.screens.territorymanagement.TerritoryManagementHolder;
import com.wynntils.screens.territorymanagement.type.TerritoryColor;
import com.wynntils.utils.colors.CommonColors;
import com.wynntils.utils.colors.CustomColor;
import com.wynntils.utils.mc.McUtils;
import com.wynntils.utils.render.FontRenderer;
import com.wynntils.utils.render.RenderUtils;
import com.wynntils.utils.render.Texture;
import com.wynntils.utils.render.type.HorizontalAlignment;
import com.wynntils.utils.render.type.TextShadow;
import com.wynntils.utils.render.type.VerticalAlignment;
import java.util.Arrays;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.AbstractWidget;
import net.minecraft.client.gui.narration.NarrationElementOutput;
import net.minecraft.network.chat.Component;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.Level;

public class TerritoryWidget
extends AbstractWidget
implements TooltipProvider {
    private final TerritoryManagementHolder holder;
    private final TerritoryColor territoryColor;
    private final ItemStack itemStack;
    private final TerritoryItem territoryItem;

    public TerritoryWidget(int x, int y, int width, int height, TerritoryManagementHolder holder, TerritoryColor territoryColor, ItemStack itemStack, TerritoryItem territoryItem) {
        super(x, y, width, height, (Component)Component.literal((String)territoryItem.getName()));
        this.holder = holder;
        this.territoryColor = territoryColor;
        this.itemStack = itemStack;
        this.territoryItem = territoryItem;
    }

    protected void renderWidget(GuiGraphics guiGraphics, int mouseX, int mouseY, float partialTick) {
        if (!this.territoryColor.backgroundColors().isEmpty()) {
            RenderUtils.drawMulticoloredRect(guiGraphics.pose(), this.territoryColor.backgroundColors(), this.getX(), this.getY(), 0.0f, this.getWidth(), this.getHeight());
        }
        if (this.territoryColor.borderColor() != CustomColor.NONE) {
            RenderUtils.drawRectBorders(guiGraphics.pose(), this.territoryColor.borderColor(), (float)this.getX() + 0.75f, (float)this.getY() + 0.75f, (float)(this.getX() + this.getWidth()) - 0.75f, (float)(this.getY() + this.getHeight()) - 0.75f, 0.0f, 1.5f);
        }
        guiGraphics.pose().pushPose();
        Texture texture = Texture.TERRITORY_ITEM;
        if (this.territoryItem.isSelected()) {
            texture = Texture.CHECKMARK_GREEN;
        } else if (this.territoryItem.isHeadquarters()) {
            texture = Texture.TERRITORY_ITEM_HQ;
        } else if (!this.territoryItem.getAlerts().isEmpty()) {
            texture = Texture.TERRITORY_ITEM_ALERT;
        }
        int itemWidth = (int)((float)this.getWidth() * 0.9f);
        int itemHeight = (int)((float)this.getHeight() * 0.9f);
        int itemRenderX = this.getX() + (this.getWidth() - itemWidth) / 2;
        int itemRenderY = this.getY() + (this.getHeight() - itemHeight) / 2;
        RenderUtils.drawScalingTexturedRect(guiGraphics.pose(), texture.resource(), itemRenderX, itemRenderY, 0.0f, itemWidth, itemHeight, texture.width(), texture.height());
        guiGraphics.pose().popPose();
        Set productionTypes = this.territoryItem.getProduction().keySet().stream().filter(GuildResource::isMaterialResource).collect(Collectors.toUnmodifiableSet());
        if (!productionTypes.isEmpty()) {
            if (productionTypes.size() <= 2) {
                GuildResource productionType = (GuildResource)((Object)productionTypes.iterator().next());
                Object symbol = productionType.getPrettySymbol().trim();
                symbol = (String)symbol + (productionTypes.size() == 2 ? ((GuildResource)((Object)productionTypes.iterator().next())).getPrettySymbol().trim() : "");
                FontRenderer.getInstance().renderAlignedTextInBox(guiGraphics.pose(), StyledText.fromString((String)symbol), this.getX(), this.getX() + this.getWidth(), this.getY(), this.getY() + this.getHeight(), 0.0f, CommonColors.WHITE, HorizontalAlignment.LEFT, VerticalAlignment.TOP, TextShadow.NORMAL);
            } else {
                int i = 0;
                for (GuildResource productionType : productionTypes) {
                    String symbol = productionType.getPrettySymbol().trim();
                    FontRenderer.getInstance().renderText(guiGraphics.pose(), StyledText.fromString(symbol), this.getX() + i % 2 * 8, this.getY() + i / 2 * 8, CommonColors.WHITE, HorizontalAlignment.LEFT, VerticalAlignment.TOP, TextShadow.NORMAL);
                    ++i;
                }
            }
            String shortTerritoryName = Arrays.stream(this.territoryItem.getName().split(" ")).map(s -> s.substring(0, 1)).collect(Collectors.joining());
            int maxTextWidth = (int)((float)this.getWidth() * 0.85f);
            int textWidth = FontRenderer.getInstance().getFont().width(shortTerritoryName);
            float textScale = Math.min(0.95f, (float)maxTextWidth / (float)textWidth);
            FontRenderer.getInstance().renderAlignedTextInBox(guiGraphics.pose(), StyledText.fromString(shortTerritoryName), (float)this.getX(), (float)(this.getX() + this.getWidth()), (float)this.getY(), (float)(this.getY() + this.getHeight()), 0.0f, CommonColors.ORANGE, HorizontalAlignment.RIGHT, VerticalAlignment.BOTTOM, TextShadow.OUTLINE, textScale);
        }
    }

    public void onClick(double mouseX, double mouseY) {
        this.holder.territoryItemClicked(this.territoryItem);
    }

    protected void updateWidgetNarration(NarrationElementOutput narrationElementOutput) {
    }

    @Override
    public List<Component> getTooltipLines() {
        return this.itemStack.getTooltipLines(Item.TooltipContext.of((Level)McUtils.mc().level), (Player)McUtils.player(), (TooltipFlag)TooltipFlag.NORMAL);
    }
}

