/*
 * Decompiled with CFR 0.152.
 */
package com.wynntils.services.hades.type;

import com.wynntils.models.inventory.type.InventoryAccessory;
import com.wynntils.models.inventory.type.InventoryArmor;
import java.util.Map;
import java.util.TreeMap;

public class GearShareOptions {
    private Map<InventoryArmor, Boolean> armorShare = new TreeMap<InventoryArmor, Boolean>();
    private Map<InventoryAccessory, Boolean> accessoryShare = new TreeMap<InventoryAccessory, Boolean>();
    private boolean shareHeldItem = true;
    private boolean shareCraftedItems = true;
    private boolean shareCraftedNames = true;

    public boolean shouldShare() {
        return this.armorShare.values().stream().anyMatch(b -> b) || this.accessoryShare.values().stream().anyMatch(b -> b) || this.shareHeldItem;
    }

    public boolean shouldShareArmor(InventoryArmor armor) {
        return this.armorShare.getOrDefault((Object)armor, true);
    }

    public void setShareArmor(InventoryArmor armor, boolean share) {
        this.armorShare.put(armor, share);
    }

    public boolean shouldShareAccessory(InventoryAccessory accessory) {
        return this.accessoryShare.getOrDefault((Object)accessory, true);
    }

    public void setShareAccessory(InventoryAccessory accessory, boolean share) {
        this.accessoryShare.put(accessory, share);
    }

    public boolean shouldShareHeldItem() {
        return this.shareHeldItem;
    }

    public void setShareHeldItem(boolean shareHeldItem) {
        this.shareHeldItem = shareHeldItem;
    }

    public boolean shareCraftedItems() {
        return this.shareCraftedItems;
    }

    public void setShareCraftedItems(boolean shareCraftedItems) {
        this.shareCraftedItems = shareCraftedItems;
    }

    public boolean shareCraftedNames() {
        return this.shareCraftedNames;
    }

    public void setShareCraftedNames(boolean shareCraftedNames) {
        this.shareCraftedNames = shareCraftedNames;
    }
}

