/*
 * Decompiled with CFR 0.152.
 */
package com.wynntils.services.leaderboard;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.wynntils.core.WynntilsMod;
import com.wynntils.core.components.Managers;
import com.wynntils.core.components.Service;
import com.wynntils.core.net.ApiResponse;
import com.wynntils.core.net.UrlId;
import com.wynntils.services.leaderboard.type.LeaderboardBadge;
import com.wynntils.services.leaderboard.type.LeaderboardType;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;

public class LeaderboardService
extends Service {
    private Map<UUID, List<LeaderboardBadge>> playerLeaderboards = new HashMap<UUID, List<LeaderboardBadge>>();
    private Map<String, List<LeaderboardBadge>> guildLeaderboards = new HashMap<String, List<LeaderboardBadge>>();

    public LeaderboardService() {
        super(List.of());
    }

    @Override
    public void reloadData() {
        this.updateLeaderboards();
    }

    public List<LeaderboardBadge> getPlayerBadges(UUID id) {
        return this.playerLeaderboards.getOrDefault(id, List.of());
    }

    private void updateLeaderboards() {
        this.playerLeaderboards = new HashMap<UUID, List<LeaderboardBadge>>();
        this.guildLeaderboards = new HashMap<String, List<LeaderboardBadge>>();
        ApiResponse apiResponse = Managers.Net.callApi(UrlId.DATA_ATHENA_LEADERBOARD);
        apiResponse.handleJsonObject(json -> {
            for (Map.Entry entry : json.entrySet()) {
                LeaderboardType type = LeaderboardType.fromKey((String)entry.getKey());
                if (type == null) {
                    WynntilsMod.warn("Unknown leaderboard type: " + (String)entry.getKey());
                    continue;
                }
                JsonObject leaderboard = ((JsonElement)entry.getValue()).getAsJsonObject();
                for (Map.Entry rank : leaderboard.entrySet()) {
                    String value = ((JsonElement)rank.getValue()).getAsString();
                    if (value.equals("redacted")) continue;
                    if (type.isGuildLeaderboard()) {
                        List badges = this.guildLeaderboards.getOrDefault(value, new ArrayList());
                        badges.add(LeaderboardBadge.from(type, Integer.parseInt((String)rank.getKey())));
                        this.guildLeaderboards.put(value, badges);
                        continue;
                    }
                    UUID uuid = UUID.fromString(value);
                    List badges = this.playerLeaderboards.getOrDefault(uuid, new ArrayList());
                    badges.add(LeaderboardBadge.from(type, Integer.parseInt((String)rank.getKey())));
                    this.playerLeaderboards.put(uuid, badges);
                }
            }
        });
    }
}

