/*
 * Decompiled with CFR 0.152.
 */
package com.wynntils.services.mapdata;

import com.mojang.blaze3d.vertex.PoseStack;
import com.wynntils.core.WynntilsMod;
import com.wynntils.core.components.Services;
import com.wynntils.services.map.pois.Poi;
import com.wynntils.services.map.type.DisplayPriority;
import com.wynntils.services.mapdata.MapFeatureRenderer;
import com.wynntils.services.mapdata.attributes.type.MapIcon;
import com.wynntils.services.mapdata.attributes.type.ResolvedMapAttributes;
import com.wynntils.services.mapdata.type.MapFeature;
import com.wynntils.services.mapdata.type.MapLocation;
import com.wynntils.utils.mc.type.PoiLocation;
import com.wynntils.utils.render.FontRenderer;
import java.util.Objects;
import java.util.Optional;
import net.minecraft.client.renderer.MultiBufferSource;

public class MapFeaturePoiWrapper
implements Poi {
    public static final int SPACING = 2;
    private static final float TEXT_SCALE = 1.0f;
    private final MapFeature feature;
    private final ResolvedMapAttributes attributes;

    public MapFeaturePoiWrapper(MapFeature feature, ResolvedMapAttributes attributes) {
        this.feature = feature;
        this.attributes = attributes;
    }

    @Override
    public PoiLocation getLocation() {
        MapFeature mapFeature = this.feature;
        if (mapFeature instanceof MapLocation) {
            MapLocation mapLocation = (MapLocation)mapFeature;
            return PoiLocation.fromLocation(mapLocation.getLocation());
        }
        return null;
    }

    @Override
    public DisplayPriority getDisplayPriority() {
        return DisplayPriority.HIGHEST;
    }

    @Override
    public boolean hasStaticLocation() {
        return false;
    }

    @Override
    public String getName() {
        return "Wrapped MapFeature [" + this.feature.getFeatureId() + "]";
    }

    @Override
    public boolean isVisible(float zoomRenderScale, float zoomLevel) {
        float iconAlpha = Services.MapData.calculateVisibility(this.attributes.iconVisibility(), zoomLevel);
        Optional<MapIcon> icon = Services.MapData.getIcon(this.attributes.iconId());
        if (icon.isPresent() && (double)iconAlpha > 0.01) {
            return true;
        }
        float labelAlpha = Services.MapData.calculateVisibility(this.attributes.labelVisibility(), zoomLevel);
        return !this.attributes.label().isEmpty() && (double)labelAlpha > 0.01;
    }

    @Override
    public int getWidth(float mapZoom, float scale) {
        Optional<MapIcon> icon = Services.MapData.getIcon(this.attributes.iconId());
        if (icon.isPresent()) {
            return (int)((float)icon.get().getWidth() * scale);
        }
        if (!this.attributes.label().isEmpty()) {
            return (int)((float)FontRenderer.getInstance().getFont().width(this.attributes.label()) * scale);
        }
        WynntilsMod.warn("No icon or label for feature " + this.feature.getFeatureId());
        return 32;
    }

    @Override
    public int getHeight(float mapZoom, float scale) {
        Optional<MapIcon> icon = Services.MapData.getIcon(this.attributes.iconId());
        if (icon.isPresent()) {
            return (int)((float)icon.get().getHeight() * scale);
        }
        if (!this.attributes.label().isEmpty()) {
            Objects.requireNonNull(FontRenderer.getInstance().getFont());
            return (int)(9.0f * scale * 1.0f);
        }
        WynntilsMod.warn("No icon or label for feature " + this.feature.getFeatureId());
        return 32;
    }

    @Override
    public void renderAt(PoseStack poseStack, MultiBufferSource bufferSource, float renderX, float renderY, boolean hovered, float scale, float zoomRenderScale, float zoomLevel, boolean showLabels) {
        MapFeatureRenderer.renderMapFeature(poseStack, bufferSource, this.feature, this.attributes, renderX, renderY, hovered, scale, zoomLevel, showLabels);
    }
}

