/*
 * Decompiled with CFR 0.152.
 */
package com.wynntils.services.resourcepack;

import com.wynntils.core.WynntilsMod;
import com.wynntils.core.text.StyledText;
import com.wynntils.utils.mc.McUtils;
import java.io.IOException;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.Optional;
import java.util.function.Consumer;
import java.util.regex.Pattern;
import java.util.stream.Stream;
import net.minecraft.client.resources.server.DownloadedPackSource;
import net.minecraft.network.chat.Component;
import net.minecraft.server.packs.FilePackResources;
import net.minecraft.server.packs.PackLocationInfo;
import net.minecraft.server.packs.PackSelectionConfig;
import net.minecraft.server.packs.PackType;
import net.minecraft.server.packs.repository.Pack;
import net.minecraft.server.packs.repository.PackSource;
import net.minecraft.server.packs.repository.RepositorySource;

public final class WynntilsResourceProvider
implements RepositorySource {
    private static final String PRELOADED_PACK_PREFIX = "wynntils_preloaded/";
    private static final Pattern WYNNCRAFT_PACK_PATTERN = Pattern.compile("\u00a7(#.{8}|.)Wynncraft Resource Pack \u00a77.+", 32);
    private static final Path MINECRAFT_RESOURCE_PACKS_PATH = McUtils.mc().gameDirectory.toPath().resolve("downloads");
    private static final PackSelectionConfig WYNNTILS_PRELOADED_PACK_CONFIG = new PackSelectionConfig(false, Pack.Position.TOP, false);
    private static final PackSource WYNNTILS_PRELOADED_PACK_SOURCE = PackSource.create(component -> component.copy().append((Component)Component.literal((String)" (Wynntils)")), (boolean)true);

    public void loadPacks(Consumer<Pack> onLoad) {
        try (Stream<Path> paths = Files.walk(MINECRAFT_RESOURCE_PACKS_PATH, 2, new FileVisitOption[0]);){
            paths.filter(x$0 -> Files.isRegularFile(x$0, new LinkOption[0])).forEach(path -> {
                FilePackResources.FileResourcesSupplier resourcesSupplier;
                String fileName = path.getFileName().toString();
                if (DownloadedPackSource.tryParseSha1Hash((String)fileName) == null) {
                    return;
                }
                PackLocationInfo packLocationInfo = new PackLocationInfo(PRELOADED_PACK_PREFIX + fileName, (Component)Component.literal((String)"Wynncraft Pack"), WYNNTILS_PRELOADED_PACK_SOURCE, Optional.empty());
                Pack pack = Pack.readMetaAndCreate((PackLocationInfo)packLocationInfo, (Pack.ResourcesSupplier)(resourcesSupplier = new FilePackResources.FileResourcesSupplier(path)), (PackType)PackType.CLIENT_RESOURCES, (PackSelectionConfig)WYNNTILS_PRELOADED_PACK_CONFIG);
                if (pack == null) {
                    WynntilsMod.warn("Failed to load resource pack: " + fileName);
                    return;
                }
                StyledText packDescription = StyledText.fromComponent(pack.getDescription());
                if (packDescription.matches(WYNNCRAFT_PACK_PATTERN)) {
                    onLoad.accept(pack);
                }
            });
        }
        catch (IOException e) {
            WynntilsMod.error("Failed to load resource pack", e);
        }
    }
}

