/*
 * Decompiled with CFR 0.152.
 */
package com.wynntils.utils;

import com.google.common.net.UrlEscapers;
import java.nio.ByteBuffer;
import java.nio.charset.StandardCharsets;
import java.text.DecimalFormat;
import java.text.Normalizer;
import java.util.ArrayList;
import java.util.Base64;
import java.util.List;
import java.util.Locale;
import java.util.regex.Pattern;
import net.minecraft.ChatFormatting;
import net.minecraft.client.resources.language.I18n;
import org.apache.commons.lang3.time.DateFormatUtils;

public final class StringUtils {
    private static final String[] SUFFIXES = new String[]{"", "k", "m", "b", "t"};
    private static final long[] SUFFIX_MULTIPLIERS = new long[]{1L, 1000L, 1000000L, 1000000000L, 1000000000000L};
    private static final DecimalFormat FRACTIONAL_FORMAT = new DecimalFormat("#.#");
    private static final Pattern NONLATIN = Pattern.compile("[^\\w-]");
    private static final Pattern WHITESPACE = Pattern.compile("[\\s]");
    private static final Pattern WHITESPACES = Pattern.compile("\\s+");
    private static final Pattern LINEBREAK = Pattern.compile("\n");
    private static final Pattern MARKDOWN_HEADER_PATTERN = Pattern.compile("#+\\s+");

    public static List<String> parseStringToList(String input, String delimiter) {
        ArrayList<String> result = new ArrayList<String>();
        for (String element : input.split(Pattern.quote(delimiter))) {
            result.add(element.strip());
        }
        return result;
    }

    public static List<String> parseStringToList(String input) {
        return StringUtils.parseStringToList(input, ",");
    }

    public static String capitalizeFirst(String input) {
        if (input.isEmpty()) {
            return "";
        }
        return Character.toUpperCase(input.charAt(0)) + input.substring(1);
    }

    public static String uncapitalizeFirst(String input) {
        if (input.isEmpty()) {
            return "";
        }
        return Character.toLowerCase(input.charAt(0)) + input.substring(1);
    }

    public static String capitalized(String input) {
        if (input.isEmpty()) {
            return "";
        }
        return Character.toUpperCase(input.charAt(0)) + input.substring(1).toLowerCase(Locale.ROOT);
    }

    public static String integerToShortString(long count) {
        if (count < 1000L) {
            return Long.toString(count);
        }
        int exp = (int)(Math.log(count) / Math.log(1000.0));
        DecimalFormat format = new DecimalFormat("0.#");
        String value = format.format((double)count / Math.pow(1000.0, exp));
        return String.format("%s%c", value, Character.valueOf("kMBTPE".charAt(exp - 1)));
    }

    public static long parseSuffixedInteger(String numStr) throws NumberFormatException {
        numStr = numStr.toLowerCase(Locale.ROOT);
        for (int i = 1; i < SUFFIXES.length; ++i) {
            if (!numStr.endsWith(SUFFIXES[i])) continue;
            double baseValue = Double.parseDouble(numStr.substring(0, numStr.length() - 1));
            return (long)Math.ceil(baseValue * (double)SUFFIX_MULTIPLIERS[i]);
        }
        return Long.parseLong(numStr);
    }

    public static String formatDuration(long seconds) {
        long hours = seconds / 3600L;
        long minutes = seconds % 3600L / 60L;
        long remainingSeconds = seconds % 60L;
        if (hours > 0L) {
            return String.format("%dh %02dm %02ds", hours, minutes, remainingSeconds);
        }
        if (minutes > 0L) {
            return String.format("%dm %02ds", minutes, remainingSeconds);
        }
        return String.format("%ds", remainingSeconds);
    }

    public static String encodeUrl(String url) {
        return UrlEscapers.urlPathSegmentEscaper().escape(url);
    }

    public static String createSlug(String input) {
        String nowhitespace = WHITESPACE.matcher(input).replaceAll("-");
        String normalized = Normalizer.normalize(nowhitespace, Normalizer.Form.NFD);
        String slug = NONLATIN.matcher(normalized).replaceAll("");
        return slug.toLowerCase(Locale.ENGLISH);
    }

    public static String formatAmount(double value) {
        int suffix;
        if (value < 0.75) {
            return "0";
        }
        for (suffix = 0; suffix < SUFFIXES.length && value >= 750.0; value /= 1000.0, ++suffix) {
        }
        return FRACTIONAL_FORMAT.format(value) + SUFFIXES[suffix];
    }

    public static boolean partialMatch(String toMatchStr, String searchTermStr) {
        String searchTerm = searchTermStr.toLowerCase(Locale.ROOT);
        String toMatch = toMatchStr.toLowerCase(Locale.ROOT);
        int firstIndexToMatch = 0;
        for (int i = 0; i < searchTerm.length(); ++i) {
            char currentChar = searchTerm.charAt(i);
            int indexOfFirstMatch = toMatch.indexOf(currentChar, firstIndexToMatch);
            if (indexOfFirstMatch == -1) {
                return false;
            }
            firstIndexToMatch = indexOfFirstMatch + 1;
        }
        return true;
    }

    public static boolean initialMatch(String toMatch, String searchTerm) {
        String lookAt = toMatch.toLowerCase(Locale.ROOT);
        String searchFor = WHITESPACES.matcher(searchTerm.strip().toLowerCase(Locale.ROOT)).replaceAll(" ");
        String regex = (" " + searchFor + " ").replace(" ", ".*");
        return lookAt.matches(regex);
    }

    public static boolean containsIgnoreCase(String str, String searchStr) {
        return org.apache.commons.lang3.StringUtils.containsIgnoreCase((CharSequence)str, (CharSequence)searchStr);
    }

    public static String substringBeforeLast(String str, String separator) {
        return org.apache.commons.lang3.StringUtils.substringBeforeLast((String)str, (String)separator);
    }

    public static String toSignedString(int value) {
        if (value >= 0) {
            return "+" + value;
        }
        return Integer.toString(value);
    }

    public static String convertMarkdownToColorCode(String input) {
        return String.valueOf(ChatFormatting.RESET) + MARKDOWN_HEADER_PATTERN.matcher(input).replaceFirst(String.valueOf(ChatFormatting.BOLD));
    }

    public static ByteBuffer decodeBase64(String base64) {
        if (base64 == null) {
            return null;
        }
        return Base64.getDecoder().decode(ByteBuffer.wrap(LINEBREAK.matcher(base64).replaceAll("").getBytes(StandardCharsets.UTF_8)));
    }

    public static String floatToSimpleString(float value) {
        if (value == (float)((int)value)) {
            return Integer.toString((int)value);
        }
        return String.format("%.2f", Float.valueOf(value));
    }

    public static String formatDateTime(long timeMillis) {
        return DateFormatUtils.format((long)timeMillis, (String)"yyyy-MM-dd HH:mm");
    }

    public static String getRelativeTimeString(long timestamp) {
        long diffInMillis = timestamp - System.currentTimeMillis();
        if (diffInMillis > -1000L && diffInMillis < 1000L) {
            return I18n.get((String)"utils.wynntils.time.now", (Object[])new Object[0]);
        }
        int diffInSeconds = (int)(diffInMillis / 1000L);
        int seconds = Math.abs(diffInSeconds);
        int minutes = seconds / 60;
        int hours = minutes / 60;
        int days = hours / 24;
        String timeStr = seconds < 60 ? (seconds == 1 ? I18n.get((String)"utils.wynntils.time.second", (Object[])new Object[]{seconds}) : I18n.get((String)"utils.wynntils.time.seconds", (Object[])new Object[]{seconds})) : (minutes < 60 ? (minutes == 1 ? I18n.get((String)"utils.wynntils.time.minute", (Object[])new Object[]{minutes}) : I18n.get((String)"utils.wynntils.time.minutes", (Object[])new Object[]{minutes})) : (hours < 24 ? (hours == 1 ? I18n.get((String)"utils.wynntils.time.hour", (Object[])new Object[]{hours}) : I18n.get((String)"utils.wynntils.time.hours", (Object[])new Object[]{hours})) : (days == 1 ? I18n.get((String)"utils.wynntils.time.day", (Object[])new Object[]{days}) : I18n.get((String)"utils.wynntils.time.days", (Object[])new Object[]{days}))));
        if (diffInSeconds < 0) {
            return I18n.get((String)"utils.wynntils.time.past", (Object[])new Object[]{timeStr});
        }
        return I18n.get((String)"utils.wynntils.time.future", (Object[])new Object[]{timeStr});
    }

    public static String getAbbreviation(String input) {
        if (input == null || input.isBlank()) {
            return "";
        }
        String[] words = WHITESPACES.split(input.trim());
        StringBuilder abbreviation = new StringBuilder();
        if (words.length == 1) {
            String word = words[0];
            abbreviation.append(word, 0, Math.min(3, word.length()));
        } else {
            for (int i = 0; i < Math.min(3, words.length); ++i) {
                String word = words[i];
                if (word.isEmpty()) continue;
                abbreviation.append(word.charAt(0));
            }
        }
        return abbreviation.toString();
    }
}

