/*
 * Decompiled with CFR 0.152.
 */
package com.wynntils.utils.render.buffered;

import com.mojang.blaze3d.vertex.PoseStack;
import com.wynntils.core.text.StyledText;
import com.wynntils.mc.mixin.accessors.MinecraftAccessor;
import com.wynntils.utils.colors.CommonColors;
import com.wynntils.utils.colors.CustomColor;
import com.wynntils.utils.mc.ComponentUtils;
import com.wynntils.utils.mc.McUtils;
import com.wynntils.utils.render.FontRenderer;
import com.wynntils.utils.render.TextRenderTask;
import com.wynntils.utils.render.type.HorizontalAlignment;
import com.wynntils.utils.render.type.TextShadow;
import com.wynntils.utils.render.type.VerticalAlignment;
import com.wynntils.utils.type.IterationDecision;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import net.minecraft.ChatFormatting;
import net.minecraft.client.gui.Font;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.chat.Style;

public final class BufferedFontRenderer {
    private static final BufferedFontRenderer INSTANCE = new BufferedFontRenderer();
    private final Font font = ((MinecraftAccessor)McUtils.mc()).getFont();
    private static final int NEWLINE_OFFSET = 10;
    private static final CustomColor SHADOW_COLOR = CommonColors.BLACK;

    private BufferedFontRenderer() {
    }

    public static BufferedFontRenderer getInstance() {
        return INSTANCE;
    }

    public Font getFont() {
        return this.font;
    }

    public void renderText(PoseStack poseStack, MultiBufferSource bufferSource, StyledText text, float x, float y, CustomColor customColor, HorizontalAlignment horizontalAlignment, VerticalAlignment verticalAlignment, TextShadow shadow, float textScale, Font.DisplayMode displayMode) {
        if (text == null) {
            return;
        }
        float renderX = switch (horizontalAlignment) {
            default -> throw new MatchException(null, null);
            case HorizontalAlignment.LEFT -> x;
            case HorizontalAlignment.CENTER -> x - (float)this.font.width((FormattedText)text.getComponent()) / 2.0f * textScale;
            case HorizontalAlignment.RIGHT -> x - (float)this.font.width((FormattedText)text.getComponent()) * textScale;
        };
        float renderY = switch (verticalAlignment) {
            default -> throw new MatchException(null, null);
            case VerticalAlignment.TOP -> y;
            case VerticalAlignment.MIDDLE -> {
                Objects.requireNonNull(this.font);
                yield y - 9.0f / 2.0f * textScale;
            }
            case VerticalAlignment.BOTTOM -> {
                Objects.requireNonNull(this.font);
                yield y - 9.0f * textScale;
            }
        };
        poseStack.pushPose();
        poseStack.translate(renderX, renderY, 0.0f);
        poseStack.scale(textScale, textScale, 0.0f);
        switch (shadow) {
            case NONE: {
                this.font.drawInBatch((Component)text.getComponent(), 0.0f, 0.0f, customColor.asInt(), false, poseStack.last().pose(), bufferSource, displayMode, 0, 0xF000F0);
                break;
            }
            case NORMAL: {
                this.font.drawInBatch((Component)text.getComponent(), 0.0f, 0.0f, customColor.asInt(), true, poseStack.last().pose(), bufferSource, displayMode, 0, 0xF000F0);
                break;
            }
            case OUTLINE: {
                int shadowColor = SHADOW_COLOR.withAlpha(customColor.a()).asInt();
                MutableComponent strippedComponent = text.iterate((part, changes) -> {
                    changes.remove(part);
                    changes.add(part.withStyle(partStyle -> partStyle.withColor(ChatFormatting.BLACK)));
                    return IterationDecision.CONTINUE;
                }).getComponent();
                this.font.drawInBatch((Component)strippedComponent, -1.0f, 0.0f, shadowColor, false, poseStack.last().pose(), bufferSource, displayMode, 0, 0xF000F0);
                this.font.drawInBatch((Component)strippedComponent, 1.0f, 0.0f, shadowColor, false, poseStack.last().pose(), bufferSource, displayMode, 0, 0xF000F0);
                this.font.drawInBatch((Component)strippedComponent, 0.0f, -1.0f, shadowColor, false, poseStack.last().pose(), bufferSource, displayMode, 0, 0xF000F0);
                this.font.drawInBatch((Component)strippedComponent, 0.0f, 1.0f, shadowColor, false, poseStack.last().pose(), bufferSource, displayMode, 0, 0xF000F0);
                this.font.drawInBatch((Component)text.getComponent(), 0.0f, 0.0f, customColor.asInt(), false, poseStack.last().pose(), bufferSource, displayMode, 0, 0xF000F0);
            }
        }
        poseStack.popPose();
    }

    public void renderText(PoseStack poseStack, MultiBufferSource bufferSource, StyledText text, float x, float y, CustomColor customColor, HorizontalAlignment horizontalAlignment, VerticalAlignment verticalAlignment, TextShadow shadow, float textScale) {
        this.renderText(poseStack, bufferSource, text, x, y, customColor, horizontalAlignment, verticalAlignment, shadow, textScale, Font.DisplayMode.SEE_THROUGH);
    }

    public void renderAlignedTextInBox(PoseStack poseStack, MultiBufferSource bufferSource, StyledText[] lines, float x1, float x2, float y1, float y2, float maxWidth, CustomColor customColor, HorizontalAlignment horizontalAlignment, VerticalAlignment verticalAlignment, TextShadow textShadow, float textScale) {
        Objects.requireNonNull(this.font);
        int lineHeight = 9;
        ArrayList<StyledText> adjustedLines = new ArrayList<StyledText>();
        for (StyledText line : lines) {
            if (maxWidth == 0.0f || (float)this.font.width((FormattedText)line.getComponent()) < maxWidth / textScale) {
                adjustedLines.add(line);
                continue;
            }
            List parts = this.font.getSplitter().splitLines((FormattedText)line.getComponent(), (int)(maxWidth / textScale), Style.EMPTY);
            StyledText lastPart = StyledText.EMPTY;
            for (FormattedText part : parts) {
                StyledText text;
                Style lastStyle = ComponentUtils.getLastPartCodes(lastPart);
                lastPart = text = StyledText.fromComponent((Component)Component.literal((String)"").withStyle(lastStyle)).append(StyledText.fromComponent(ComponentUtils.formattedTextToComponent(part)));
                adjustedLines.add(text);
            }
        }
        float calculatedTextHeight = (float)((adjustedLines.size() - 1) * lineHeight) * textScale;
        float renderX = switch (horizontalAlignment) {
            default -> throw new MatchException(null, null);
            case HorizontalAlignment.LEFT -> x1;
            case HorizontalAlignment.CENTER -> (x1 + x2) / 2.0f;
            case HorizontalAlignment.RIGHT -> x2;
        };
        float renderY = switch (verticalAlignment) {
            default -> throw new MatchException(null, null);
            case VerticalAlignment.TOP -> y1;
            case VerticalAlignment.MIDDLE -> (y1 + y2) / 2.0f - calculatedTextHeight / 2.0f;
            case VerticalAlignment.BOTTOM -> y2 - calculatedTextHeight;
        };
        float lineOffset = 0.0f;
        for (StyledText text : adjustedLines) {
            this.renderText(poseStack, bufferSource, text, renderX, renderY + lineOffset, customColor, horizontalAlignment, verticalAlignment, textShadow, textScale);
            lineOffset += (float)lineHeight * textScale;
        }
    }

    public void renderAlignedTextInBox(PoseStack poseStack, MultiBufferSource bufferSource, StyledText text, float x1, float x2, float y1, float y2, float maxWidth, CustomColor customColor, HorizontalAlignment horizontalAlignment, VerticalAlignment verticalAlignment, TextShadow textShadow, float textScale) {
        this.renderAlignedTextInBox(poseStack, bufferSource, new StyledText[]{text}, x1, x2, y1, y2, maxWidth, customColor, horizontalAlignment, verticalAlignment, textShadow, textScale);
    }

    public void renderAlignedTextInBox(PoseStack poseStack, MultiBufferSource bufferSource, StyledText text, float x1, float x2, float y1, float y2, float maxWidth, CustomColor customColor, HorizontalAlignment horizontalAlignment, VerticalAlignment verticalAlignment, TextShadow textShadow) {
        this.renderAlignedTextInBox(poseStack, bufferSource, text, x1, x2, y1, y2, maxWidth, customColor, horizontalAlignment, verticalAlignment, textShadow, 1.0f);
    }

    public void renderAlignedTextInBox(PoseStack poseStack, MultiBufferSource bufferSource, StyledText text, float x1, float x2, float y, float maxWidth, CustomColor customColor, HorizontalAlignment horizontalAlignment, TextShadow textShadow) {
        this.renderAlignedTextInBox(poseStack, bufferSource, text, x1, x2, y, y, maxWidth, customColor, horizontalAlignment, VerticalAlignment.TOP, textShadow, 1.0f);
    }

    public void renderAlignedTextInBox(PoseStack poseStack, MultiBufferSource bufferSource, StyledText text, float x, float y1, float y2, float maxWidth, CustomColor customColor, VerticalAlignment verticalAlignment, TextShadow textShadow) {
        this.renderAlignedTextInBox(poseStack, bufferSource, text, x, x, y1, y2, maxWidth, customColor, HorizontalAlignment.LEFT, verticalAlignment, textShadow, 1.0f);
    }

    public void renderText(PoseStack poseStack, MultiBufferSource bufferSource, StyledText text, float x, float y, CustomColor customColor, HorizontalAlignment horizontalAlignment, VerticalAlignment verticalAlignment, TextShadow shadow) {
        this.renderText(poseStack, bufferSource, text, x, y, customColor, horizontalAlignment, verticalAlignment, shadow, 1.0f);
    }

    private void renderText(PoseStack poseStack, MultiBufferSource bufferSource, StyledText text, float x, float y, float maxWidth, CustomColor customColor, HorizontalAlignment horizontalAlignment, VerticalAlignment verticalAlignment, TextShadow shadow, float textScale) {
        if (text == null) {
            return;
        }
        if (maxWidth == 0.0f || (float)this.font.width((FormattedText)text.getComponent()) < maxWidth / textScale) {
            this.renderText(poseStack, bufferSource, text, x, y, customColor, horizontalAlignment, verticalAlignment, shadow, textScale);
            return;
        }
        List parts = this.font.getSplitter().splitLines((FormattedText)text.getComponent(), (int)(maxWidth / textScale), Style.EMPTY);
        StyledText lastPart = StyledText.EMPTY;
        for (int i = 0; i < parts.size(); ++i) {
            StyledText part;
            Style lastStyle = ComponentUtils.getLastPartCodes(lastPart);
            lastPart = part = StyledText.fromComponent((Component)Component.literal((String)"").withStyle(lastStyle)).append(StyledText.fromComponent(ComponentUtils.formattedTextToComponent((FormattedText)parts.get(i))));
            Objects.requireNonNull(this.font);
            this.renderText(poseStack, bufferSource, part, x, y + (float)(i * 9) * textScale, customColor, horizontalAlignment, verticalAlignment, shadow, textScale);
        }
    }

    public void renderTextsWithAlignment(PoseStack poseStack, MultiBufferSource bufferSource, float x, float y, List<TextRenderTask> toRender, float width, float height, HorizontalAlignment horizontalAlignment, VerticalAlignment verticalAlignment) {
        this.renderTextsWithAlignment(poseStack, bufferSource, x, y, toRender, width, height, horizontalAlignment, verticalAlignment, 1.0f);
    }

    public void renderTextsWithAlignment(PoseStack poseStack, MultiBufferSource bufferSource, float x, float y, List<TextRenderTask> toRender, float width, float height, HorizontalAlignment horizontalAlignment, VerticalAlignment verticalAlignment, float textScale) {
        float renderX = switch (horizontalAlignment) {
            default -> throw new MatchException(null, null);
            case HorizontalAlignment.LEFT -> x;
            case HorizontalAlignment.CENTER -> x + width / 2.0f;
            case HorizontalAlignment.RIGHT -> x + width;
        };
        float renderY = switch (verticalAlignment) {
            default -> throw new MatchException(null, null);
            case VerticalAlignment.TOP -> y;
            case VerticalAlignment.MIDDLE -> y + (height - FontRenderer.getInstance().calculateRenderHeight(toRender)) / 2.0f;
            case VerticalAlignment.BOTTOM -> y + (height - FontRenderer.getInstance().calculateRenderHeight(toRender));
        };
        this.renderTexts(poseStack, bufferSource, renderX, renderY, toRender, textScale);
    }

    public void renderTexts(PoseStack poseStack, MultiBufferSource bufferSource, float x, float y, List<TextRenderTask> lines) {
        this.renderTexts(poseStack, bufferSource, x, y, lines, 1.0f);
    }

    private void renderTexts(PoseStack poseStack, MultiBufferSource bufferSource, float x, float y, List<TextRenderTask> lines, float textScale) {
        float currentY = y;
        for (TextRenderTask line : lines) {
            this.renderText(poseStack, bufferSource, x, currentY, line, textScale);
            currentY += FontRenderer.getInstance().calculateRenderHeight(line.getText(), line.getSetting().maxWidth() / textScale) * textScale;
        }
    }

    public void renderText(PoseStack poseStack, MultiBufferSource bufferSource, float x, float y, TextRenderTask line) {
        this.renderText(poseStack, bufferSource, line.getText(), x, y, line.getSetting().maxWidth(), line.getSetting().customColor(), line.getSetting().horizontalAlignment(), line.getSetting().verticalAlignment(), line.getSetting().shadow());
    }

    private void renderText(PoseStack poseStack, MultiBufferSource bufferSource, float x, float y, TextRenderTask line, float textScale) {
        this.renderText(poseStack, bufferSource, line.getText(), x, y, line.getSetting().maxWidth(), line.getSetting().customColor(), line.getSetting().horizontalAlignment(), line.getSetting().verticalAlignment(), line.getSetting().shadow(), textScale);
    }

    private void renderText(PoseStack poseStack, MultiBufferSource bufferSource, StyledText text, float x, float y, float maxWidth, CustomColor customColor, HorizontalAlignment horizontalAlignment, VerticalAlignment verticalAlignment, TextShadow shadow) {
        this.renderText(poseStack, bufferSource, text, x, y, maxWidth, customColor, horizontalAlignment, verticalAlignment, shadow, 1.0f);
    }

    public void renderTextWithAlignment(PoseStack poseStack, MultiBufferSource bufferSource, float renderX, float renderY, TextRenderTask toRender, float width, float height, HorizontalAlignment horizontalAlignment, VerticalAlignment verticalAlignment) {
        this.renderTextsWithAlignment(poseStack, bufferSource, renderX, renderY, List.of(toRender), width, height, horizontalAlignment, verticalAlignment);
    }
}

