/*
 * Decompiled with CFR 0.152.
 */
package com.wynntils.utils.type;

import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import java.util.function.Supplier;
import java.util.stream.Stream;
import java.util.stream.StreamSupport;

public class TimedSet<T>
implements Iterable<T> {
    private final Set<TimedEntry> entries;
    private final long timeJump;
    private final boolean autoClear;

    public TimedSet(long duration, TimeUnit unit, boolean autoClear) {
        this.timeJump = unit.toMillis(duration);
        this.autoClear = autoClear;
        this.entries = new HashSet<TimedEntry>();
    }

    public TimedSet(long duration, TimeUnit unit, boolean autoClear, Supplier<Set<TimedEntry>> setSupplier) {
        this.timeJump = unit.toMillis(duration);
        this.autoClear = autoClear;
        this.entries = setSupplier.get();
    }

    public TimedSet(long duration, TimeUnit unit) {
        this(duration, unit, false);
    }

    private void releaseEntries() {
        Iterator<TimedEntry> it = this.entries.iterator();
        while (it.hasNext()) {
            TimedEntry entry = it.next();
            if (!entry.shouldRelease()) continue;
            it.remove();
        }
    }

    public void put(T entry) {
        this.entries.add(new TimedEntry(this, entry, System.currentTimeMillis(), this.timeJump));
    }

    public void remove(T entry) {
        this.entries.removeIf(e -> e.getEntry().equals(entry));
    }

    public long getLastAddedTimestamp() {
        Optional<TimedEntry> latest = this.entries.stream().max(Comparator.comparing(TimedEntry::getExpiration));
        if (latest.isEmpty()) {
            return 0L;
        }
        return latest.get().getExpiration() - this.timeJump;
    }

    public void clear() {
        this.entries.clear();
    }

    public int size() {
        return this.entries.size();
    }

    public boolean isEmpty() {
        return this.size() == 0;
    }

    @Override
    public Iterator<T> iterator() {
        if (this.autoClear) {
            this.releaseEntries();
        }
        return new TimedSetIterator();
    }

    public Stream<T> stream() {
        return StreamSupport.stream(this.spliterator(), false);
    }

    public Set<TimedEntry> getEntries() {
        if (this.autoClear) {
            this.releaseEntries();
        }
        return Collections.unmodifiableSet(this.entries);
    }

    public final class TimedEntry {
        private final T entry;
        private final long creation;
        private final long duration;

        private TimedEntry(TimedSet this$0, T entry, long creation, long duration) {
            this.entry = entry;
            this.creation = creation;
            this.duration = duration;
        }

        public long getExpiration() {
            return this.creation + this.duration;
        }

        public long getCreation() {
            return this.creation;
        }

        public T getEntry() {
            return this.entry;
        }

        private boolean shouldRelease() {
            return System.currentTimeMillis() >= this.getExpiration();
        }
    }

    private class TimedSetIterator
    implements Iterator<T> {
        private final Iterator<TimedEntry> original;

        private TimedSetIterator() {
            this.original = TimedSet.this.entries.iterator();
        }

        @Override
        public boolean hasNext() {
            return this.original.hasNext();
        }

        @Override
        public T next() {
            return this.original.next().getEntry();
        }

        @Override
        public void remove() {
            this.original.remove();
        }
    }
}

