/*
 * Decompiled with CFR 0.152.
 */
package com.wynntils.utils.wynn;

import com.wynntils.utils.mc.McUtils;
import it.unimi.dsi.fastutil.ints.Int2ObjectMap;
import it.unimi.dsi.fastutil.ints.Int2ObjectOpenHashMap;
import java.util.List;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.gui.screens.inventory.AbstractContainerScreen;
import net.minecraft.core.NonNullList;
import net.minecraft.network.protocol.game.ServerboundContainerClickPacket;
import net.minecraft.network.protocol.game.ServerboundContainerClosePacket;
import net.minecraft.world.inventory.ClickType;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;

public final class ContainerUtils {
    private static final int INVENTORY_SLOTS = 36;

    public static NonNullList<ItemStack> getItems(Screen screen) {
        if (screen instanceof AbstractContainerScreen) {
            AbstractContainerScreen containerScreen = (AbstractContainerScreen)screen;
            return containerScreen.getMenu().getItems();
        }
        return NonNullList.create();
    }

    public static boolean openInventory(int slotNum) {
        int containerId = McUtils.containerMenu().containerId;
        if (containerId != 0) {
            return false;
        }
        NonNullList items = McUtils.containerMenu().getItems();
        ContainerUtils.clickOnSlot(36 + slotNum, containerId, 0, (List<ItemStack>)items);
        return true;
    }

    public static void clickOnSlot(int clickedSlot, int containerId, int mouseButton, List<ItemStack> items) {
        Int2ObjectOpenHashMap changedSlots = new Int2ObjectOpenHashMap();
        changedSlots.put(clickedSlot, (Object)new ItemStack((ItemLike)Items.AIR));
        int transactionId = 0;
        McUtils.sendPacket(new ServerboundContainerClickPacket(containerId, transactionId, clickedSlot, mouseButton, ClickType.PICKUP, items.get(clickedSlot), (Int2ObjectMap)changedSlots));
    }

    public static void shiftClickOnSlot(int clickedSlot, int containerId, int mouseButton, List<ItemStack> items) {
        Int2ObjectOpenHashMap changedSlots = new Int2ObjectOpenHashMap();
        changedSlots.put(clickedSlot, (Object)new ItemStack((ItemLike)Items.AIR));
        int transactionId = 0;
        McUtils.sendPacket(new ServerboundContainerClickPacket(containerId, transactionId, clickedSlot, mouseButton, ClickType.QUICK_MOVE, items.get(clickedSlot), (Int2ObjectMap)changedSlots));
    }

    public static void pressKeyOnSlot(int clickedSlot, int containerId, int buttonNum, List<ItemStack> items) {
        Int2ObjectOpenHashMap changedSlots = new Int2ObjectOpenHashMap();
        changedSlots.put(clickedSlot, (Object)new ItemStack((ItemLike)Items.AIR));
        int transactionId = 0;
        McUtils.sendPacket(new ServerboundContainerClickPacket(containerId, transactionId, clickedSlot, buttonNum, ClickType.SWAP, items.get(clickedSlot), (Int2ObjectMap)changedSlots));
    }

    public static void closeContainer(int containerId) {
        McUtils.sendPacket(new ServerboundContainerClosePacket(containerId));
    }

    public static void closeBackgroundContainer() {
        McUtils.sendPacket(new ServerboundContainerClosePacket(McUtils.player().containerMenu.containerId));
        McUtils.player().containerMenu = McUtils.player().inventoryMenu;
    }
}

