/*
 * Decompiled with CFR 0.152.
 */
package com.wynntils.commands;

import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.StringArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.suggestion.SuggestionProvider;
import com.mojang.brigadier.suggestion.SuggestionsBuilder;
import com.wynntils.core.components.Managers;
import com.wynntils.core.consumers.commands.Command;
import com.wynntils.core.consumers.features.Feature;
import com.wynntils.core.persisted.config.Category;
import java.util.List;
import java.util.Optional;
import net.minecraft.class_124;
import net.minecraft.class_2168;
import net.minecraft.class_2170;
import net.minecraft.class_2172;
import net.minecraft.class_2561;
import net.minecraft.class_5250;
import net.minecraft.class_7157;

public class FeatureCommand
extends Command {
    private static final SuggestionProvider<class_2168> FEATURE_SUGGESTION_PROVIDER = (context, builder) -> class_2172.method_9264(Managers.Feature.getFeatures().stream().map(Feature::getShortName), (SuggestionsBuilder)builder);

    @Override
    public String getCommandName() {
        return "feature";
    }

    @Override
    public LiteralArgumentBuilder<class_2168> getCommandBuilder(LiteralArgumentBuilder<class_2168> base, class_7157 context) {
        return (LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)base.then(class_2170.method_9247((String)"list").executes(this::listFeatures))).then(class_2170.method_9247((String)"enable").then(class_2170.method_9244((String)"feature", (ArgumentType)StringArgumentType.word()).suggests(FEATURE_SUGGESTION_PROVIDER).executes(this::enableFeature)))).then(class_2170.method_9247((String)"disable").then(class_2170.method_9244((String)"feature", (ArgumentType)StringArgumentType.word()).suggests(FEATURE_SUGGESTION_PROVIDER).executes(this::disableFeature)))).then(class_2170.method_9247((String)"reload").then(class_2170.method_9244((String)"feature", (ArgumentType)StringArgumentType.word()).suggests(FEATURE_SUGGESTION_PROVIDER).executes(this::reloadFeature)))).executes(this::syntaxError);
    }

    private int listFeatures(CommandContext<class_2168> context) {
        List features = Managers.Feature.getFeatures().stream().sorted(Feature::compareTo).toList();
        class_5250 response = class_2561.method_43470((String)"Currently registered features:").method_27692(class_124.field_1075);
        Category lastCategory = null;
        for (Feature feature : features) {
            class_124 color;
            String translatedName = feature.getTranslatedName();
            class_124 class_1242 = color = feature.isEnabled() ? class_124.field_1060 : class_124.field_1061;
            if (lastCategory != feature.getCategory()) {
                lastCategory = feature.getCategory();
                response.method_10852((class_2561)class_2561.method_43470((String)("\n" + lastCategory.toString() + ":")).method_27692(class_124.field_1076).method_27692(class_124.field_1067));
            }
            response.method_10852((class_2561)class_2561.method_43470((String)"\n - ").method_27692(class_124.field_1080)).method_10852((class_2561)class_2561.method_43470((String)translatedName).method_27692(color));
        }
        ((class_2168)context.getSource()).method_9226(() -> response, false);
        return 1;
    }

    private int enableFeature(CommandContext<class_2168> context) {
        String featureName = (String)context.getArgument("feature", String.class);
        Optional<Feature> featureOptional = Managers.Feature.getFeatureFromString(featureName);
        if (featureOptional.isEmpty()) {
            ((class_2168)context.getSource()).method_9213((class_2561)class_2561.method_43470((String)"Feature not found!").method_27692(class_124.field_1061));
            return 0;
        }
        Feature feature = featureOptional.get();
        if (feature.isEnabled()) {
            ((class_2168)context.getSource()).method_9213((class_2561)class_2561.method_43470((String)("Feature " + feature.getTranslatedName() + " is already enabled!")).method_27692(class_124.field_1061));
            return 1;
        }
        feature.setUserEnabled(true);
        if (!feature.isEnabled()) {
            ((class_2168)context.getSource()).method_9213((class_2561)class_2561.method_43470((String)("Feature " + feature.getTranslatedName() + " could not be enabled!")).method_27692(class_124.field_1061));
            return 1;
        }
        Managers.Config.saveConfig();
        ((class_2168)context.getSource()).method_9226(() -> class_2561.method_43470((String)(feature.getTranslatedName() + " was enabled successfully.")).method_27692(class_124.field_1060), false);
        return 1;
    }

    private int disableFeature(CommandContext<class_2168> context) {
        String featureName = (String)context.getArgument("feature", String.class);
        Optional<Feature> featureOptional = Managers.Feature.getFeatureFromString(featureName);
        if (featureOptional.isEmpty()) {
            ((class_2168)context.getSource()).method_9213((class_2561)class_2561.method_43470((String)"Feature not found!").method_27692(class_124.field_1061));
            return 0;
        }
        Feature feature = featureOptional.get();
        if (!feature.isEnabled()) {
            ((class_2168)context.getSource()).method_9213((class_2561)class_2561.method_43470((String)("Feature " + feature.getTranslatedName() + " is already disabled!")).method_27692(class_124.field_1061));
            return 1;
        }
        feature.setUserEnabled(false);
        if (feature.isEnabled()) {
            ((class_2168)context.getSource()).method_9213((class_2561)class_2561.method_43470((String)("Feature " + feature.getTranslatedName() + " could not be disabled!")).method_27692(class_124.field_1061));
            return 1;
        }
        Managers.Config.saveConfig();
        ((class_2168)context.getSource()).method_9226(() -> class_2561.method_43470((String)(feature.getTranslatedName() + " was disabled successfully.")).method_27692(class_124.field_1060), false);
        return 1;
    }

    private int reloadFeature(CommandContext<class_2168> context) {
        String featureName = (String)context.getArgument("feature", String.class);
        Optional<Feature> featureOptional = Managers.Feature.getFeatureFromString(featureName);
        if (featureOptional.isEmpty()) {
            ((class_2168)context.getSource()).method_9213((class_2561)class_2561.method_43470((String)"Feature not found!").method_27692(class_124.field_1061));
            return 0;
        }
        Feature feature = featureOptional.get();
        if (!feature.isEnabled()) {
            ((class_2168)context.getSource()).method_9213((class_2561)class_2561.method_43470((String)("Feature " + feature.getTranslatedName() + " is already disabled, cannot reload a disabled feature!")).method_27692(class_124.field_1061));
            return 1;
        }
        Managers.Feature.disableFeature(feature, false);
        if (feature.isEnabled()) {
            ((class_2168)context.getSource()).method_9213((class_2561)class_2561.method_43470((String)("Feature " + feature.getTranslatedName() + " could not be disabled!")).method_27692(class_124.field_1061));
            return 1;
        }
        Managers.Feature.enableFeature(feature);
        if (!feature.isEnabled()) {
            ((class_2168)context.getSource()).method_9213((class_2561)class_2561.method_43470((String)("Feature " + feature.getTranslatedName() + " could not be enabled!")).method_27692(class_124.field_1061));
            return 1;
        }
        ((class_2168)context.getSource()).method_9226(() -> class_2561.method_43470((String)(feature.getTranslatedName() + " was reloaded successfully.")).method_27692(class_124.field_1060), false);
        return 1;
    }

    private int syntaxError(CommandContext<class_2168> context) {
        ((class_2168)context.getSource()).method_9213((class_2561)class_2561.method_43470((String)"Missing argument").method_27692(class_124.field_1061));
        return 0;
    }
}

