/*
 * Decompiled with CFR 0.152.
 */
package com.wynntils.commands;

import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.StringArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.suggestion.SuggestionProvider;
import com.mojang.brigadier.suggestion.SuggestionsBuilder;
import com.wynntils.core.components.Services;
import com.wynntils.core.consumers.commands.Command;
import com.wynntils.services.map.pois.LabelPoi;
import com.wynntils.services.map.pois.Poi;
import com.wynntils.services.map.pois.ServicePoi;
import com.wynntils.services.map.type.ServiceKind;
import com.wynntils.utils.StringUtils;
import com.wynntils.utils.mc.McUtils;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.List;
import java.util.Optional;
import net.minecraft.class_124;
import net.minecraft.class_2168;
import net.minecraft.class_2170;
import net.minecraft.class_2172;
import net.minecraft.class_243;
import net.minecraft.class_2558;
import net.minecraft.class_2561;
import net.minecraft.class_5250;
import net.minecraft.class_7157;

public class LocateCommand
extends Command {
    public static final SuggestionProvider<class_2168> SERVICE_SUGGESTION_PROVIDER = (context, builder) -> class_2172.method_9264(Arrays.stream(ServiceKind.values()).map(ServiceKind::getName), (SuggestionsBuilder)builder);
    public static final SuggestionProvider<class_2168> PLACES_SUGGESTION_PROVIDER = (context, builder) -> class_2172.method_9264(Services.Poi.getLabelPois().map(Poi::getName), (SuggestionsBuilder)builder);

    @Override
    public String getCommandName() {
        return "locate";
    }

    @Override
    public LiteralArgumentBuilder<class_2168> getCommandBuilder(LiteralArgumentBuilder<class_2168> base, class_7157 context) {
        return (LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)base.then(class_2170.method_9247((String)"service").then(class_2170.method_9244((String)"name", (ArgumentType)StringArgumentType.greedyString()).suggests(SERVICE_SUGGESTION_PROVIDER).executes(this::locateService)))).then(class_2170.method_9247((String)"place").then(class_2170.method_9244((String)"name", (ArgumentType)StringArgumentType.greedyString()).suggests(PLACES_SUGGESTION_PROVIDER).executes(this::locatePlace)))).then(class_2170.method_9247((String)"npc").then(class_2170.method_9244((String)"name", (ArgumentType)StringArgumentType.greedyString()).executes(this::notImplemented)))).then(class_2170.method_9247((String)"other").then(class_2170.method_9244((String)"name", (ArgumentType)StringArgumentType.greedyString()).executes(this::notImplemented)))).executes(this::syntaxError);
    }

    public static ServiceKind getServiceKind(CommandContext<class_2168> context, String searchedName) {
        List<ServiceKind> matchedKinds = Arrays.stream(ServiceKind.values()).filter(kind -> StringUtils.partialMatch(kind.getName(), searchedName)).toList();
        if (matchedKinds.isEmpty()) {
            class_5250 response = class_2561.method_43470((String)("Found no services matching '" + searchedName + "'")).method_27692(class_124.field_1061);
            ((class_2168)context.getSource()).method_9213((class_2561)response);
            return null;
        }
        if (matchedKinds.size() > 1) {
            Optional<ServiceKind> exactMatch = matchedKinds.stream().filter(k -> k.getName().equals(searchedName)).findFirst();
            if (exactMatch.isPresent()) {
                return exactMatch.get();
            }
            class_5250 response = class_2561.method_43470((String)("Found multiple services matching '" + searchedName + "'. Pleace specify with more detail. Matching: ")).method_27692(class_124.field_1061);
            response.method_10852((class_2561)class_2561.method_43470((String)String.join((CharSequence)", ", matchedKinds.stream().map(ServiceKind::getName).toList())));
            ((class_2168)context.getSource()).method_9213((class_2561)response);
            return null;
        }
        return matchedKinds.getFirst();
    }

    private int locateService(CommandContext<class_2168> context) {
        String searchedName = (String)context.getArgument("name", String.class);
        ServiceKind selectedKind = LocateCommand.getServiceKind(context, searchedName);
        if (selectedKind == null) {
            return 0;
        }
        ArrayList<ServicePoi> services = new ArrayList<ServicePoi>(Services.Poi.getServicePois().filter(poi -> poi.getKind() == selectedKind).toList());
        class_243 currentLocation = McUtils.player().method_19538();
        services.sort(Comparator.comparingDouble(poi -> currentLocation.method_1028((double)poi.getLocation().getX(), (double)poi.getLocation().getY().orElse((int)currentLocation.field_1351).intValue(), (double)poi.getLocation().getZ())));
        if (services.size() > 4) {
            services.subList(4, services.size()).clear();
        }
        class_5250 response = class_2561.method_43470((String)("Found " + selectedKind.getName() + " services:")).method_27692(class_124.field_1075);
        for (Poi poi2 : services) {
            response.method_10852((class_2561)class_2561.method_43470((String)"\n - ").method_27692(class_124.field_1080)).method_10852((class_2561)class_2561.method_43470((String)(poi2.getName() + " ")).method_27692(class_124.field_1054).method_27694(style -> style.method_10958(new class_2558(class_2558.class_2559.field_11750, "/compass at " + service.getLocation().asChatCoordinates())))).method_10852((class_2561)class_2561.method_43470((String)poi2.getLocation().toString()).method_27692(class_124.field_1068).method_27694(style -> style.method_10958(new class_2558(class_2558.class_2559.field_11750, "/compass at " + service.getLocation().asChatCoordinates()))));
        }
        ((class_2168)context.getSource()).method_9226(() -> response, false);
        return 1;
    }

    private int locatePlace(CommandContext<class_2168> context) {
        String searchedName = (String)context.getArgument("name", String.class);
        ArrayList<LabelPoi> places = new ArrayList<LabelPoi>(Services.Poi.getLabelPois().filter(poi -> StringUtils.partialMatch(poi.getName(), searchedName)).toList());
        if (places.isEmpty()) {
            class_5250 response = class_2561.method_43470((String)("Found no places matching '" + searchedName + "'")).method_27692(class_124.field_1061);
            ((class_2168)context.getSource()).method_9213((class_2561)response);
            return 0;
        }
        class_243 currentLocation = McUtils.player().method_19538();
        places.sort(Comparator.comparingDouble(poi -> currentLocation.method_1028((double)poi.getLocation().getX(), (double)poi.getLocation().getY().orElse((int)currentLocation.field_1351).intValue(), (double)poi.getLocation().getZ())));
        class_5250 response = class_2561.method_43470((String)("Found places matching '" + searchedName + "':")).method_27692(class_124.field_1075);
        for (Poi poi2 : places) {
            response.method_10852((class_2561)class_2561.method_43470((String)"\n - ").method_27692(class_124.field_1080)).method_10852((class_2561)class_2561.method_43470((String)(poi2.getName() + " ")).method_27692(class_124.field_1054).method_27694(style -> style.method_10958(new class_2558(class_2558.class_2559.field_11750, "/compass place " + place.getName())))).method_10852((class_2561)class_2561.method_43470((String)poi2.getLocation().toString()).method_27692(class_124.field_1068).method_27694(style -> style.method_10958(new class_2558(class_2558.class_2559.field_11750, "/compass place " + place.getName()))));
        }
        ((class_2168)context.getSource()).method_9226(() -> response, false);
        return 1;
    }

    private int notImplemented(CommandContext<class_2168> context) {
        ((class_2168)context.getSource()).method_9213((class_2561)class_2561.method_43470((String)"Not implemented yet").method_27692(class_124.field_1061));
        return 0;
    }

    private int syntaxError(CommandContext<class_2168> context) {
        ((class_2168)context.getSource()).method_9213((class_2561)class_2561.method_43470((String)"Missing argument").method_27692(class_124.field_1061));
        return 0;
    }
}

