/*
 * Decompiled with CFR 0.152.
 */
package com.wynntils.commands;

import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.StringArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.suggestion.SuggestionProvider;
import com.mojang.brigadier.suggestion.SuggestionsBuilder;
import com.wynntils.core.WynntilsMod;
import com.wynntils.core.components.Models;
import com.wynntils.core.consumers.commands.Command;
import com.wynntils.models.guild.type.GuildInfo;
import com.wynntils.models.guild.type.GuildMemberInfo;
import com.wynntils.models.guild.type.GuildRank;
import com.wynntils.utils.mc.McUtils;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import net.minecraft.class_124;
import net.minecraft.class_2168;
import net.minecraft.class_2170;
import net.minecraft.class_2172;
import net.minecraft.class_2558;
import net.minecraft.class_2561;
import net.minecraft.class_2568;
import net.minecraft.class_5250;
import net.minecraft.class_7157;

public class OnlineMembersCommand
extends Command {
    private static final SuggestionProvider<class_2168> GUILD_SUGGESTION_PROVIDER = (context, builder) -> class_2172.method_9265(Models.Guild.getAllGuilds(), (SuggestionsBuilder)builder);

    @Override
    public String getCommandName() {
        return "onlinemembers";
    }

    @Override
    public List<String> getAliases() {
        return List.of("om");
    }

    @Override
    public LiteralArgumentBuilder<class_2168> getCommandBuilder(LiteralArgumentBuilder<class_2168> base, class_7157 context) {
        return (LiteralArgumentBuilder)((LiteralArgumentBuilder)base.then(class_2170.method_9244((String)"guildName", (ArgumentType)StringArgumentType.greedyString()).suggests(GUILD_SUGGESTION_PROVIDER).executes(this::lookupGuild))).executes(this::syntaxError);
    }

    private int lookupGuild(CommandContext<class_2168> context) {
        CompletableFuture<GuildInfo> completableFuture = Models.Guild.getGuild((String)context.getArgument("guildName", String.class));
        completableFuture.whenComplete((guild, throwable) -> {
            if (throwable != null) {
                McUtils.sendMessageToClient((class_2561)class_2561.method_43470((String)("Unable to view online members for " + (String)context.getArgument("guildName", String.class))).method_27692(class_124.field_1061));
                WynntilsMod.error("Error trying to parse guild online members", throwable);
            } else {
                if (guild == null) {
                    McUtils.sendMessageToClient((class_2561)class_2561.method_43470((String)("Unknown guild " + (String)context.getArgument("guildName", String.class))).method_27692(class_124.field_1061));
                    return;
                }
                class_5250 response = class_2561.method_43470((String)(guild.name() + " [" + guild.prefix() + "]")).method_27692(class_124.field_1062);
                response.method_10852((class_2561)class_2561.method_43470((String)" has ").method_27692(class_124.field_1080));
                response.method_10852((class_2561)class_2561.method_43470((String)(guild.onlineMembers() + "/" + guild.totalMembers())).method_27692(class_124.field_1065)).method_10852((class_2561)class_2561.method_43470((String)" members currently online:").method_27692(class_124.field_1080));
                List<GuildRank> guildRanks = Arrays.asList(GuildRank.values());
                Collections.reverse(guildRanks);
                for (GuildRank guildRank : guildRanks) {
                    List<GuildMemberInfo> onlineRankMembers = guild.getOnlineMembersbyRank(guildRank);
                    if (onlineRankMembers.isEmpty()) continue;
                    response.method_10852((class_2561)class_2561.method_43470((String)("\n" + guildRank.getGuildDescription() + ":\n")).method_27692(class_124.field_1065));
                    for (GuildMemberInfo guildMember : onlineRankMembers) {
                        response.method_10852((class_2561)class_2561.method_43470((String)guildMember.username()).method_27692(class_124.field_1075).method_27694(style -> style.method_10949(new class_2568(class_2568.class_5247.field_24342, (Object)class_2561.method_43470((String)("Click to private message " + guildMember.username())).method_27692(class_124.field_1080))).method_10958(new class_2558(class_2558.class_2559.field_11745, "/msg " + guildMember.username() + " "))));
                        if (onlineRankMembers.indexOf(guildMember) == onlineRankMembers.size() - 1) continue;
                        response.method_10852((class_2561)class_2561.method_43470((String)", ").method_27692(class_124.field_1080));
                    }
                }
                McUtils.sendMessageToClient((class_2561)response);
            }
        });
        ((class_2168)context.getSource()).method_9226(() -> class_2561.method_43471((String)"command.wynntils.onlineMembers.lookingUp").method_27692(class_124.field_1060), false);
        return 1;
    }

    private int syntaxError(CommandContext<class_2168> context) {
        ((class_2168)context.getSource()).method_9213((class_2561)class_2561.method_43470((String)"Missing argument").method_27692(class_124.field_1061));
        return 0;
    }
}

