/*
 * Decompiled with CFR 0.152.
 */
package com.wynntils.commands;

import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.StringArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.suggestion.SuggestionProvider;
import com.mojang.brigadier.suggestion.SuggestionsBuilder;
import com.wynntils.core.components.Models;
import com.wynntils.core.consumers.commands.Command;
import com.wynntils.models.activities.quests.QuestInfo;
import com.wynntils.models.activities.type.ActivitySortOrder;
import com.wynntils.utils.StringUtils;
import com.wynntils.utils.mc.McUtils;
import java.util.Arrays;
import java.util.List;
import java.util.Locale;
import net.minecraft.class_124;
import net.minecraft.class_2168;
import net.minecraft.class_2170;
import net.minecraft.class_2172;
import net.minecraft.class_243;
import net.minecraft.class_2558;
import net.minecraft.class_2561;
import net.minecraft.class_2568;
import net.minecraft.class_5250;
import net.minecraft.class_7157;

public class QuestCommand
extends Command {
    private static final SuggestionProvider<class_2168> QUEST_SUGGESTION_PROVIDER = (context, builder) -> class_2172.method_9264(Models.Quest.getQuests(ActivitySortOrder.ALPHABETIC).stream().map(QuestInfo::name), (SuggestionsBuilder)builder);
    private static final SuggestionProvider<class_2168> SORT_SUGGESTION_PROVIDER = (context, builder) -> class_2172.method_9264(Arrays.stream(ActivitySortOrder.values()).map(order -> order.name().toLowerCase(Locale.ROOT)), (SuggestionsBuilder)builder);

    @Override
    public String getCommandName() {
        return "quest";
    }

    @Override
    public LiteralArgumentBuilder<class_2168> getCommandBuilder(LiteralArgumentBuilder<class_2168> base, class_7157 context) {
        return (LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)base.then(((LiteralArgumentBuilder)class_2170.method_9247((String)"list").executes(ctxt -> this.listQuests((CommandContext<class_2168>)ctxt, "distance"))).then(class_2170.method_9244((String)"sort", (ArgumentType)StringArgumentType.word()).suggests(SORT_SUGGESTION_PROVIDER).executes(ctxt -> this.listQuests((CommandContext<class_2168>)ctxt, (String)ctxt.getArgument("sort", String.class)))))).then(class_2170.method_9247((String)"search").then(class_2170.method_9244((String)"text", (ArgumentType)StringArgumentType.greedyString()).executes(this::searchQuests)))).then(class_2170.method_9247((String)"info").then(class_2170.method_9244((String)"quest", (ArgumentType)StringArgumentType.greedyString()).suggests(QUEST_SUGGESTION_PROVIDER).executes(this::questInfo)))).then(class_2170.method_9247((String)"track").then(class_2170.method_9244((String)"quest", (ArgumentType)StringArgumentType.greedyString()).suggests(QUEST_SUGGESTION_PROVIDER).executes(this::trackQuest)))).then(class_2170.method_9247((String)"untrack").executes(this::untrackQuest))).then(class_2170.method_9247((String)"wiki").then(class_2170.method_9244((String)"quest", (ArgumentType)StringArgumentType.greedyString()).suggests(QUEST_SUGGESTION_PROVIDER).executes(this::lookupOnWiki)))).executes(this::syntaxError);
    }

    private int listQuests(CommandContext<class_2168> context, String sort) {
        List<QuestInfo> quests;
        ActivitySortOrder order = ActivitySortOrder.fromString(sort);
        Models.Quest.rescanQuestBook(true, false);
        if (Models.Quest.getQuestsRaw().isEmpty()) {
            ((class_2168)context.getSource()).method_9226(() -> class_2561.method_43470((String)"Quest Book was not scanned. You might have to retry this command.").method_27692(class_124.field_1054), false);
        }
        if ((quests = Models.Quest.getQuests(order).stream().filter(QuestInfo::trackable).toList()).isEmpty()) {
            ((class_2168)context.getSource()).method_9213((class_2561)class_2561.method_43470((String)"No active quests found!").method_27692(class_124.field_1061));
            return 1;
        }
        class_5250 response = class_2561.method_43470((String)"Active quests:").method_27692(class_124.field_1075);
        this.generateQuestList(quests, response);
        ((class_2168)context.getSource()).method_9226(() -> response, false);
        return 1;
    }

    private int searchQuests(CommandContext<class_2168> context) {
        List<QuestInfo> quests;
        String searchText = (String)context.getArgument("text", String.class);
        Models.Quest.rescanQuestBook(true, false);
        if (Models.Quest.getQuestsRaw().isEmpty()) {
            ((class_2168)context.getSource()).method_9226(() -> class_2561.method_43470((String)"Quest Book was not scanned. You might have to retry this command.").method_27692(class_124.field_1054), false);
        }
        if ((quests = Models.Quest.getQuestsRaw().stream().filter(quest -> StringUtils.initialMatch(quest.name(), searchText) || StringUtils.initialMatch(quest.nextTask().getStringWithoutFormatting(), searchText)).toList()).isEmpty()) {
            ((class_2168)context.getSource()).method_9213((class_2561)class_2561.method_43470((String)"No matching quests found!").method_27692(class_124.field_1061));
            return 1;
        }
        class_5250 response = class_2561.method_43470((String)"Matching quests:").method_27692(class_124.field_1075);
        this.generateQuestList(quests, response);
        ((class_2168)context.getSource()).method_9226(() -> response, false);
        return 1;
    }

    private void generateQuestList(List<QuestInfo> quests, class_5250 response) {
        class_243 playerLocation = McUtils.player().method_19538();
        for (QuestInfo quest : quests) {
            double distance = quest.nextLocation().isEmpty() ? 0.0 : playerLocation.method_1022(quest.nextLocation().get().toVec3());
            response.method_10852((class_2561)class_2561.method_43470((String)"\n - ").method_27692(class_124.field_1080)).method_10852((class_2561)class_2561.method_43470((String)quest.name()).method_27694(style -> style.method_10958(new class_2558(class_2558.class_2559.field_11750, "/quest info " + quest.name()))).method_27694(style -> style.method_10949(new class_2568(class_2568.class_5247.field_24342, (Object)class_2561.method_43470((String)"Click for info")))).method_27692(class_124.field_1068));
            if (distance > 0.0) {
                response.method_10852((class_2561)class_2561.method_43470((String)(" (" + (int)Math.round(distance) + " m)")).method_27692(class_124.field_1077));
            }
            if (!quest.equals(Models.Activity.getTrackedQuestInfo())) continue;
            response.method_10852((class_2561)class_2561.method_43470((String)" [Tracked]").method_27692(class_124.field_1062).method_27694(style -> style.method_10958(new class_2558(class_2558.class_2559.field_11750, "/quest untrack"))).method_27694(style -> style.method_10949(new class_2568(class_2568.class_5247.field_24342, (Object)class_2561.method_43470((String)"Click to stop tracking")))));
        }
    }

    private int questInfo(CommandContext<class_2168> context) {
        String questName = (String)context.getArgument("quest", String.class);
        QuestInfo quest = this.getQuestInfo(context, questName);
        if (quest == null) {
            return 0;
        }
        class_5250 response = class_2561.method_43470((String)("Info for quest: " + quest.name())).method_27692(class_124.field_1075);
        response.method_10852((class_2561)class_2561.method_43470((String)"\n - Status: ").method_27692(class_124.field_1068)).method_10852(quest.status().getQuestStateComponent()).method_10852((class_2561)class_2561.method_43470((String)"\n - Level: ").method_27692(class_124.field_1068)).method_10852((class_2561)class_2561.method_43470((String)Integer.toString(quest.level())).method_27692(class_124.field_1054)).method_10852((class_2561)class_2561.method_43470((String)"\n - Length: ").method_27692(class_124.field_1068)).method_10852((class_2561)class_2561.method_43470((String)StringUtils.capitalized(quest.length().toString())).method_27692(class_124.field_1054)).method_10852((class_2561)class_2561.method_43470((String)"\n - Next task: ").method_27692(class_124.field_1068)).method_10852((class_2561)quest.nextTask().getComponent().method_27692(class_124.field_1080)).method_10852((class_2561)class_2561.method_43470((String)"\n")).method_10852((class_2561)class_2561.method_43470((String)"[Track quest]").method_27694(style -> style.method_10958(new class_2558(class_2558.class_2559.field_11750, "/quest track " + quest.name())).method_10949(new class_2568(class_2568.class_5247.field_24342, (Object)class_2561.method_43470((String)"Click to track quest")))).method_27692(class_124.field_1062)).method_10852((class_2561)class_2561.method_43470((String)" ")).method_10852((class_2561)class_2561.method_43470((String)"[Lookup on wiki]").method_27694(style -> style.method_10958(new class_2558(class_2558.class_2559.field_11750, "/quest wiki " + quest.name())).method_10949(new class_2568(class_2568.class_5247.field_24342, (Object)class_2561.method_43470((String)"Click to lookup quest on wiki")))).method_27692(class_124.field_1062));
        ((class_2168)context.getSource()).method_9226(() -> response, false);
        return 1;
    }

    private int trackQuest(CommandContext<class_2168> context) {
        String questName = (String)context.getArgument("quest", String.class);
        QuestInfo quest = this.getQuestInfo(context, questName);
        if (quest == null) {
            return 0;
        }
        Models.Quest.startTracking(quest);
        class_5250 response = class_2561.method_43470((String)("Now tracking quest " + quest.name())).method_27692(class_124.field_1075);
        ((class_2168)context.getSource()).method_9226(() -> response, false);
        return 1;
    }

    private int untrackQuest(CommandContext<class_2168> context) {
        QuestInfo trackedQuest = Models.Activity.getTrackedQuestInfo();
        if (trackedQuest == null) {
            ((class_2168)context.getSource()).method_9213((class_2561)class_2561.method_43470((String)"No quest currently tracked").method_27692(class_124.field_1061));
            return 0;
        }
        Models.Quest.stopTracking();
        class_5250 response = class_2561.method_43470((String)("Stopped tracking quest " + trackedQuest.name())).method_27692(class_124.field_1075);
        ((class_2168)context.getSource()).method_9226(() -> response, false);
        return 1;
    }

    private int lookupOnWiki(CommandContext<class_2168> context) {
        String questName = (String)context.getArgument("quest", String.class);
        QuestInfo quest = this.getQuestInfo(context, questName);
        if (quest == null) {
            return 0;
        }
        Models.Quest.openQuestOnWiki(quest);
        class_5250 response = class_2561.method_43470((String)("Quest opened on wiki " + quest.name())).method_27692(class_124.field_1075);
        ((class_2168)context.getSource()).method_9226(() -> response, false);
        return 1;
    }

    private int syntaxError(CommandContext<class_2168> context) {
        ((class_2168)context.getSource()).method_9213((class_2561)class_2561.method_43470((String)"Missing argument").method_27692(class_124.field_1061));
        return 0;
    }

    private QuestInfo getQuestInfo(CommandContext<class_2168> context, String questName) {
        String questNameLowerCase = questName.toLowerCase(Locale.ROOT);
        List<QuestInfo> matchingQuests = Models.Quest.getQuestsRaw().stream().filter(questInfo -> questInfo.name().toLowerCase(Locale.ROOT).contains(questNameLowerCase)).toList();
        if (matchingQuests.isEmpty()) {
            ((class_2168)context.getSource()).method_9213((class_2561)class_2561.method_43470((String)("Quest '" + questName + "' not found")).method_27692(class_124.field_1061));
            return null;
        }
        if (matchingQuests.size() > 1) {
            class_5250 error = class_2561.method_43470((String)("Quest '" + questName + "' match several quests:")).method_27692(class_124.field_1061);
            for (QuestInfo quest : matchingQuests) {
                error.method_10852((class_2561)class_2561.method_43470((String)"\n - ").method_27692(class_124.field_1080)).method_10852((class_2561)class_2561.method_43470((String)quest.name()).method_27692(class_124.field_1068));
            }
            ((class_2168)context.getSource()).method_9213((class_2561)error);
            return null;
        }
        return matchingQuests.getFirst();
    }
}

