/*
 * Decompiled with CFR 0.152.
 */
package com.wynntils.core.consumers.features;

import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.tree.CommandNode;
import com.mojang.brigadier.tree.LiteralCommandNode;
import com.wynntils.core.WynntilsMod;
import com.wynntils.core.components.Managers;
import com.wynntils.core.consumers.features.Feature;
import com.wynntils.core.consumers.features.properties.RegisterCommand;
import java.lang.reflect.Field;
import net.minecraft.class_2168;
import net.minecraft.class_2170;
import org.apache.commons.lang3.reflect.FieldUtils;

public class FeatureCommands {
    private final LiteralArgumentBuilder<class_2168> commandNodeBuilder = class_2170.method_9247((String)"execute");
    private LiteralCommandNode<class_2168> commandNode;

    public void discoverCommands(Feature feature) {
        for (Field f : FieldUtils.getFieldsWithAnnotation(feature.getClass(), RegisterCommand.class)) {
            if (!f.getType().equals(LiteralCommandNode.class)) {
                WynntilsMod.error("Incorrect type for @RegisterCommand " + f.getName() + " in " + feature.getClass().getName());
                return;
            }
            try {
                LiteralCommandNode node = (LiteralCommandNode)FieldUtils.readField((Field)f, (Object)feature, (boolean)true);
                LiteralCommandNode featureNode = class_2170.method_9247((String)feature.getShortName()).build();
                featureNode.addChild((CommandNode)node);
                this.commandNodeBuilder.then((CommandNode)featureNode);
            }
            catch (IllegalAccessException e) {
                WynntilsMod.error("Failed reading field of @RegisterCommand " + f.getName() + " in " + feature.getClass().getName(), e);
            }
        }
    }

    public void init() {
        if (this.commandNode == null) {
            this.commandNode = this.commandNodeBuilder.build();
        }
        Managers.Command.addNodeToClientDispatcher(this.commandNodeBuilder);
    }

    public LiteralCommandNode<class_2168> getCommandNode() {
        assert (this.commandNode != null);
        return this.commandNode;
    }
}

