/*
 * Decompiled with CFR 0.152.
 */
package com.wynntils.core.json;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import com.google.gson.JsonParser;
import com.google.gson.stream.JsonReader;
import com.wynntils.core.WynntilsMod;
import com.wynntils.core.components.Manager;
import com.wynntils.core.crowdsource.CrowdSourcedData;
import com.wynntils.core.json.JsonTypeWrapper;
import com.wynntils.core.text.StyledText;
import com.wynntils.services.itemrecord.type.SavedItem;
import com.wynntils.utils.EnumUtils;
import com.wynntils.utils.FileUtils;
import com.wynntils.utils.colors.CustomColor;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Reader;
import java.lang.reflect.Field;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.nio.charset.StandardCharsets;
import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;
import java.util.List;
import org.apache.commons.lang3.RandomStringUtils;

public final class JsonManager
extends Manager {
    public static final Gson GSON = new GsonBuilder().registerTypeAdapter(CustomColor.class, (Object)new CustomColor.CustomColorSerializer()).registerTypeAdapter(StyledText.class, (Object)new StyledText.StyledTextSerializer()).registerTypeAdapter(CrowdSourcedData.class, (Object)new CrowdSourcedData.CrowdSourceDataSerializer()).registerTypeAdapter(SavedItem.class, (Object)new SavedItem.SavedItemSerializer()).registerTypeAdapterFactory(new EnumUtils.EnumTypeAdapterFactory()).enableComplexMapKeySerialization().setPrettyPrinting().serializeNulls().create();

    public JsonManager() {
        super(List.of());
    }

    public Type getJsonValueType(Field field) {
        ParameterizedType genericType = (ParameterizedType)field.getGenericType();
        return JsonTypeWrapper.wrap(genericType.getActualTypeArguments()[0]);
    }

    public <T> T deepCopy(T value, Type fieldType) {
        return (T)GSON.fromJson(GSON.toJson(value), fieldType);
    }

    public void savePreciousJson(File jsonFile, JsonObject jsonObject) {
        FileUtils.mkdir(jsonFile.getParentFile());
        File tempFile = new File(jsonFile.getPath() + ".tmp");
        if (tempFile.exists()) {
            FileUtils.deleteFile(tempFile);
        }
        try (OutputStreamWriter fileWriter = new OutputStreamWriter((OutputStream)new FileOutputStream(tempFile), StandardCharsets.UTF_8);){
            GSON.toJson((JsonElement)jsonObject, (Appendable)fileWriter);
            fileWriter.flush();
        }
        catch (IOException e) {
            WynntilsMod.error("Failed to save temp json file " + String.valueOf(tempFile), e);
        }
        try (FileReader reader = new FileReader(tempFile, StandardCharsets.UTF_8);){
            JsonElement parsed = JsonParser.parseReader((Reader)reader);
            if (!parsed.isJsonObject()) {
                WynntilsMod.error("Temporary json file " + String.valueOf(tempFile) + " did not contain a JsonObject");
                return;
            }
        }
        catch (Exception e) {
            WynntilsMod.error("Temporary json file " + String.valueOf(tempFile) + " is invalid", e);
            return;
        }
        try {
            if (jsonFile.exists()) {
                File backupFile = new File(jsonFile.getPath() + ".bak");
                FileUtils.deleteFile(backupFile);
                FileUtils.moveFile(jsonFile, backupFile);
            }
            FileUtils.moveFile(tempFile, jsonFile);
        }
        catch (Exception e) {
            WynntilsMod.error("Failed to replace temp file " + String.valueOf(jsonFile), e);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public JsonObject loadPreciousJson(File jsonFile) {
        FileUtils.mkdir(jsonFile.getParentFile());
        if (!jsonFile.exists()) {
            return this.createEmptyFile(jsonFile);
        }
        try (InputStreamReader reader = new InputStreamReader((InputStream)new FileInputStream(jsonFile), StandardCharsets.UTF_8);){
            JsonElement fileElement = JsonParser.parseReader((JsonReader)new JsonReader((Reader)reader));
            if (fileElement.isJsonObject()) {
                JsonObject jsonObject = fileElement.getAsJsonObject();
                return jsonObject;
            }
            WynntilsMod.error("Error in json file " + jsonFile.getPath());
        }
        catch (JsonParseException | IOException e) {
            WynntilsMod.error("Failed to load or parse json file " + jsonFile.getPath(), e);
        }
        this.handleInvalidFile(jsonFile);
        return this.createEmptyFile(jsonFile);
    }

    private JsonObject createEmptyFile(File jsonFile) {
        JsonObject storageJson = new JsonObject();
        this.savePreciousJson(jsonFile, storageJson);
        return storageJson;
    }

    private void handleInvalidFile(File jsonFile) {
        File dir = jsonFile.getParentFile();
        FileUtils.tryCopyFile(jsonFile, new File(dir, "invalid_" + LocalDateTime.now().format(DateTimeFormatter.ISO_LOCAL_DATE_TIME) + "_" + RandomStringUtils.randomAlphanumeric((int)5) + "_" + jsonFile.getName()));
        FileUtils.deleteFile(jsonFile);
    }
}

