/*
 * Decompiled with CFR 0.152.
 */
package com.wynntils.core.json;

import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import java.util.TreeSet;

public final class JsonTypeWrapper
implements ParameterizedType {
    private final ParameterizedType type;

    public static Type wrap(Type type) {
        if (type instanceof ParameterizedType) {
            ParameterizedType parameterizedType = (ParameterizedType)type;
            return new JsonTypeWrapper(parameterizedType);
        }
        return type;
    }

    private JsonTypeWrapper(ParameterizedType type) {
        this.type = type;
    }

    @Override
    public Type[] getActualTypeArguments() {
        return (Type[])Arrays.stream(this.type.getActualTypeArguments()).map(JsonTypeWrapper::wrap).toArray(Type[]::new);
    }

    @Override
    public Type getRawType() {
        Type rawType = this.type.getRawType();
        if (rawType.equals(List.class)) {
            return ArrayList.class;
        }
        if (rawType.equals(Set.class)) {
            return TreeSet.class;
        }
        if (rawType.equals(Map.class)) {
            return TreeMap.class;
        }
        return rawType;
    }

    @Override
    public Type getOwnerType() {
        return this.type.getOwnerType();
    }
}

