/*
 * Decompiled with CFR 0.152.
 */
package com.wynntils.core.notifications;

import com.wynntils.core.WynntilsMod;
import com.wynntils.core.components.Manager;
import com.wynntils.core.components.Managers;
import com.wynntils.core.notifications.MessageContainer;
import com.wynntils.core.notifications.event.NotificationEvent;
import com.wynntils.core.text.StyledText;
import com.wynntils.models.worlds.event.WorldStateEvent;
import com.wynntils.overlays.GameNotificationOverlay;
import com.wynntils.utils.mc.McUtils;
import com.wynntils.utils.render.TextRenderSetting;
import com.wynntils.utils.render.TextRenderTask;
import com.wynntils.utils.type.TimedSet;
import java.util.List;
import java.util.concurrent.TimeUnit;
import net.minecraft.class_2561;
import net.minecraft.class_5250;
import net.neoforged.bus.api.SubscribeEvent;

public final class NotificationManager
extends Manager {
    private static final TimedSet<MessageContainer> cachedMessageSet = new TimedSet(10L, TimeUnit.SECONDS, true);

    public NotificationManager() {
        super(List.of());
    }

    @SubscribeEvent
    public void onWorldStateChange(WorldStateEvent event) {
        cachedMessageSet.clear();
    }

    public MessageContainer queueMessage(StyledText styledText) {
        return this.queueMessage(new TextRenderTask(styledText, TextRenderSetting.DEFAULT));
    }

    public MessageContainer queueMessage(class_2561 message) {
        return this.queueMessage(new TextRenderTask(StyledText.fromComponent(message), TextRenderSetting.DEFAULT));
    }

    public MessageContainer queueMessage(TextRenderTask message) {
        if (!Managers.Connection.onServer()) {
            return null;
        }
        MessageContainer msgContainer = new MessageContainer(message);
        StyledText messageText = message.getText();
        for (MessageContainer cachedContainer : cachedMessageSet) {
            StyledText checkableMessage = cachedContainer.getMessage();
            if (!messageText.equals(checkableMessage)) continue;
            class_5250 oldMessage = cachedContainer.getRenderTask().getText().getComponent();
            cachedContainer.setMessageCount(cachedContainer.getMessageCount() + 1);
            WynntilsMod.postEvent(new NotificationEvent.Edit(cachedContainer));
            this.sendToChatIfNeeded((class_2561)oldMessage, cachedContainer);
            return cachedContainer;
        }
        cachedMessageSet.put(msgContainer);
        WynntilsMod.postEvent(new NotificationEvent.Queue(msgContainer));
        this.sendToChatIfNeeded(null, msgContainer);
        return msgContainer;
    }

    public MessageContainer editMessage(MessageContainer msgContainer, StyledText newMessage) {
        StyledText oldMessage = msgContainer.getMessage();
        if (oldMessage.equals(newMessage)) {
            return msgContainer;
        }
        class_5250 oldComponent = msgContainer.getRenderTask().getText().getComponent();
        if (msgContainer.getMessageCount() > 1) {
            msgContainer.setMessageCount(msgContainer.getMessageCount() - 1);
            WynntilsMod.postEvent(new NotificationEvent.Edit(msgContainer));
            this.sendToChatIfNeeded((class_2561)oldComponent, msgContainer);
            return this.queueMessage(newMessage);
        }
        msgContainer.editMessage(newMessage);
        WynntilsMod.postEvent(new NotificationEvent.Edit(msgContainer));
        this.sendToChatIfNeeded((class_2561)oldComponent, msgContainer);
        return msgContainer;
    }

    public void removeMessage(MessageContainer msgContainer) {
        WynntilsMod.info("Message Removed: " + String.valueOf(msgContainer.getRenderTask()));
        cachedMessageSet.remove(msgContainer);
        WynntilsMod.postEvent(new NotificationEvent.Remove(msgContainer));
        if (NotificationManager.shouldSendToChat()) {
            McUtils.removeMessageFromChat((class_2561)msgContainer.getRenderTask().getText().getComponent());
        }
    }

    private void sendToChatIfNeeded(class_2561 oldMessage, MessageContainer container) {
        if (NotificationManager.shouldSendToChat()) {
            this.sendOrEditNotification(oldMessage, container);
        }
    }

    private void sendOrEditNotification(class_2561 oldMessage, MessageContainer msgContainer) {
        if (oldMessage != null) {
            McUtils.removeMessageFromChat(oldMessage);
        }
        McUtils.mc().field_1705.method_1743().method_1812((class_2561)msgContainer.getRenderTask().getText().getComponent());
    }

    private static boolean shouldSendToChat() {
        return !Managers.Overlay.isEnabled(Managers.Overlay.getOverlay(GameNotificationOverlay.class));
    }
}

