/*
 * Decompiled with CFR 0.152.
 */
package com.wynntils.core.persisted.config;

import com.google.common.reflect.TypeToken;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonSyntaxException;
import com.mojang.util.UndashedUuid;
import com.wynntils.core.WynntilsMod;
import com.wynntils.core.components.Manager;
import com.wynntils.core.components.Managers;
import com.wynntils.core.consumers.features.AbstractConfigurable;
import com.wynntils.core.consumers.features.Configurable;
import com.wynntils.core.consumers.features.Feature;
import com.wynntils.core.consumers.overlays.DynamicOverlay;
import com.wynntils.core.consumers.overlays.Overlay;
import com.wynntils.core.json.JsonManager;
import com.wynntils.core.json.JsonTypeWrapper;
import com.wynntils.core.persisted.Persisted;
import com.wynntils.core.persisted.PersistedOwner;
import com.wynntils.core.persisted.config.Config;
import com.wynntils.core.persisted.config.OverlayGroupHolder;
import com.wynntils.core.persisted.upfixers.UpfixerType;
import com.wynntils.utils.JsonUtils;
import com.wynntils.utils.mc.McUtils;
import java.io.File;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import java.util.UUID;
import java.util.stream.Stream;
import org.apache.commons.lang3.ClassUtils;
import org.apache.commons.lang3.reflect.FieldUtils;

public final class ConfigManager
extends Manager {
    private static final File CONFIG_DIR = WynntilsMod.getModStorageDir("config");
    private static final String FILE_SUFFIX = ".conf.json";
    private static final File DEFAULT_CONFIG = new File(CONFIG_DIR, "default.conf.json");
    private static final String OVERLAY_GROUPS_JSON_KEY = "overlayGroups";
    private static final Set<Config<?>> CONFIGS = new TreeSet();
    private final File userConfigFile = new File(CONFIG_DIR, UndashedUuid.toString((UUID)McUtils.getUserProfileUUID()) + ".conf.json");
    private JsonObject configObject;

    public ConfigManager() {
        super(List.of());
    }

    public void init() {
        this.configObject = Managers.Json.loadPreciousJson(this.userConfigFile);
        Managers.Feature.getFeatures().forEach(this::registerFeature);
        HashSet workaround = new HashSet(CONFIGS);
        if (Managers.Upfixer.runUpfixers(this.configObject, workaround, UpfixerType.CONFIG)) {
            Managers.Json.savePreciousJson(this.userConfigFile, this.configObject);
        }
        Managers.Config.reloadConfiguration(true);
        Managers.Config.saveConfig();
        Managers.Config.saveDefaultConfig();
    }

    private void registerFeature(Feature feature) {
        this.registerConfigOptions(feature);
        for (Overlay overlay2 : Managers.Overlay.getFeatureOverlays(feature).stream().filter(overlay -> Managers.Overlay.getFeatureOverlayGroups(feature).stream().noneMatch(overlayGroupHolder -> overlayGroupHolder.getOverlays().contains(overlay))).toList()) {
            this.registerConfigOptions(overlay2);
        }
    }

    private void registerConfigOptions(Configurable configurable) {
        Managers.Persisted.registerOwner(configurable);
        List<Config<?>> configs = this.getConfigOptions(configurable);
        configurable.addConfigOptions(configs);
        CONFIGS.addAll(configs);
        for (Config<?> config : configs) {
            Class clazz;
            Type type = Managers.Persisted.getMetadata(config).valueType();
            if (type instanceof Class && (clazz = (Class)type).isEnum()) continue;
            if (type instanceof JsonTypeWrapper) {
                JsonTypeWrapper wrapper = (JsonTypeWrapper)type;
                continue;
            }
            Class wrapped = ClassUtils.primitiveToWrapper((Class)((Class)type));
            try {
                Constructor constructor = wrapped.getConstructor(String.class);
            }
            catch (NoSuchMethodException e) {
                WynntilsMod.error("String-based constructor is missing in type for Config: " + String.valueOf(type));
                throw new RuntimeException("Internal error");
            }
        }
    }

    public void reloadConfiguration(boolean initOverlayGroups) {
        this.configObject = Managers.Json.loadPreciousJson(this.userConfigFile);
        this.loadConfigOptions(true, initOverlayGroups);
    }

    private void loadConfigOptions(boolean resetIfNotFound, boolean initOverlayGroups) {
        JsonObject overlayGroups = JsonUtils.getNullableJsonObject(this.configObject, OVERLAY_GROUPS_JSON_KEY);
        for (OverlayGroupHolder overlayGroupHolder : Managers.Overlay.getOverlayGroups()) {
            if (initOverlayGroups) {
                if (overlayGroups.has(overlayGroupHolder.getConfigKey())) {
                    JsonArray ids = JsonUtils.getNullableJsonArray(overlayGroups, overlayGroupHolder.getConfigKey());
                    List<Integer> idList = ids.asList().stream().map(JsonElement::getAsInt).toList();
                    Managers.Overlay.createOverlayGroupWithIds(overlayGroupHolder, idList);
                } else {
                    Managers.Overlay.createOverlayGroupWithDefaults(overlayGroupHolder);
                }
            }
            overlayGroupHolder.getOverlays().forEach(Managers.Persisted::registerOwner);
            overlayGroupHolder.getOverlays().forEach(overlay -> overlay.addConfigOptions(this.getConfigOptions((PersistedOwner)overlay)));
        }
        for (Config config : ConfigManager.getConfigList()) {
            if (!this.configObject.has(config.getJsonName())) {
                if (!resetIfNotFound) continue;
                config.reset();
                continue;
            }
            JsonElement configJson = this.configObject.get(config.getJsonName());
            Object value = JsonManager.GSON.fromJson(configJson, config.getType());
            config.restoreValue(value);
        }
        for (OverlayGroupHolder overlayGroupHolder : Managers.Overlay.getOverlayGroups()) {
            Managers.Overlay.enableOverlays(overlayGroupHolder.getParent());
        }
    }

    private static List<Config<?>> getConfigList() {
        return Stream.concat(CONFIGS.stream(), Managers.Overlay.getOverlayGroups().stream().map(OverlayGroupHolder::getOverlays).flatMap(Collection::stream).map(AbstractConfigurable::getConfigOptions).flatMap(Collection::stream)).toList();
    }

    public synchronized void saveConfig() {
        if (this.configObject == null) {
            return;
        }
        JsonObject configJson = new JsonObject();
        for (Config<?> config : ConfigManager.getConfigList()) {
            if (!config.valueChanged()) continue;
            Object value = config.get();
            JsonElement configElement = JsonManager.GSON.toJsonTree(value);
            configJson.add(config.getJsonName(), configElement);
        }
        String upfixerJsonMemberName = "wynntils.upfixers";
        configJson.add(upfixerJsonMemberName, this.configObject.get(upfixerJsonMemberName));
        JsonObject overlayGroups = new JsonObject();
        for (OverlayGroupHolder holder : Managers.Overlay.getOverlayGroups()) {
            JsonArray ids = new JsonArray();
            holder.getOverlays().stream().map(overlay -> ((DynamicOverlay)overlay).getId()).forEach(arg_0 -> ((JsonArray)ids).add(arg_0));
            overlayGroups.add(holder.getConfigKey(), (JsonElement)ids);
        }
        configJson.add(OVERLAY_GROUPS_JSON_KEY, (JsonElement)overlayGroups);
        Managers.Json.savePreciousJson(this.userConfigFile, configJson);
    }

    public File getUserConfigFile() {
        return this.userConfigFile;
    }

    private void saveDefaultConfig() {
        JsonObject configJson = new JsonObject();
        for (Config<?> config : ConfigManager.getConfigList()) {
            Object value = config.getDefaultValue();
            JsonElement configElement = JsonManager.GSON.toJsonTree(value);
            configJson.add(config.getJsonName(), configElement);
        }
        WynntilsMod.info("Creating default config file with " + configJson.size() + " config values.");
        Managers.Json.savePreciousJson(DEFAULT_CONFIG, configJson);
    }

    private List<Config<?>> getConfigOptions(PersistedOwner owner) {
        return new ArrayList(Managers.Persisted.getPersisted(owner, Config.class).stream().map(p -> ConfigManager.processConfig(owner, (Field)p.a(), (Persisted)p.b())).toList());
    }

    private static Config<?> processConfig(PersistedOwner owner, Field configField, Persisted configInfo) {
        Config configObj;
        try {
            configObj = (Config)FieldUtils.readField((Field)configField, (Object)owner, (boolean)true);
        }
        catch (IllegalAccessException e) {
            throw new RuntimeException("Cannot read Config field: " + String.valueOf(configField), e);
        }
        if (WynntilsMod.isDevelopmentEnvironment() && configObj.isVisible()) {
            if (configObj.getDisplayName().startsWith("feature.wynntils.")) {
                WynntilsMod.error("Config displayName i18n is missing for " + configObj.getDisplayName());
                throw new AssertionError((Object)("Missing i18n for " + configObj.getDisplayName()));
            }
            if (configObj.getDescription().startsWith("feature.wynntils.")) {
                WynntilsMod.error("Config description i18n is missing for " + configObj.getDescription());
                throw new AssertionError((Object)("Missing i18n for " + configObj.getDescription()));
            }
            if (configObj.getDescription().isEmpty()) {
                WynntilsMod.error("Config description is empty for " + configObj.getDisplayName());
                throw new AssertionError((Object)("Missing i18n for " + configObj.getDisplayName()));
            }
        }
        return configObj;
    }

    public Stream<Config<?>> getConfigs() {
        return ConfigManager.getConfigList().stream();
    }

    public Stream<Config<?>> getConfigsForOwner(PersistedOwner owner) {
        return this.getConfigs().filter(config -> Managers.Persisted.getMetadata(config).owner() == owner);
    }

    public boolean importConfig(String jsonInput, List<Configurable> configsToImport) {
        try {
            Map configData = (Map)JsonManager.GSON.fromJson(jsonInput, new TypeToken<HashMap<String, Object>>(){}.getType());
            if (configData == null) {
                WynntilsMod.warn("Unable to import config due to invalid input");
                return false;
            }
            for (Configurable feature : configsToImport) {
                for (Config<?> configOption : feature.getVisibleConfigOptions()) {
                    String configOptionName = configOption.getJsonName();
                    if (!configData.containsKey(configOptionName)) continue;
                    Object configOptionValue = configData.get(configOptionName);
                    this.setConfigValue(configOption, configOptionValue);
                }
            }
            return true;
        }
        catch (JsonSyntaxException ex) {
            WynntilsMod.warn("Failed to import config ", ex);
            return false;
        }
    }

    public String exportConfig(List<Configurable> featuresToExport) {
        HashMap configData = new HashMap();
        for (Configurable feature : featuresToExport) {
            List<Config<?>> visibleConfigOptions = feature.getVisibleConfigOptions();
            for (Config<?> configOption : visibleConfigOptions) {
                String configOptionName = configOption.getJsonName();
                Object configOptionValue = configOption.get();
                configData.put(configOptionName, configOptionValue);
            }
        }
        return JsonManager.GSON.toJson(configData);
    }

    private <T> void setConfigValue(Config<T> config, Object value) {
        T typedValue = config.tryParseStringValue(value.toString());
        if (typedValue != null) {
            config.setValue(typedValue);
        }
    }
}

