/*
 * Decompiled with CFR 0.152.
 */
package com.wynntils.features;

import com.wynntils.core.components.Managers;
import com.wynntils.core.components.Models;
import com.wynntils.core.components.Services;
import com.wynntils.core.consumers.features.Feature;
import com.wynntils.core.persisted.Persisted;
import com.wynntils.core.persisted.config.Config;
import com.wynntils.core.text.StyledText;
import com.wynntils.core.text.type.StyleType;
import com.wynntils.mc.event.ConnectionEvent;
import com.wynntils.models.character.event.CharacterUpdateEvent;
import com.wynntils.models.character.type.ClassType;
import com.wynntils.models.characterstats.event.CombatXpGainEvent;
import com.wynntils.models.territories.profile.TerritoryProfile;
import com.wynntils.models.worlds.event.StreamModeEvent;
import com.wynntils.models.worlds.event.WorldStateEvent;
import com.wynntils.utils.mc.McUtils;
import com.wynntils.utils.type.CappedValue;
import java.util.Locale;
import net.minecraft.class_2374;
import net.minecraft.class_243;
import net.neoforged.bus.api.SubscribeEvent;

public class DiscordRichPresenceFeature
extends Feature {
    @Persisted
    private final Config<Boolean> displayLocation = new Config<Boolean>(true);
    @Persisted
    private final Config<Boolean> displayCharacterInfo = new Config<Boolean>(true);
    @Persisted
    private final Config<Boolean> displayWorld = new Config<Boolean>(true);
    @Persisted
    private final Config<Boolean> disableInStream = new Config<Boolean>(true);
    private static final int TERRITORY_TICKS_DELAY = 10;
    private boolean territoryChecking = false;
    private TerritoryProfile lastTerritoryProfile = null;

    @SubscribeEvent
    public void onCharacterUpdate(CharacterUpdateEvent event) {
        if (!Services.Discord.isReady()) {
            return;
        }
        if (!Models.WorldState.onWorld()) {
            return;
        }
        if (((Boolean)this.displayCharacterInfo.get()).booleanValue()) {
            this.displayCharacterDetails();
        }
    }

    @SubscribeEvent
    public void onXpChange(CombatXpGainEvent event) {
        if (!Services.Discord.isReady()) {
            return;
        }
        if (!Models.WorldState.onWorld()) {
            return;
        }
        if (((Boolean)this.displayCharacterInfo.get()).booleanValue()) {
            this.displayCharacterDetails();
        }
    }

    @SubscribeEvent
    public void onWorldChange(WorldStateEvent event) {
        if (!Services.Discord.isReady()) {
            return;
        }
        if (((Boolean)this.displayWorld.get()).booleanValue()) {
            switch (event.getNewState()) {
                case WORLD: {
                    Services.Discord.setState(Models.WorldState.getCurrentWorldName());
                    this.startTerritoryCheck();
                    break;
                }
                case HUB: 
                case CONNECTING: {
                    Services.Discord.setDetails("");
                    Services.Discord.setState("In Hub");
                    Services.Discord.setWynncraftLogo();
                    this.stopTerritoryCheck();
                    break;
                }
                case CHARACTER_SELECTION: {
                    if (((Boolean)this.displayLocation.get()).booleanValue()) {
                        Services.Discord.setDetails("Selecting a character");
                    }
                    Services.Discord.setState("");
                    Services.Discord.setWynncraftLogo();
                    this.stopTerritoryCheck();
                }
            }
        } else {
            Services.Discord.setState("");
            this.stopTerritoryCheck();
        }
    }

    @SubscribeEvent
    public void onStreamToggle(StreamModeEvent e) {
        if (((Boolean)this.disableInStream.get()).booleanValue() && e.isEnabled()) {
            this.disableRichPresence();
        } else if (!e.isEnabled()) {
            this.enableRichPresence();
        }
    }

    @SubscribeEvent
    public void onDisconnect(ConnectionEvent.DisconnectedEvent e) {
        this.disableRichPresence();
    }

    @Override
    protected void onConfigUpdate(Config<?> config) {
        if (config == this.disableInStream && Models.WorldState.isInStream()) {
            if (((Boolean)this.disableInStream.get()).booleanValue()) {
                this.disableRichPresence();
            } else {
                this.enableRichPresence();
            }
        } else {
            this.tryUpdateDisplayedInfo();
        }
    }

    @Override
    public void onEnable() {
        this.enableRichPresence();
    }

    @Override
    public void onDisable() {
        this.disableRichPresence();
    }

    private void enableRichPresence() {
        if (!Services.Discord.isReady() && !Services.Discord.load()) {
            Managers.Feature.crashFeature(this);
            return;
        }
        this.tryUpdateDisplayedInfo();
    }

    private void disableRichPresence() {
        Services.Discord.unload();
        this.stopTerritoryCheck();
    }

    private void tryUpdateDisplayedInfo() {
        if (!Services.Discord.isReady()) {
            return;
        }
        if (!Models.WorldState.onWorld()) {
            return;
        }
        if (((Boolean)this.displayLocation.get()).booleanValue()) {
            this.startTerritoryCheck();
        } else {
            this.stopTerritoryCheck();
            Services.Discord.setDetails("");
        }
        if (((Boolean)this.displayCharacterInfo.get()).booleanValue()) {
            this.displayCharacterDetails();
        } else {
            Services.Discord.setWynncraftLogo();
        }
        if (((Boolean)this.displayWorld.get()).booleanValue()) {
            Services.Discord.setState(Models.WorldState.getCurrentWorldName());
        } else {
            Services.Discord.setState("");
        }
    }

    private void displayCharacterDetails() {
        if (McUtils.player() == null) {
            return;
        }
        CappedValue combatLevel = Models.CombatXp.getCombatLevel();
        int level = combatLevel.current();
        ClassType classType = Models.Character.getClassType();
        if (classType == null) {
            return;
        }
        String name = StyledText.fromComponent(McUtils.player().method_5477()).getString(StyleType.NONE);
        Services.Discord.setImageText(name + " - Level " + level + " " + classType.getName());
        Services.Discord.setImage(classType.getActualName(false).toLowerCase(Locale.ROOT));
    }

    private void startTerritoryCheck() {
        if (this.territoryChecking) {
            return;
        }
        this.territoryChecking = true;
        this.checkTerritory();
    }

    private void stopTerritoryCheck() {
        this.lastTerritoryProfile = null;
        this.territoryChecking = false;
    }

    private void checkTerritory() {
        TerritoryProfile territoryProfile;
        if (!this.territoryChecking) {
            return;
        }
        if (!Models.WorldState.onWorld()) {
            this.stopTerritoryCheck();
            return;
        }
        if (McUtils.player() == null) {
            this.stopTerritoryCheck();
            return;
        }
        class_243 position = McUtils.player().method_19538();
        if (position != null && (territoryProfile = Models.Territory.getTerritoryProfileForPosition((class_2374)McUtils.player().method_19538())) != null && territoryProfile != this.lastTerritoryProfile) {
            this.lastTerritoryProfile = territoryProfile;
            String location = territoryProfile.getName();
            Services.Discord.setDetails(location);
        }
        Managers.TickScheduler.scheduleLater(this::checkTerritory, 10);
    }
}

