/*
 * Decompiled with CFR 0.152.
 */
package com.wynntils.features.combat;

import com.wynntils.core.components.Models;
import com.wynntils.core.consumers.features.Feature;
import com.wynntils.core.consumers.features.properties.StartDisabled;
import com.wynntils.core.persisted.config.Category;
import com.wynntils.core.persisted.config.ConfigCategory;
import com.wynntils.mc.event.ArmSwingEvent;
import com.wynntils.mc.event.ChangeCarriedItemEvent;
import com.wynntils.mc.event.PlayerInteractEvent;
import com.wynntils.mc.event.SetSlotEvent;
import com.wynntils.mc.event.TickEvent;
import com.wynntils.mc.event.UseItemEvent;
import com.wynntils.models.character.type.ClassType;
import com.wynntils.models.items.properties.RequirementItemProperty;
import com.wynntils.utils.mc.McUtils;
import com.wynntils.utils.mc.MouseUtils;
import com.wynntils.utils.wynn.ItemUtils;
import java.util.Optional;
import net.minecraft.class_1268;
import net.minecraft.class_1299;
import net.minecraft.class_1799;
import net.neoforged.bus.api.SubscribeEvent;

@StartDisabled
@ConfigCategory(value=Category.COMBAT)
public class AutoAttackFeature
extends Feature {
    private static final int TICKS_PER_ATTACK = 2;
    private long lastSpellInput = -1L;
    private int spellInputs = 0;
    private WeaponStatus weaponStatus = WeaponStatus.UNKNOWN;

    @SubscribeEvent
    public void onChangeCarriedItemEvent(ChangeCarriedItemEvent event) {
        this.lastSpellInput = -1L;
        this.spellInputs = 0;
        this.updateWeaponStatus();
    }

    @SubscribeEvent
    public void onSetSlotEvent(SetSlotEvent.Post event) {
        if (event.getSlot() == McUtils.inventory().field_7545) {
            this.updateWeaponStatus();
        }
    }

    @SubscribeEvent
    public void onSwing(ArmSwingEvent event) {
        if (Models.Character.getClassType() != ClassType.ARCHER && this.spellInputs == 0) {
            return;
        }
        this.handleInput(false);
    }

    @SubscribeEvent
    public void onUseItem(UseItemEvent event) {
        if (Models.Character.getClassType() == ClassType.ARCHER && this.spellInputs == 0) {
            return;
        }
        this.handleInput(false);
    }

    @SubscribeEvent
    public void onInteract(PlayerInteractEvent.InteractAt event) {
        class_1299 entityType;
        if (Models.Character.getClassType() == ClassType.ARCHER && this.spellInputs == 0) {
            return;
        }
        if (event.getEntityHitResult() != null && (entityType = event.getEntityHitResult().method_17782().method_5864()) == class_1299.field_42623) {
            return;
        }
        this.handleInput(true);
    }

    @SubscribeEvent
    public void onTick(TickEvent event) {
        if (!Models.WorldState.onWorld()) {
            return;
        }
        if (!Models.Spell.isSpellQueueEmpty()) {
            return;
        }
        int tickCount = McUtils.player().field_6012;
        if (this.lastSpellInput + 60L < (long)tickCount) {
            this.lastSpellInput = -1L;
            this.spellInputs = 0;
        }
        if (Models.Raid.isParasiteOvertaken()) {
            return;
        }
        if (tickCount % 2 != 0) {
            return;
        }
        if (this.lastSpellInput + 60L > (long)McUtils.player().field_6012) {
            return;
        }
        if (this.weaponStatus == WeaponStatus.UNKNOWN) {
            this.updateWeaponStatus();
        }
        if (this.weaponStatus != WeaponStatus.USABLE) {
            return;
        }
        if (Models.Character.getClassType() == ClassType.ARCHER ? !McUtils.options().field_1904.method_1434() : !McUtils.options().field_1886.method_1434()) {
            return;
        }
        MouseUtils.sendAttackInput(Models.Character.getClassType() == ClassType.ARCHER);
    }

    private void handleInput(boolean interaction) {
        if (this.lastSpellInput == -1L || this.spellInputs < 3) {
            this.lastSpellInput = McUtils.player().field_6012;
            ++this.spellInputs;
            if (interaction) {
                --this.spellInputs;
            }
            if (this.spellInputs == 3) {
                this.spellInputs = 0;
                this.lastSpellInput = -1L;
            }
        }
    }

    private void updateWeaponStatus() {
        class_1799 heldItem = McUtils.player().method_5998(class_1268.field_5808);
        if (!ItemUtils.isWeapon(heldItem)) {
            this.weaponStatus = WeaponStatus.NOT_USABLE;
            return;
        }
        Optional<RequirementItemProperty> wynnItem = Models.Item.asWynnItemProperty(heldItem, RequirementItemProperty.class);
        this.weaponStatus = wynnItem.isPresent() && wynnItem.get().meetsActualRequirements() ? WeaponStatus.USABLE : WeaponStatus.NOT_USABLE;
    }

    private static enum WeaponStatus {
        UNKNOWN,
        NOT_USABLE,
        USABLE;

    }
}

