/*
 * Decompiled with CFR 0.152.
 */
package com.wynntils.features.combat;

import com.wynntils.core.WynntilsMod;
import com.wynntils.core.components.Managers;
import com.wynntils.core.components.Models;
import com.wynntils.core.consumers.features.Feature;
import com.wynntils.core.persisted.Persisted;
import com.wynntils.core.persisted.config.Category;
import com.wynntils.core.persisted.config.Config;
import com.wynntils.core.persisted.config.ConfigCategory;
import com.wynntils.mc.event.PlayerInteractEvent;
import com.wynntils.mc.event.UseItemEvent;
import com.wynntils.models.elements.type.PotionType;
import com.wynntils.models.items.items.game.CraftedConsumableItem;
import com.wynntils.models.items.items.game.MultiHealthPotionItem;
import com.wynntils.models.items.items.game.PotionItem;
import com.wynntils.utils.mc.McUtils;
import com.wynntils.utils.type.CappedValue;
import java.util.Optional;
import net.minecraft.class_124;
import net.minecraft.class_1799;
import net.minecraft.class_2561;
import net.minecraft.class_5250;
import net.neoforged.bus.api.SubscribeEvent;

@ConfigCategory(value=Category.COMBAT)
public class HealthPotionBlockerFeature
extends Feature {
    @Persisted
    private final Config<Integer> threshold = new Config<Integer>(95);

    @SubscribeEvent
    public void onPotionUse(UseItemEvent event) {
        if (this.checkPotionUse()) {
            event.setCanceled(true);
        }
    }

    @SubscribeEvent
    public void onPotionUseOn(PlayerInteractEvent.Interact event) {
        if (this.checkPotionUse()) {
            event.setCanceled(true);
        }
    }

    @SubscribeEvent
    public void onPotionUseOn(PlayerInteractEvent.InteractAt event) {
        if (this.checkPotionUse()) {
            event.setCanceled(true);
        }
    }

    @SubscribeEvent
    public void onPotionUseOn(PlayerInteractEvent.RightClickBlock event) {
        if (this.checkPotionUse()) {
            event.setCanceled(true);
        }
    }

    private boolean checkPotionUse() {
        class_1799 itemStack = McUtils.inventory().method_7391();
        if (!this.isHealingPotion(itemStack)) {
            return false;
        }
        Optional<CappedValue> healthOpt = Models.CharacterStats.getHealth();
        if (healthOpt.isEmpty()) {
            WynntilsMod.warn("No health information available for health potion blocker check.");
            return false;
        }
        CappedValue health = healthOpt.get();
        int percentage = health.getPercentageInt();
        if (percentage >= (Integer)this.threshold.get()) {
            class_5250 response = percentage < 100 ? class_2561.method_43469((String)"feature.wynntils.healthPotionBlocker.thresholdReached", (Object[])new Object[]{percentage}) : class_2561.method_43471((String)"feature.wynntils.healthPotionBlocker.healthFull");
            Managers.Notification.queueMessage((class_2561)response.method_27692(class_124.field_1061));
            return true;
        }
        return false;
    }

    private boolean isHealingPotion(class_1799 itemStack) {
        Optional<MultiHealthPotionItem> healthPotionOpt = Models.Item.asWynnItem(itemStack, MultiHealthPotionItem.class);
        Optional<PotionItem> potionOpt = Models.Item.asWynnItem(itemStack, PotionItem.class);
        Optional<CraftedConsumableItem> craftedConsumableOpt = Models.Item.asWynnItem(itemStack, CraftedConsumableItem.class);
        if (healthPotionOpt.isEmpty() && potionOpt.isEmpty() && craftedConsumableOpt.isEmpty()) {
            return false;
        }
        if (potionOpt.isPresent()) {
            return potionOpt.get().getType() == PotionType.HEALING;
        }
        if (craftedConsumableOpt.isPresent()) {
            return craftedConsumableOpt.get().isHealing();
        }
        return true;
    }
}

