/*
 * Decompiled with CFR 0.152.
 */
package com.wynntils.features.combat;

import com.wynntils.core.components.Managers;
import com.wynntils.core.components.Models;
import com.wynntils.core.consumers.features.Feature;
import com.wynntils.core.persisted.Persisted;
import com.wynntils.core.persisted.config.Category;
import com.wynntils.core.persisted.config.Config;
import com.wynntils.core.persisted.config.ConfigCategory;
import com.wynntils.core.text.StyledText;
import com.wynntils.mc.event.PlayerAttackEvent;
import com.wynntils.mc.event.PlayerInteractEvent;
import com.wynntils.utils.wynn.ItemUtils;
import net.minecraft.class_124;
import net.minecraft.class_1297;
import net.minecraft.class_1657;
import net.minecraft.class_1799;
import net.neoforged.bus.api.ICancellableEvent;
import net.neoforged.bus.api.SubscribeEvent;

@ConfigCategory(value=Category.COMBAT)
public class PreventTradesDuelsFeature
extends Feature {
    @Persisted
    private final Config<Boolean> onlyWhileFighting = new Config<Boolean>(true);
    @Persisted
    private final Config<Integer> fightingTimeCutoff = new Config<Integer>(10);
    @Persisted
    private final Config<Boolean> whenHoldingGatheringTool = new Config<Boolean>(false);

    @SubscribeEvent
    public void onPlayerRightClick(PlayerInteractEvent.Interact event) {
        this.handlePlayerClick(event, event.getPlayer(), event.getItemStack(), event.getTarget());
    }

    @SubscribeEvent
    public void onPlayerLeftClick(PlayerAttackEvent event) {
        this.handlePlayerClick(event, event.getPlayer(), event.getPlayer().method_6047(), event.getTarget());
    }

    private void handlePlayerClick(ICancellableEvent event, class_1657 player, class_1799 itemStack, class_1297 target) {
        class_1657 p;
        if (!(player.method_5715() && target instanceof class_1657 && Models.Player.isLocalPlayer(p = (class_1657)target))) {
            return;
        }
        int timeSinceLastFight = (int)((System.currentTimeMillis() - Models.Combat.getLastDamageDealtTimestamp()) / 1000L);
        if (ItemUtils.isWeapon(itemStack) && ((Boolean)this.onlyWhileFighting.get()).booleanValue() && timeSinceLastFight < (Integer)this.fightingTimeCutoff.get()) {
            event.setCanceled(true);
            Managers.Notification.queueMessage(StyledText.fromString(String.valueOf(class_124.field_1078) + "Trade/Duel blocked for " + ((Integer)this.fightingTimeCutoff.get() - timeSinceLastFight) + " s"));
        } else if (ItemUtils.isGatheringTool(itemStack) && ((Boolean)this.whenHoldingGatheringTool.get()).booleanValue()) {
            event.setCanceled(true);
            Managers.Notification.queueMessage(StyledText.fromString(String.valueOf(class_124.field_1078) + "Trade/Duel blocked whilst holding gathering tool"));
        }
    }
}

