/*
 * Decompiled with CFR 0.152.
 */
package com.wynntils.features.combat;

import com.mojang.blaze3d.systems.RenderSystem;
import com.wynntils.core.components.Models;
import com.wynntils.core.components.Services;
import com.wynntils.core.consumers.features.Feature;
import com.wynntils.core.persisted.Persisted;
import com.wynntils.core.persisted.config.Category;
import com.wynntils.core.persisted.config.Config;
import com.wynntils.core.persisted.config.ConfigCategory;
import com.wynntils.mc.event.PlayerRenderEvent;
import com.wynntils.mc.event.RenderTileLevelLastEvent;
import com.wynntils.mc.event.TickEvent;
import com.wynntils.mc.extension.EntityRenderStateExtension;
import com.wynntils.models.gambits.type.Gambit;
import com.wynntils.models.gear.type.GearInfo;
import com.wynntils.models.inventory.type.InventoryAccessory;
import com.wynntils.models.inventory.type.InventoryArmor;
import com.wynntils.models.items.WynnItem;
import com.wynntils.models.items.items.game.GearItem;
import com.wynntils.services.hades.HadesUser;
import com.wynntils.utils.colors.CommonColors;
import com.wynntils.utils.colors.CustomColor;
import com.wynntils.utils.mc.McUtils;
import com.wynntils.utils.render.buffered.CustomRenderType;
import com.wynntils.utils.type.Pair;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import net.minecraft.class_1297;
import net.minecraft.class_1657;
import net.minecraft.class_2374;
import net.minecraft.class_408;
import net.minecraft.class_4587;
import net.minecraft.class_4588;
import net.minecraft.class_4597;
import net.minecraft.class_742;
import net.minecraft.class_746;
import net.minecraft.class_9799;
import net.neoforged.bus.api.SubscribeEvent;
import org.joml.Matrix4f;

@ConfigCategory(value=Category.COMBAT)
public class RangeVisualizerFeature
extends Feature {
    private static final class_4597.class_4598 BUFFER_SOURCE = class_4597.method_22991((class_9799)new class_9799(256));
    private static final int SEGMENTS = 128;
    private static final float HEIGHT = 0.1f;
    private static final int TRANSPARENCY = 95;
    private final Map<class_1657, List<Pair<CustomColor, Float>>> circlesToRender = new HashMap<class_1657, List<Pair<CustomColor, Float>>>();
    private final Set<class_1657> detectedPlayers = new HashSet<class_1657>();
    @Persisted
    private final Config<Boolean> renderInFirstPerson = new Config<Boolean>(true);
    @Persisted
    private final Config<Boolean> showGambitCircles = new Config<Boolean>(true);
    @Persisted
    private final Config<Boolean> showMajorIDCircles = new Config<Boolean>(true);

    @SubscribeEvent
    public void onPlayerRender(PlayerRenderEvent e) {
        class_1297 entity = ((EntityRenderStateExtension)e.getPlayerRenderState()).getEntity();
        if (!(entity instanceof class_742)) {
            return;
        }
        class_742 player = (class_742)entity;
        if (player.equals((Object)McUtils.player()) && ((Boolean)this.renderInFirstPerson.get()).booleanValue()) {
            return;
        }
        this.detectedPlayers.add((class_1657)player);
        List<Pair<CustomColor, Float>> circles = this.circlesToRender.get(player);
        if (circles == null) {
            return;
        }
        circles.forEach(circleType -> {
            float radius = ((Float)circleType.b()).floatValue();
            int color = ((CustomColor)circleType.a()).asInt();
            this.renderCircle(e.getPoseStack(), (class_2374)player.method_19538(), radius, color);
        });
    }

    @SubscribeEvent
    public void onRenderLevelLast(RenderTileLevelLastEvent event) {
        if (!Models.WorldState.onWorld()) {
            return;
        }
        if (!((Boolean)this.renderInFirstPerson.get()).booleanValue()) {
            return;
        }
        class_746 player = McUtils.player();
        if (player == null) {
            return;
        }
        this.detectedPlayers.add((class_1657)player);
        List<Pair<CustomColor, Float>> circles = this.circlesToRender.get(player);
        if (circles == null || circles.isEmpty()) {
            return;
        }
        class_4587 poseStack = event.getPoseStack();
        float partialTick = event.getDeltaTracker().method_60637(true);
        double interpX = player.field_6014 + (player.method_23317() - player.field_6014) * (double)partialTick;
        double interpY = player.field_6036 + (player.method_23318() - player.field_6036) * (double)partialTick;
        double interpZ = player.field_5969 + (player.method_23321() - player.field_5969) * (double)partialTick;
        poseStack.method_22903();
        poseStack.method_22904(interpX - event.getCamera().method_19326().field_1352, interpY - event.getCamera().method_19326().field_1351, interpZ - event.getCamera().method_19326().field_1350);
        for (Pair<CustomColor, Float> circle : circles) {
            float radius = circle.b().floatValue();
            int color = circle.a().asInt();
            this.renderCircle(poseStack, (class_2374)player.method_19538(), radius, color);
        }
        poseStack.method_22909();
    }

    @SubscribeEvent
    public void onTick(TickEvent e) {
        this.circlesToRender.clear();
        this.detectedPlayers.forEach(this::checkCircles);
        this.detectedPlayers.clear();
    }

    private void checkCircles(class_1657 player) {
        if (!Models.Player.isLocalPlayer(player)) {
            return;
        }
        ArrayList circles = new ArrayList();
        if (((Boolean)this.showMajorIDCircles.get()).booleanValue()) {
            List<GearInfo> validGear;
            if (player == McUtils.player()) {
                if (McUtils.screen() != null && !(McUtils.screen() instanceof class_408)) {
                    return;
                }
                validGear = Models.CharacterStats.getWornGear();
            } else {
                Optional<HadesUser> hadesUserOpt = Services.Hades.getHadesUser(player.method_5667());
                if (hadesUserOpt.isEmpty()) {
                    return;
                }
                validGear = new ArrayList<GearInfo>();
                GearInfo heldItemGearInfo = this.getOtherPlayerGearInfo(hadesUserOpt.get().getHeldItem());
                if (heldItemGearInfo != null && heldItemGearInfo.type().isWeapon()) {
                    validGear.add(heldItemGearInfo);
                }
                for (InventoryArmor armor : hadesUserOpt.get().getArmor().keySet()) {
                    GearInfo armorGearInfo = this.getOtherPlayerGearInfo((WynnItem)hadesUserOpt.get().getArmor().get((Object)armor));
                    if (armorGearInfo == null || !armorGearInfo.type().isArmor()) continue;
                    validGear.add(armorGearInfo);
                }
                for (InventoryAccessory accessory : hadesUserOpt.get().getAccessories().keySet()) {
                    GearInfo accessoryGearInfo = this.getOtherPlayerGearInfo((WynnItem)hadesUserOpt.get().getAccessories().get((Object)accessory));
                    if (accessoryGearInfo == null || !accessoryGearInfo.type().isAccessory()) continue;
                    validGear.add(accessoryGearInfo);
                }
            }
            validGear.stream().flatMap(gearInfo -> gearInfo.fixedStats().majorIds().stream().map(majorId -> this.getCircleFromMajorId(majorId.name()))).filter(Objects::nonNull).forEach(circles::add);
        }
        if (Models.Raid.getCurrentRaid() != null) {
            if (player == McUtils.player() && ((Boolean)this.showGambitCircles.get()).booleanValue()) {
                Models.Gambit.getActiveGambits().stream().map(this::getCircleFromGambit).filter(Objects::nonNull).forEach(circles::add);
            }
            if (((Boolean)this.showMajorIDCircles.get()).booleanValue()) {
                Models.Raid.getRaidMajorIds(player.method_5477().getString()).stream().map(this::getCircleFromMajorId).filter(Objects::nonNull).forEach(circles::add);
            }
        }
        if (!circles.isEmpty()) {
            this.circlesToRender.put(player, circles);
        }
    }

    private Pair<CustomColor, Float> getCircleFromMajorId(String majorIdName) {
        return switch (majorIdName) {
            case "Taunt" -> Pair.of(CommonColors.ORANGE.withAlpha(95), Float.valueOf(12.0f));
            case "Saviour's Sacrifice" -> Pair.of(CommonColors.WHITE.withAlpha(95), Float.valueOf(8.0f));
            case "Altruism" -> Pair.of(CommonColors.PINK.withAlpha(95), Float.valueOf(16.0f));
            case "Guardian" -> Pair.of(CommonColors.RED.withAlpha(95), Float.valueOf(12.0f));
            default -> null;
        };
    }

    private Pair<CustomColor, Float> getCircleFromGambit(Gambit gambit) {
        return switch (gambit) {
            case Gambit.FARSIGHTED -> Pair.of(CommonColors.RED.withAlpha(95), Float.valueOf(3.0f));
            case Gambit.MYOPIC -> Pair.of(CommonColors.RED.withAlpha(95), Float.valueOf(12.0f));
            default -> null;
        };
    }

    private GearInfo getOtherPlayerGearInfo(WynnItem wynnItem) {
        if (wynnItem instanceof GearItem) {
            GearItem gearItem = (GearItem)wynnItem;
            return gearItem.getItemInfo();
        }
        return null;
    }

    private void renderCircle(class_4587 poseStack, class_2374 position, float radius, int color) {
        double startingAngle;
        RenderSystem.disableCull();
        poseStack.method_22903();
        poseStack.method_22904(-position.method_10216(), -position.method_10214(), -position.method_10215());
        class_4588 consumer = BUFFER_SOURCE.getBuffer(CustomRenderType.POSITION_COLOR_QUAD);
        Matrix4f matrix4f = poseStack.method_23760().method_23761();
        double angleStep = 0.04908738521234052;
        double angle = startingAngle = (double)(-(System.currentTimeMillis() % 40000L) * 2L) * Math.PI / 40000.0;
        for (int i = 0; i < 128; ++i) {
            if (i % 4 > 2) {
                angle += angleStep;
                continue;
            }
            float x = (float)(position.method_10216() + Math.sin(angle) * (double)radius);
            float z = (float)(position.method_10215() + Math.cos(angle) * (double)radius);
            consumer.method_22918(matrix4f, x, (float)position.method_10214(), z).method_39415(color);
            consumer.method_22918(matrix4f, x, (float)position.method_10214() + 0.1f, z).method_39415(color);
            float x2 = (float)(position.method_10216() + Math.sin(angle += angleStep) * (double)radius);
            float z2 = (float)(position.method_10215() + Math.cos(angle) * (double)radius);
            consumer.method_22918(matrix4f, x2, (float)position.method_10214() + 0.1f, z2).method_39415(color);
            consumer.method_22918(matrix4f, x2, (float)position.method_10214(), z2).method_39415(color);
        }
        BUFFER_SOURCE.method_22993();
        poseStack.method_22909();
        RenderSystem.enableCull();
    }
}

