/*
 * Decompiled with CFR 0.152.
 */
package com.wynntils.features.inventory;

import com.google.common.collect.Lists;
import com.wynntils.core.WynntilsMod;
import com.wynntils.core.components.Models;
import com.wynntils.core.consumers.features.Feature;
import com.wynntils.core.consumers.features.properties.RegisterKeyBind;
import com.wynntils.core.keybinds.KeyBind;
import com.wynntils.core.persisted.Persisted;
import com.wynntils.core.persisted.config.Category;
import com.wynntils.core.persisted.config.Config;
import com.wynntils.core.persisted.config.ConfigCategory;
import com.wynntils.core.text.StyledText;
import com.wynntils.core.text.type.StyleType;
import com.wynntils.mc.event.ItemTooltipRenderEvent;
import com.wynntils.mc.extension.MinecraftExtension;
import com.wynntils.utils.SystemUtils;
import com.wynntils.utils.mc.McUtils;
import com.wynntils.utils.render.FontRenderer;
import com.wynntils.utils.wynn.ItemUtils;
import java.awt.HeadlessException;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.List;
import java.util.regex.Matcher;
import javax.imageio.ImageIO;
import net.minecraft.class_1074;
import net.minecraft.class_124;
import net.minecraft.class_156;
import net.minecraft.class_1735;
import net.minecraft.class_1799;
import net.minecraft.class_2558;
import net.minecraft.class_2561;
import net.minecraft.class_276;
import net.minecraft.class_327;
import net.minecraft.class_332;
import net.minecraft.class_437;
import net.minecraft.class_4597;
import net.minecraft.class_465;
import net.minecraft.class_5348;
import net.minecraft.class_6364;
import net.minecraft.class_8000;
import net.minecraft.class_9799;
import net.neoforged.bus.api.EventPriority;
import net.neoforged.bus.api.SubscribeEvent;
import org.joml.Vector2i;

@ConfigCategory(value=Category.INVENTORY)
public class ItemScreenshotFeature
extends Feature {
    private static final class_8000 NO_POSITIONER = (screenWidth, screenHeight, mouseX, mouseY, tooltipWidth, tooltipHeight) -> new Vector2i(4, 4);
    @RegisterKeyBind
    private final KeyBind itemScreenshotKeyBind = new KeyBind("Screenshot Item", 293, true, null, this::onInventoryPress);
    @Persisted
    private final Config<Boolean> saveToDisk = new Config<Boolean>(false);
    private class_1735 screenshotSlot = null;

    private void onInventoryPress(class_1735 hoveredSlot) {
        this.screenshotSlot = hoveredSlot;
    }

    @SubscribeEvent(priority=EventPriority.LOW)
    public void render(ItemTooltipRenderEvent.Pre e) {
        if (!Models.WorldState.onWorld()) {
            return;
        }
        if (this.screenshotSlot == null || !this.screenshotSlot.method_7681()) {
            return;
        }
        class_437 screen = McUtils.screen();
        if (!(screen instanceof class_465)) {
            return;
        }
        this.takeScreenshot(screen, this.screenshotSlot, e.getTooltips());
        this.screenshotSlot = null;
    }

    private void takeScreenshot(class_437 screen, class_1735 hoveredSlot, List<class_2561> itemTooltip) {
        class_1799 itemStack = hoveredSlot.method_7677();
        ArrayList<class_2561> tooltip = new ArrayList<class_2561>(itemTooltip);
        ItemScreenshotFeature.removeLoreTooltipLines(tooltip);
        class_327 font = FontRenderer.getInstance().getFont();
        int width = 0;
        for (class_2561 c : tooltip) {
            int w = font.method_27525((class_5348)c);
            if (w <= width) continue;
            width = w;
        }
        width += 8;
        int height = 16;
        if (tooltip.size() > 1) {
            height += 2 + (tooltip.size() - 1) * 10;
        }
        float scaleh = (float)screen.field_22790 / (float)height;
        float scalew = (float)screen.field_22789 / (float)width;
        class_437.class_7998 deferredTooltipRendering = new class_437.class_7998(Lists.transform(tooltip, class_2561::method_30937), NO_POSITIONER);
        McUtils.mc().method_1522().method_1240();
        class_9799 byteBuffer = new class_9799(256);
        class_4597.class_4598 bufferSource = class_4597.method_22991((class_9799)byteBuffer);
        class_332 guiGraphics = new class_332(McUtils.mc(), bufferSource);
        class_6364 fb = new class_6364(width * 2, height * 2);
        fb.method_1236(1.0f, 1.0f, 1.0f, 0.0f);
        fb.method_1231(width * 2, height * 2);
        fb.method_1235(false);
        ((MinecraftExtension)McUtils.mc()).setOverridenRenderTarget((class_276)fb);
        guiGraphics.method_51448().method_22903();
        guiGraphics.method_51448().method_22905(scalew, scaleh, 1.0f);
        guiGraphics.method_51436(FontRenderer.getInstance().getFont(), deferredTooltipRendering.comp_1183(), deferredTooltipRendering.comp_1184(), 0, 0);
        guiGraphics.method_51448().method_22909();
        guiGraphics.method_51452();
        fb.method_1240();
        ((MinecraftExtension)McUtils.mc()).setOverridenRenderTarget(null);
        McUtils.mc().method_1522().method_1235(true);
        BufferedImage bi = SystemUtils.createScreenshot((class_276)fb);
        byteBuffer.close();
        bufferSource = null;
        if (((Boolean)this.saveToDisk.get()).booleanValue()) {
            String itemNameForFile = StyledText.fromComponent(itemStack.method_7964()).trim().replaceAll("\u2b21 ", "").replaceAll("[/ ]", "_").getNormalized().getString(StyleType.NONE);
            File screenshotDir = new File(McUtils.mc().field_1697, "screenshots");
            String filename = class_156.method_44893() + "-" + itemNameForFile + ".png";
            try {
                Files.createDirectories(screenshotDir.toPath(), new FileAttribute[0]);
                File outputfile = new File(screenshotDir, filename);
                ImageIO.write((RenderedImage)bi, "png", outputfile);
                McUtils.sendMessageToClient((class_2561)class_2561.method_43469((String)"feature.wynntils.itemScreenshot.save.message", (Object[])new Object[]{itemStack.method_7964(), class_2561.method_43470((String)outputfile.getName()).method_27692(class_124.field_1073).method_27694(style -> style.method_10958(new class_2558(class_2558.class_2559.field_11746, outputfile.getAbsolutePath())))}).method_27692(class_124.field_1060));
            }
            catch (IOException e) {
                WynntilsMod.error("Failed to save image to disk", e);
                McUtils.sendErrorToClient(class_1074.method_4662((String)"feature.wynntils.itemScreenshot.save.error", (Object[])new Object[]{itemStack.method_7964(), filename}));
            }
            if (SystemUtils.isMac()) {
                McUtils.sendMessageToClient((class_2561)class_2561.method_43471((String)"feature.wynntils.itemScreenshot.copy.mac").method_27692(class_124.field_1080));
                return;
            }
        } else if (SystemUtils.isMac()) {
            McUtils.sendMessageToClient((class_2561)class_2561.method_43471((String)"feature.wynntils.itemScreenshot.copy.mac2").method_27692(class_124.field_1080).method_10852((class_2561)class_2561.method_43471((String)"feature.wynntils.itemScreenshot.copy.mac.clickHere").method_27692(class_124.field_1080).method_27692(class_124.field_1073).method_27694(style -> style.method_10958(new class_2558(class_2558.class_2559.field_11750, "/wynntils config set ItemScreenshot saveToDisk true")))));
            return;
        }
        try {
            SystemUtils.copyImageToClipboard(bi);
            McUtils.sendMessageToClient((class_2561)class_2561.method_43471((String)"feature.wynntils.itemScreenshot.copy.message").method_27692(class_124.field_1060));
        }
        catch (HeadlessException ex) {
            WynntilsMod.error("Failed to copy image to clipboard", ex);
            McUtils.sendErrorToClient(class_1074.method_4662((String)"feature.wynntils.itemScreenshot.copy.error", (Object[])new Object[0]));
        }
    }

    private static void removeLoreTooltipLines(List<class_2561> tooltip) {
        int loreStart = -1;
        for (int i = 0; i < tooltip.size(); ++i) {
            String tooltipLine = tooltip.get(i).getString();
            Matcher matcher = ItemUtils.ITEM_RARITY_PATTERN.matcher(tooltipLine);
            if (!matcher.find()) continue;
            loreStart = i + 1;
            break;
        }
        if (loreStart != -1) {
            tooltip.subList(loreStart, tooltip.size()).clear();
        }
    }
}

