/*
 * Decompiled with CFR 0.152.
 */
package com.wynntils.features.inventory;

import com.wynntils.core.WynntilsMod;
import com.wynntils.core.components.Models;
import com.wynntils.core.consumers.features.Feature;
import com.wynntils.core.persisted.Persisted;
import com.wynntils.core.persisted.config.Category;
import com.wynntils.core.persisted.config.Config;
import com.wynntils.core.persisted.config.ConfigCategory;
import com.wynntils.core.text.StyledText;
import com.wynntils.mc.event.ContainerClickEvent;
import com.wynntils.mc.event.InventoryKeyPressEvent;
import com.wynntils.mc.event.MouseScrollEvent;
import com.wynntils.mc.event.ScreenClosedEvent;
import com.wynntils.mc.event.ScreenInitEvent;
import com.wynntils.models.containers.Container;
import com.wynntils.models.containers.containers.personal.AccountBankContainer;
import com.wynntils.models.containers.containers.personal.CharacterBankContainer;
import com.wynntils.models.containers.containers.personal.IslandBlockBankContainer;
import com.wynntils.models.containers.containers.personal.PersonalBlockBankContainer;
import com.wynntils.models.containers.containers.personal.PersonalStorageContainer;
import com.wynntils.models.containers.event.BankPageSetEvent;
import com.wynntils.screens.container.widgets.PersonalStorageUtilitiesWidget;
import com.wynntils.utils.colors.CommonColors;
import com.wynntils.utils.colors.CustomColor;
import com.wynntils.utils.mc.LoreUtils;
import com.wynntils.utils.mc.McUtils;
import com.wynntils.utils.wynn.ContainerUtils;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import net.minecraft.class_1799;
import net.minecraft.class_364;
import net.minecraft.class_437;
import net.minecraft.class_465;
import net.neoforged.bus.api.SubscribeEvent;

@ConfigCategory(value=Category.INVENTORY)
public class PersonalStorageUtilitiesFeature
extends Feature {
    @Persisted
    private final Config<CustomColor> selectedQuickJumpColor = new Config<CustomColor>(CommonColors.GREEN);
    @Persisted
    private final Config<CustomColor> lockedQuickJumpColor = new Config<CustomColor>(CommonColors.GRAY);
    private static final int STORAGE_TYPE_SLOT = 47;
    private static final Pattern PAGE_PATTERN = Pattern.compile("\u00a77- \u00a7f.*\u00a78 Page (\\d+)");
    private boolean quickJumping = false;
    private int currentPage = 1;
    private int lastPage = 21;
    private int pageDestination = 1;
    private PersonalStorageContainer storageContainer;
    private PersonalStorageUtilitiesWidget widget;

    @SubscribeEvent
    public void onScreenInit(ScreenInitEvent.Pre event) {
        if (Models.Bank.getStorageContainerType() == null) {
            return;
        }
        class_437 class_4372 = event.getScreen();
        if (!(class_4372 instanceof class_465)) {
            return;
        }
        class_465 screen = (class_465)class_4372;
        Container container = Models.Container.getCurrentContainer();
        if (!(container instanceof PersonalStorageContainer)) {
            return;
        }
        PersonalStorageContainer container2 = (PersonalStorageContainer)container;
        this.storageContainer = container2;
        this.lastPage = Models.Bank.getFinalPage();
        this.currentPage = Models.Bank.getCurrentPage();
        int renderX = (screen.field_22789 - screen.field_2792) / 2;
        int renderY = (screen.field_22790 - screen.field_2779) / 2;
        this.widget = (PersonalStorageUtilitiesWidget)screen.method_37063((class_364)new PersonalStorageUtilitiesWidget(renderX - 108, renderY, this.storageContainer, this, screen));
    }

    @SubscribeEvent
    public void onScreenClose(ScreenClosedEvent.Post e) {
        this.pageDestination = 1;
        this.quickJumping = false;
    }

    @SubscribeEvent
    public void onBankPageSet(BankPageSetEvent e) {
        if (Models.Bank.getStorageContainerType() == null) {
            return;
        }
        this.currentPage = Models.Bank.getCurrentPage();
        this.lastPage = Models.Bank.getFinalPage();
        this.widget.updatePageName();
        if (!this.quickJumping) {
            return;
        }
        if (this.pageDestination > this.lastPage) {
            this.quickJumping = false;
            this.pageDestination = this.currentPage;
        } else if (this.pageDestination != this.currentPage) {
            this.jumpToDestination(this.pageDestination);
        } else if (this.pageDestination == this.currentPage) {
            this.quickJumping = false;
        }
    }

    @SubscribeEvent
    public void onSlotClicked(ContainerClickEvent e) {
        if (Models.Bank.getStorageContainerType() == null) {
            return;
        }
        if ((Models.Container.getCurrentContainer() instanceof AccountBankContainer || Models.Container.getCurrentContainer() instanceof CharacterBankContainer || Models.Container.getCurrentContainer() instanceof IslandBlockBankContainer || Models.Container.getCurrentContainer() instanceof PersonalBlockBankContainer) && e.getSlotNum() == 47) {
            this.pageDestination = 1;
            this.quickJumping = false;
        }
        Models.Bank.toggleEditingName(false);
        this.widget.toggleEditInput(false);
    }

    @SubscribeEvent
    public void onInventoryKeyPress(InventoryKeyPressEvent event) {
        if (event.getKeyCode() != 257) {
            return;
        }
        if (!Models.Bank.isEditingName()) {
            return;
        }
        Models.Bank.saveCurrentPageName(this.widget.getName());
        this.widget.toggleEditInput(false);
        this.widget.updatePageName();
    }

    @SubscribeEvent
    public void onScroll(MouseScrollEvent event) {
        if (!Models.Bank.isEditingName()) {
            return;
        }
        this.widget.toggleEditInput(false);
    }

    public void jumpToDestination(int destination) {
        WynntilsMod.info("Navigating to page " + destination);
        this.quickJumping = true;
        this.pageDestination = destination;
        if (this.currentPage == this.pageDestination || this.pageDestination > this.lastPage) {
            return;
        }
        int pageDifference = this.pageDestination - this.currentPage;
        switch (pageDifference) {
            case 1: {
                if (this.currentPage == this.lastPage) break;
                this.clickNextPage();
                break;
            }
            case -1: {
                this.clickPreviousPage();
                break;
            }
            default: {
                if (this.tryToQuickJump()) break;
                if (this.currentPage > this.pageDestination) {
                    this.clickPreviousPage();
                    break;
                }
                if (this.currentPage == this.lastPage) break;
                this.clickNextPage();
            }
        }
    }

    private boolean tryToQuickJump() {
        int target;
        if (this.storageContainer.getQuickJumpDestinations().contains(this.pageDestination)) {
            target = this.storageContainer.getQuickJumpDestinations().indexOf(this.pageDestination);
        } else {
            int closest = this.storageContainer.getQuickJumpDestinations().getFirst();
            for (int destination : this.storageContainer.getQuickJumpDestinations()) {
                if (Math.abs(this.pageDestination - destination) >= Math.abs(this.pageDestination - closest)) continue;
                closest = destination;
            }
            target = this.storageContainer.getQuickJumpDestinations().indexOf(closest);
        }
        if (this.pageDestination >= this.currentPage && this.currentPage >= this.storageContainer.getQuickJumpDestinations().get(target)) {
            return false;
        }
        if (this.currentPage != this.lastPage) {
            class_1799 nextButton = (class_1799)McUtils.containerMenu().method_7602().get(this.storageContainer.getNextItemSlot());
            for (StyledText line : LoreUtils.getLore(nextButton)) {
                Matcher pageMatcher = line.getMatcher(PAGE_PATTERN);
                if (!pageMatcher.matches() || Integer.parseInt(pageMatcher.group(1)) != this.storageContainer.getQuickJumpDestinations().get(target)) continue;
                WynntilsMod.info("Quick jumping to " + String.valueOf(this.storageContainer.getQuickJumpDestinations().get(target)));
                ContainerUtils.pressKeyOnSlot(this.storageContainer.getNextItemSlot(), this.storageContainer.getContainerId(), target, (List<class_1799>)McUtils.containerMenu().method_7602());
                return true;
            }
        } else {
            class_1799 previousButton = (class_1799)McUtils.containerMenu().method_7602().get(this.storageContainer.getPreviousItemSlot());
            for (StyledText line : LoreUtils.getLore(previousButton)) {
                Matcher pageMatcher = line.getMatcher(PAGE_PATTERN);
                if (!pageMatcher.matches() || Integer.parseInt(pageMatcher.group(1)) != this.storageContainer.getQuickJumpDestinations().get(target)) continue;
                WynntilsMod.info("Quick jumping to " + String.valueOf(this.storageContainer.getQuickJumpDestinations().get(target)));
                ContainerUtils.pressKeyOnSlot(this.storageContainer.getPreviousItemSlot(), this.storageContainer.getContainerId(), target, (List<class_1799>)McUtils.containerMenu().method_7602());
                return true;
            }
        }
        return false;
    }

    private void clickNextPage() {
        WynntilsMod.info("Jumping to next page");
        ContainerUtils.clickOnSlot(this.storageContainer.getNextItemSlot(), this.storageContainer.getContainerId(), 0, (List<class_1799>)McUtils.containerMenu().method_7602());
    }

    private void clickPreviousPage() {
        WynntilsMod.info("Jumping to previous page");
        ContainerUtils.clickOnSlot(this.storageContainer.getPreviousItemSlot(), this.storageContainer.getContainerId(), 0, (List<class_1799>)McUtils.containerMenu().method_7602());
    }

    public CustomColor getSelectedQuickJumpColor() {
        return (CustomColor)this.selectedQuickJumpColor.get();
    }

    public CustomColor getLockedQuickJumpColor() {
        return (CustomColor)this.lockedQuickJumpColor.get();
    }
}

