/*
 * Decompiled with CFR 0.152.
 */
package com.wynntils.features.overlays;

import com.wynntils.core.WynntilsMod;
import com.wynntils.core.consumers.features.Feature;
import com.wynntils.core.consumers.overlays.annotations.OverlayInfo;
import com.wynntils.core.persisted.Persisted;
import com.wynntils.core.persisted.config.Category;
import com.wynntils.core.persisted.config.Config;
import com.wynntils.core.persisted.config.ConfigCategory;
import com.wynntils.mc.event.RenderEvent;
import com.wynntils.models.raid.event.RaidEndedEvent;
import com.wynntils.models.raid.event.RaidNewBestTimeEvent;
import com.wynntils.overlays.RaidProgressOverlay;
import com.wynntils.utils.StringUtils;
import com.wynntils.utils.mc.McUtils;
import net.minecraft.class_124;
import net.minecraft.class_2561;
import net.minecraft.class_3417;
import net.minecraft.class_5250;
import net.neoforged.bus.api.SubscribeEvent;

@ConfigCategory(value=Category.OVERLAYS)
public class RaidProgressFeature
extends Feature {
    private static final String TIME_FORMAT_MILLISECONDS = "%02d:%02d.%03d";
    private static final String TIME_FORMAT_SECONDS = "%02d:%02d";
    @OverlayInfo(renderType=RenderEvent.ElementType.GUI)
    private final RaidProgressOverlay raidProgressOverlay = new RaidProgressOverlay();
    @Persisted
    private final Config<Boolean> printTimes = new Config<Boolean>(true);
    @Persisted
    private final Config<Boolean> playSoundOnBest = new Config<Boolean>(true);

    @SubscribeEvent
    public void onRaidCompleted(RaidEndedEvent.Completed event) {
        int i;
        if (!((Boolean)this.printTimes.get()).booleanValue()) {
            return;
        }
        if (event.getRaid().completedChallengeCount() == 0) {
            WynntilsMod.error("Completed raid but no completed rooms were tracked");
            return;
        }
        class_5250 raidComponents = class_2561.method_43470((String)"");
        raidComponents.method_10852((class_2561)class_2561.method_43470((String)event.getRaid().getRaidKind().getRaidName()).method_27692(class_124.field_1065).method_27692(class_124.field_1067).method_27692(class_124.field_1073));
        raidComponents.method_10852((class_2561)class_2561.method_43470((String)"\n\n"));
        for (i = 0; i < event.getRaid().getRaidKind().getChallengeCount(); ++i) {
            if (event.getRaid().getRoomByNumber(i + 1) == null) {
                WynntilsMod.warn("Completed raid " + event.getRaid().getRaidKind().getRaidName() + " but missing challenge room " + i);
                continue;
            }
            raidComponents.method_10852((class_2561)class_2561.method_43470((String)(event.getRaid().getRoomByNumber(i + 1).getRoomName() + ": ")).method_27692(class_124.field_1076));
            raidComponents.method_10852((class_2561)class_2561.method_43470((String)this.formatTime(event.getRaid().getRoomByNumber(i + 1).getRoomTotalTime())).method_27692(class_124.field_1075));
            if (((Boolean)this.raidProgressOverlay.showDamage.get()).booleanValue()) {
                raidComponents.method_10852((class_2561)class_2561.method_43470((String)" (").method_27692(class_124.field_1068)).method_10852((class_2561)class_2561.method_43470((String)StringUtils.integerToShortString(event.getRaid().getRoomByNumber(i + 1).getRoomDamage())).method_27692(class_124.field_1054)).method_10852((class_2561)class_2561.method_43470((String)")").method_27692(class_124.field_1068));
            }
            raidComponents.method_10852((class_2561)class_2561.method_43470((String)"\n"));
        }
        raidComponents.method_10852((class_2561)class_2561.method_43470((String)"\n"));
        for (i = 0; i < event.getRaid().getRaidKind().getBossCount(); ++i) {
            int bossRoomNum = i + event.getRaid().getRaidKind().getChallengeCount() + 1;
            if (event.getRaid().getRoomByNumber(bossRoomNum) == null) {
                WynntilsMod.warn("Completed raid " + event.getRaid().getRaidKind().getRaidName() + " but missing boss room " + bossRoomNum);
                continue;
            }
            String bossName = event.getRaid().getRoomByNumber(bossRoomNum).getRoomName();
            if (bossName.equals("The ##### Anomaly")) {
                raidComponents.method_10852((class_2561)class_2561.method_43470((String)"The ").method_27692(class_124.field_1079)).method_10852((class_2561)class_2561.method_43470((String)"#####").method_27695(new class_124[]{class_124.field_1079, class_124.field_1051})).method_10852((class_2561)class_2561.method_43470((String)" Anomaly: ").method_27692(class_124.field_1079));
            } else {
                raidComponents.method_10852((class_2561)class_2561.method_43470((String)(bossName + ": ")).method_27692(class_124.field_1079));
            }
            raidComponents.method_10852((class_2561)class_2561.method_43470((String)this.formatTime(event.getRaid().getRoomByNumber(bossRoomNum).getRoomTotalTime())).method_27692(class_124.field_1075));
            if (((Boolean)this.raidProgressOverlay.showDamage.get()).booleanValue()) {
                raidComponents.method_10852((class_2561)class_2561.method_43470((String)" (").method_27692(class_124.field_1068)).method_10852((class_2561)class_2561.method_43470((String)StringUtils.integerToShortString(event.getRaid().getRoomByNumber(bossRoomNum).getRoomDamage())).method_27692(class_124.field_1054)).method_10852((class_2561)class_2561.method_43470((String)")").method_27692(class_124.field_1068));
            }
            raidComponents.method_10852((class_2561)class_2561.method_43470((String)"\n"));
        }
        if (((Boolean)this.raidProgressOverlay.showIntermission.get()).booleanValue()) {
            raidComponents.method_10852((class_2561)class_2561.method_43470((String)"\nIntermission: ").method_27692(class_124.field_1063));
            raidComponents.method_10852((class_2561)class_2561.method_43470((String)this.formatTime(event.getRaid().getIntermissionTime())).method_27692(class_124.field_1075));
        }
        raidComponents.method_10852((class_2561)class_2561.method_43470((String)"\nTotal: ").method_27692(class_124.field_1064));
        long raidTime = event.getRaid().getTimeInRaid() - ((Boolean)this.raidProgressOverlay.totalIntermission.get() != false ? 0L : event.getRaid().getIntermissionTime());
        raidComponents.method_10852((class_2561)class_2561.method_43470((String)this.formatTime(raidTime)).method_27692(class_124.field_1075));
        if (((Boolean)this.raidProgressOverlay.showDamage.get()).booleanValue()) {
            raidComponents.method_10852((class_2561)class_2561.method_43470((String)" (").method_27692(class_124.field_1068)).method_10852((class_2561)class_2561.method_43470((String)StringUtils.integerToShortString(event.getRaid().getRaidDamage())).method_27692(class_124.field_1054)).method_10852((class_2561)class_2561.method_43470((String)")").method_27692(class_124.field_1068));
        }
        McUtils.sendMessageToClient((class_2561)raidComponents);
    }

    @SubscribeEvent
    public void onRaidPersonalBest(RaidNewBestTimeEvent event) {
        if (!((Boolean)this.printTimes.get()).booleanValue()) {
            return;
        }
        long minutes = event.getTime() / 1000L / 60L;
        long seconds = event.getTime() / 1000L % 60L;
        long milliseconds = event.getTime() % 1000L;
        McUtils.sendMessageToClient((class_2561)class_2561.method_43469((String)"feature.wynntils.raidProgress.personalBest", (Object[])new Object[]{event.getRaidName(), minutes, seconds, milliseconds}).method_27692(class_124.field_1065).method_27692(class_124.field_1067));
        if (((Boolean)this.playSoundOnBest.get()).booleanValue()) {
            McUtils.playSoundAmbient(class_3417.field_15188);
        }
    }

    private String formatTime(long time) {
        long minutes = time / 1000L / 60L;
        long seconds = time / 1000L % 60L;
        long milliseconds = time % 1000L;
        if (((Boolean)this.raidProgressOverlay.showMilliseconds.get()).booleanValue()) {
            return String.format(TIME_FORMAT_MILLISECONDS, minutes, seconds, milliseconds);
        }
        return String.format(TIME_FORMAT_SECONDS, minutes, seconds);
    }
}

