/*
 * Decompiled with CFR 0.152.
 */
package com.wynntils.features.overlays;

import com.wynntils.core.consumers.features.Feature;
import com.wynntils.core.consumers.overlays.Overlay;
import com.wynntils.core.consumers.overlays.annotations.OverlayInfo;
import com.wynntils.core.persisted.Persisted;
import com.wynntils.core.persisted.config.Category;
import com.wynntils.core.persisted.config.Config;
import com.wynntils.core.persisted.config.ConfigCategory;
import com.wynntils.core.text.StyledText;
import com.wynntils.mc.event.RenderEvent;
import com.wynntils.models.war.event.GuildWarEvent;
import com.wynntils.models.war.type.WarBattleInfo;
import com.wynntils.models.war.type.WarTowerState;
import com.wynntils.overlays.TowerStatsOverlay;
import com.wynntils.utils.StringUtils;
import com.wynntils.utils.mc.McUtils;
import net.minecraft.class_124;
import net.minecraft.class_2558;
import net.minecraft.class_2561;
import net.minecraft.class_2568;
import net.minecraft.class_5250;
import net.neoforged.bus.api.SubscribeEvent;

@ConfigCategory(value=Category.OVERLAYS)
public class TowerStatsFeature
extends Feature {
    private static final int SEPARATOR_LENGTH = 40;
    @OverlayInfo(renderType=RenderEvent.ElementType.GUI)
    public final Overlay towerStatsOverlay = new TowerStatsOverlay();
    @Persisted
    private final Config<Boolean> printTowerStatsOnEnd = new Config<Boolean>(true);

    @SubscribeEvent
    public void onWarEnd(GuildWarEvent.Ended event) {
        if (!((Boolean)this.printTowerStatsOnEnd.get()).booleanValue()) {
            return;
        }
        WarBattleInfo warBattleInfo = event.getWarBattleInfo();
        WarTowerState initialTowerState = warBattleInfo.getInitialState();
        WarTowerState endTowerState = warBattleInfo.getCurrentState();
        class_5250 message = class_2561.method_43473().method_10852((class_2561)TowerStatsFeature.getSeparatorComponent("Tower Stats - Initial", 40));
        message = message.method_10852((class_2561)TowerStatsFeature.getTowerStatsComponent(warBattleInfo.getTerritory(), warBattleInfo.getOwnerGuild(), initialTowerState));
        if (!endTowerState.equals(initialTowerState)) {
            message = message.method_10852((class_2561)TowerStatsFeature.getSeparatorComponent("Tower Stats - End", 40)).method_10852((class_2561)TowerStatsFeature.getTowerStatsComponent(warBattleInfo.getTerritory(), warBattleInfo.getOwnerGuild(), endTowerState));
        }
        message = message.method_10852((class_2561)class_2561.method_43470((String)"\ud83d\udd51 Time in War: ").method_27692(class_124.field_1065).method_10852((class_2561)class_2561.method_43470((String)"%s".formatted(StringUtils.formatDuration(warBattleInfo.getTotalLengthSeconds()))).method_27692(class_124.field_1068))).method_10852((class_2561)class_2561.method_43470((String)"\n")).method_10852((class_2561)class_2561.method_43470((String)"\u2694 DPS: ").method_27692(class_124.field_1065).method_10852((class_2561)class_2561.method_43470((String)"%s".formatted(StringUtils.integerToShortString(warBattleInfo.getDps(Long.MAX_VALUE)))).method_27692(class_124.field_1068))).method_10852((class_2561)class_2561.method_43470((String)"\n"));
        message = message.method_10852((class_2561)class_2561.method_43470((String)"%s".formatted("=".repeat(40))).method_27692(class_124.field_1078).method_27692(class_124.field_1055));
        String messageString = StyledText.fromComponent((class_2561)message).getStringWithoutFormatting();
        message = message.method_27694(style -> style.method_10949(new class_2568(class_2568.class_5247.field_24342, (Object)class_2561.method_43470((String)"Click to copy to clipboard."))).method_10958(new class_2558(class_2558.class_2559.field_21462, messageString)));
        McUtils.sendMessageToClient((class_2561)message);
    }

    private static class_5250 getSeparatorComponent(String text, int separatorLength) {
        String separator = "=".repeat(separatorLength);
        int textLength = text.length();
        int totalPadding = separatorLength - textLength;
        int paddingSide = totalPadding / 2;
        String padding = " ".repeat(paddingSide);
        return class_2561.method_43473().method_10852((class_2561)class_2561.method_43470((String)(separator + "\n")).method_27695(new class_124[]{class_124.field_1078, class_124.field_1055})).method_10852((class_2561)class_2561.method_43470((String)(padding + text + padding + "\n")).method_27695(new class_124[]{class_124.field_1078, class_124.field_1067})).method_10852((class_2561)class_2561.method_43470((String)(separator + "\n")).method_27695(new class_124[]{class_124.field_1078, class_124.field_1055}));
    }

    private static class_5250 getTowerStatsComponent(String territory, String ownerGuild, WarTowerState initialTowerState) {
        return class_2561.method_43473().method_10852((class_2561)class_2561.method_43470((String)territory).method_27692(class_124.field_1065).method_27692(class_124.field_1067).method_10852((class_2561)class_2561.method_43470((String)" [").method_27692(class_124.field_1062).method_10852((class_2561)class_2561.method_43470((String)"%s".formatted(ownerGuild)).method_27692(class_124.field_1075).method_10852((class_2561)class_2561.method_43470((String)"]").method_27692(class_124.field_1062))))).method_10852((class_2561)class_2561.method_43470((String)"\n")).method_10852((class_2561)class_2561.method_43470((String)"\u2723 Damage: ").method_27692(class_124.field_1065).method_10852((class_2561)class_2561.method_43470((String)"%s".formatted(initialTowerState.damage().low())).method_27692(class_124.field_1068).method_10852((class_2561)class_2561.method_43470((String)" - ").method_27692(class_124.field_1080).method_10852((class_2561)class_2561.method_43470((String)"%s".formatted(initialTowerState.damage().high())).method_27692(class_124.field_1068)))).method_10852((class_2561)class_2561.method_43470((String)"\n"))).method_10852((class_2561)class_2561.method_43470((String)"\u27a1 Attack Speed: ").method_27692(class_124.field_1060).method_10852((class_2561)class_2561.method_43470((String)"%.2fx".formatted(initialTowerState.attackSpeed())).method_27692(class_124.field_1068))).method_10852((class_2561)class_2561.method_43470((String)"\n")).method_10852((class_2561)class_2561.method_43470((String)"\u2764 Health: ").method_27692(class_124.field_1061).method_10852((class_2561)class_2561.method_43470((String)"%d".formatted(initialTowerState.health())).method_27692(class_124.field_1068))).method_10852((class_2561)class_2561.method_43470((String)"\n")).method_10852((class_2561)class_2561.method_43470((String)"\u26e8 Defense: ").method_27692(class_124.field_1075).method_10852((class_2561)class_2561.method_43470((String)("%.2f".formatted(initialTowerState.defense()) + "%")).method_27692(class_124.field_1068))).method_10852((class_2561)class_2561.method_43470((String)"\n"));
    }
}

