/*
 * Decompiled with CFR 0.152.
 */
package com.wynntils.features.trademarket;

import com.wynntils.core.WynntilsMod;
import com.wynntils.core.components.Models;
import com.wynntils.core.consumers.features.Feature;
import com.wynntils.core.consumers.features.properties.RegisterKeyBind;
import com.wynntils.core.keybinds.KeyBind;
import com.wynntils.core.persisted.Persisted;
import com.wynntils.core.persisted.config.Category;
import com.wynntils.core.persisted.config.Config;
import com.wynntils.core.persisted.config.ConfigCategory;
import com.wynntils.core.text.StyledText;
import com.wynntils.mc.event.MenuEvent;
import com.wynntils.mc.event.ScreenClosedEvent;
import com.wynntils.models.trademarket.event.TradeMarketChatInputEvent;
import com.wynntils.models.trademarket.type.TradeMarketState;
import com.wynntils.utils.mc.KeyboardUtils;
import com.wynntils.utils.mc.McUtils;
import com.wynntils.utils.wynn.ContainerUtils;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import net.minecraft.class_1735;
import net.minecraft.class_1799;
import net.minecraft.class_3675;
import net.minecraft.class_408;
import net.minecraft.class_437;
import net.neoforged.bus.api.EventPriority;
import net.neoforged.bus.api.SubscribeEvent;

@ConfigCategory(value=Category.TRADEMARKET)
public class TradeMarketQuickSearchFeature
extends Feature {
    @Persisted
    private final Config<Boolean> instantSearch = new Config<Boolean>(true);
    @Persisted
    private final Config<Boolean> autoCancel = new Config<Boolean>(true);
    @Persisted
    private final Config<Boolean> hidePrompt = new Config<Boolean>(false);
    @RegisterKeyBind
    private final KeyBind quickSearchKeyBind = new KeyBind("Quick Search TM", 2, class_3675.class_307.field_1672, true, null, this::tryQuickSearch);
    private static final Pattern CUT_PATTERN = Pattern.compile("(Emerald Pouch|\\[.*?\\]|[\\uE000-\\uF8FF]+|Unidentified \\u2B21|\\u2B21)\\s*");
    private static final Pattern POTION_PATTERN = Pattern.compile("^Potion of (. \\w+)");
    private static final Pattern EOL_PATTERN = Pattern.compile("\u00c0+$");
    private static final int SEARCH_SLOT = 47;
    private String searchQuery;
    private boolean openChatWhenContainerClosed = false;
    private boolean quickSearching = false;
    private boolean instantSearchingSendChat = false;
    private boolean instantSearchingCloseMenu = false;

    @SubscribeEvent
    public void onScreenClosed(ScreenClosedEvent.Post event) {
        if (Models.TradeMarket.inChatInput() && event.getScreen() instanceof class_408) {
            if (((Boolean)this.autoCancel.get()).booleanValue() && KeyboardUtils.isKeyDown(256)) {
                McUtils.sendChat("cancel");
            }
            return;
        }
        if (this.openChatWhenContainerClosed) {
            this.openChat();
            this.openChatWhenContainerClosed = false;
        }
    }

    @SubscribeEvent(priority=EventPriority.HIGH)
    public void onMenuClosed(MenuEvent.MenuClosedEvent event) {
        if (!Models.TradeMarket.inTradeMarket()) {
            return;
        }
        if (this.instantSearchingCloseMenu) {
            event.setCanceled(true);
            this.instantSearchingCloseMenu = false;
        }
    }

    @SubscribeEvent
    public void onTradeMarketChatInput(TradeMarketChatInputEvent event) {
        if (event.getState() == TradeMarketState.SEARCH_CHAT_INPUT && this.instantSearchingSendChat) {
            event.setResponse(this.searchQuery);
            event.cancelChat();
            this.instantSearchingSendChat = false;
            return;
        }
        if (McUtils.screen() == null) {
            this.openChat();
        } else {
            this.openChatWhenContainerClosed = true;
        }
        if (((Boolean)this.hidePrompt.get()).booleanValue()) {
            event.cancelChat();
        }
    }

    private void openChat() {
        if (this.quickSearching) {
            McUtils.setScreen((class_437)new class_408(this.searchQuery));
            this.quickSearching = false;
        } else {
            McUtils.setScreen((class_437)new class_408(""));
        }
    }

    private void tryQuickSearch(class_1735 hoveredSlot) {
        if (!Models.TradeMarket.inTradeMarket() || hoveredSlot == null || !hoveredSlot.method_7681()) {
            return;
        }
        if ((Boolean)this.instantSearch.get() != KeyboardUtils.isKeyDown(340)) {
            this.instantSearchingSendChat = true;
            this.instantSearchingCloseMenu = true;
        } else {
            this.quickSearching = true;
        }
        this.searchQuery = StyledText.fromComponent(hoveredSlot.method_7677().method_7964()).getStringWithoutFormatting();
        this.searchQuery = this.getSearchQuery(this.searchQuery);
        if (this.searchQuery == null || this.searchQuery.isBlank()) {
            return;
        }
        ContainerUtils.clickOnSlot(47, McUtils.containerMenu().field_7763, 0, (List<class_1799>)McUtils.containerMenu().method_7602());
    }

    private String getSearchQuery(String rawName) {
        String searchTerm = CUT_PATTERN.matcher(rawName).replaceFirst("");
        Matcher potionMatcher = POTION_PATTERN.matcher(searchTerm = EOL_PATTERN.matcher(searchTerm).replaceFirst("").trim());
        if (potionMatcher.matches()) {
            searchTerm = potionMatcher.group(1);
        }
        WynntilsMod.info("Quick Searching: " + rawName + " -> " + searchTerm);
        return searchTerm;
    }
}

