/*
 * Decompiled with CFR 0.152.
 */
package com.wynntils.features.ui;

import com.wynntils.core.components.Models;
import com.wynntils.core.consumers.features.Feature;
import com.wynntils.core.persisted.Persisted;
import com.wynntils.core.persisted.config.Category;
import com.wynntils.core.persisted.config.Config;
import com.wynntils.core.persisted.config.ConfigCategory;
import com.wynntils.core.text.StyledText;
import com.wynntils.mc.event.ContainerRenderEvent;
import com.wynntils.models.containers.Container;
import com.wynntils.models.containers.containers.CraftingStationContainer;
import com.wynntils.models.profession.type.ProfessionType;
import com.wynntils.utils.colors.CommonColors;
import com.wynntils.utils.render.FontRenderer;
import com.wynntils.utils.render.RenderUtils;
import com.wynntils.utils.render.Texture;
import com.wynntils.utils.render.type.HorizontalAlignment;
import com.wynntils.utils.render.type.ObjectivesTextures;
import com.wynntils.utils.render.type.TextShadow;
import com.wynntils.utils.render.type.VerticalAlignment;
import net.minecraft.class_4587;
import net.minecraft.class_465;
import net.minecraft.class_476;
import net.neoforged.bus.api.SubscribeEvent;

@ConfigCategory(value=Category.UI)
public class CraftingProfessionLevelProgressBarFeature
extends Feature {
    @Persisted
    private final Config<ObjectivesTextures> texture = new Config<ObjectivesTextures>(ObjectivesTextures.WYNN);

    @SubscribeEvent
    public void onContainerRender(ContainerRenderEvent event) {
        class_465<?> class_4652 = event.getScreen();
        if (!(class_4652 instanceof class_476)) {
            return;
        }
        class_476 screen = (class_476)class_4652;
        Container container = Models.Container.getCurrentContainer();
        if (!(container instanceof CraftingStationContainer)) {
            return;
        }
        CraftingStationContainer container2 = (CraftingStationContainer)container;
        class_4587 poseStack = event.getPoseStack();
        ProfessionType profession = container2.getProfessionType();
        int level = Models.Profession.getLevel(profession);
        double progress = Models.Profession.getProgress(profession);
        RenderUtils.drawProgressBar(poseStack, Texture.EXPERIENCE_BAR, screen.field_2776, screen.field_2800 - 6, screen.field_2776 + screen.field_2792, screen.field_2800 - 1, 0, ((ObjectivesTextures)this.texture.get()).getTextureY1(), Texture.EXPERIENCE_BAR.width(), ((ObjectivesTextures)this.texture.get()).getTextureY2(), (float)(progress / 100.0));
        String text = "Level %d (%.2f%%)".formatted(level, progress);
        FontRenderer.getInstance().renderText(poseStack, StyledText.fromString(text), (float)screen.field_22789 / 2.0f, (float)(screen.field_2800 - 8), 0.0f, CommonColors.GREEN, HorizontalAlignment.CENTER, VerticalAlignment.BOTTOM, TextShadow.NORMAL);
    }
}

