/*
 * Decompiled with CFR 0.152.
 */
package com.wynntils.features.ui;

import com.wynntils.core.components.Models;
import com.wynntils.core.consumers.features.Feature;
import com.wynntils.core.persisted.Persisted;
import com.wynntils.core.persisted.config.Category;
import com.wynntils.core.persisted.config.Config;
import com.wynntils.core.persisted.config.ConfigCategory;
import com.wynntils.core.text.StyledText;
import com.wynntils.handlers.wrappedscreen.event.WrappedScreenOpenEvent;
import com.wynntils.mc.event.ContainerClickEvent;
import com.wynntils.models.containers.containers.GuildManagementContainer;
import com.wynntils.screens.guildlog.GuildLogScreen;
import com.wynntils.utils.mc.KeyboardUtils;
import com.wynntils.utils.type.ShiftBehavior;
import java.util.regex.Pattern;
import net.neoforged.bus.api.SubscribeEvent;

@ConfigCategory(value=Category.UI)
public class CustomGuildLogScreenFeature
extends Feature {
    private static final Pattern GUILD_LOG_ITEM_PATTERN = Pattern.compile("\u00a77\u00a7lGuild Log");
    @Persisted
    private final Config<ShiftBehavior> shiftBehaviorConfig = new Config<ShiftBehavior>(ShiftBehavior.DISABLED_IF_SHIFT_HELD);
    private boolean shiftClickedLogItem = false;

    @SubscribeEvent
    public void onWrappedScreenOpen(WrappedScreenOpenEvent event) {
        if (event.getWrappedScreenClass() != GuildLogScreen.class) {
            return;
        }
        boolean shouldOpen = false;
        switch ((ShiftBehavior)((Object)this.shiftBehaviorConfig.get())) {
            case NONE: {
                shouldOpen = true;
                break;
            }
            case ENABLED_IF_SHIFT_HELD: {
                if (!this.shiftClickedLogItem) break;
                shouldOpen = true;
                break;
            }
            case DISABLED_IF_SHIFT_HELD: {
                if (this.shiftClickedLogItem) break;
                shouldOpen = true;
            }
        }
        if (shouldOpen) {
            event.setOpenScreen(true);
        }
    }

    @SubscribeEvent
    public void onContainerClick(ContainerClickEvent event) {
        if (!(Models.Container.getCurrentContainer() instanceof GuildManagementContainer)) {
            return;
        }
        if (!StyledText.fromComponent(event.getItemStack().method_7964()).matches(GUILD_LOG_ITEM_PATTERN)) {
            return;
        }
        this.shiftClickedLogItem = KeyboardUtils.isShiftDown();
    }
}

