/*
 * Decompiled with CFR 0.152.
 */
package com.wynntils.features.wynntils;

import com.wynntils.core.WynntilsMod;
import com.wynntils.core.components.Managers;
import com.wynntils.core.consumers.features.Feature;
import com.wynntils.core.mod.event.WynntilsCrashEvent;
import com.wynntils.core.net.ApiResponse;
import com.wynntils.core.net.UrlId;
import com.wynntils.core.persisted.Persisted;
import com.wynntils.core.persisted.config.Category;
import com.wynntils.core.persisted.config.Config;
import com.wynntils.core.persisted.config.ConfigCategory;
import com.wynntils.models.worlds.event.WorldStateEvent;
import com.wynntils.models.worlds.type.WorldState;
import com.wynntils.utils.JsonUtils;
import com.wynntils.utils.mc.McUtils;
import com.wynntils.utils.type.ConfirmedBoolean;
import java.util.Locale;
import java.util.Map;
import net.minecraft.class_124;
import net.minecraft.class_2558;
import net.minecraft.class_2561;
import net.minecraft.class_5250;
import net.neoforged.bus.api.SubscribeEvent;
import org.apache.commons.lang3.exception.ExceptionUtils;

@ConfigCategory(value=Category.WYNNTILS)
public class TelemetryFeature
extends Feature {
    @Persisted
    private final Config<ConfirmedBoolean> crashReports = new Config<ConfirmedBoolean>(ConfirmedBoolean.UNCONFIRMED);

    @SubscribeEvent
    public void onCrash(WynntilsCrashEvent event) {
        if (this.crashReports.get() != ConfirmedBoolean.TRUE) {
            return;
        }
        if (WynntilsMod.isDevelopmentEnvironment()) {
            return;
        }
        if (WynntilsMod.getVersion().contains("SNAPSHOT")) {
            return;
        }
        String title = "Crashed " + event.getType().toString().toLowerCase(Locale.ROOT) + ": " + event.getName() + "\n";
        String trace = ExceptionUtils.getStackTrace((Throwable)event.getThrowable());
        ApiResponse apiResponse = Managers.Net.callApi(UrlId.API_ATHENA_TELEMETRY_CRASH, Map.of("trace", title + trace));
        apiResponse.handleJsonObject(json -> {
            String response = JsonUtils.getNullableJsonString(json, "message");
            String hash = JsonUtils.getNullableJsonString(json, "hash");
            if (response != null && response.equals("Crash report logged successfully.")) {
                WynntilsMod.info("Crash reported to Athena as " + hash);
            } else {
                WynntilsMod.warn("Failed to report crash reported to Athena: " + response);
            }
        });
    }

    @SubscribeEvent
    public void onWorldChange(WorldStateEvent event) {
        if (event.getNewState() != WorldState.WORLD) {
            return;
        }
        if (this.crashReports.get() != ConfirmedBoolean.UNCONFIRMED) {
            return;
        }
        class_5250 component = class_2561.method_43470((String)"Wynntils Telemetry\n").method_27692(class_124.field_1075);
        component.method_10852((class_2561)class_2561.method_43470((String)"Wynntils can send telemetry data when a component fails.\nThis data does not contain any personal information,\nbut is helpful for developers for fixing bugs in Wynntils.\n").method_27692(class_124.field_1080));
        component.method_10852((class_2561)class_2561.method_43470((String)"Click here").method_27692(class_124.field_1060).method_27692(class_124.field_1073).method_27694(style -> style.method_10958(new class_2558(class_2558.class_2559.field_11750, "/wynntils config set Telemetry crashReports true"))));
        component.method_10852((class_2561)class_2561.method_43470((String)" to accept crash report telemetry\n").method_27692(class_124.field_1060));
        component.method_10852((class_2561)class_2561.method_43470((String)"Click here").method_27692(class_124.field_1061).method_27692(class_124.field_1073).method_27694(style -> style.method_10958(new class_2558(class_2558.class_2559.field_11750, "/wynntils config set Telemetry crashReports false"))));
        component.method_10852((class_2561)class_2561.method_43470((String)" to opt out of crash report telemetry\n").method_27692(class_124.field_1061));
        McUtils.sendMessageToClient((class_2561)component);
    }
}

