/*
 * Decompiled with CFR 0.152.
 */
package com.wynntils.hades.objects;

import com.wynntils.hades.protocol.enums.PacketDirection;
import com.wynntils.hades.protocol.interfaces.HadesHandlerFactory;
import com.wynntils.hades.protocol.interfaces.HadesPacket;
import com.wynntils.hades.protocol.interfaces.IHadesAdapter;
import io.netty.channel.Channel;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.SimpleChannelInboundHandler;
import java.net.InetSocketAddress;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;

public class HadesConnection
extends SimpleChannelInboundHandler<HadesPacket<?>> {
    PacketDirection direction;
    Channel channel;
    Future<?> autoFlusher;
    IHadesAdapter packetListener;

    public HadesConnection(PacketDirection direction, HadesHandlerFactory handlerFactory) {
        this.direction = direction;
        this.packetListener = handlerFactory.createHandler(this);
    }

    public void sendPacket(HadesPacket packet) {
        if (this.channel == null || !this.channel.isOpen()) {
            return;
        }
        if (!this.channel.eventLoop().inEventLoop()) {
            this.channel.eventLoop().execute(() -> this.channel.write((Object)packet));
            return;
        }
        this.channel.write((Object)packet);
    }

    public void sendPacketAndFlush(HadesPacket packet) {
        if (this.channel == null || !this.channel.isOpen()) {
            return;
        }
        if (!this.channel.eventLoop().inEventLoop()) {
            this.channel.eventLoop().execute(() -> this.channel.writeAndFlush((Object)packet));
            return;
        }
        this.channel.writeAndFlush((Object)packet);
    }

    public void disconnect() {
        if (this.channel == null || !this.channel.isOpen()) {
            return;
        }
        this.channel.close().awaitUninterruptibly();
    }

    public void flushPackets() {
        if (this.channel == null || !this.channel.isOpen()) {
            return;
        }
        this.channel.flush();
    }

    public boolean isOpen() {
        return this.channel != null && this.channel.isOpen();
    }

    public String getIp() {
        InetSocketAddress address = (InetSocketAddress)this.channel.remoteAddress();
        return address.getAddress().getHostAddress();
    }

    public void channelActive(ChannelHandlerContext ctx) throws Exception {
        this.channel = ctx.channel();
        this.autoFlusher = this.channel.eventLoop().scheduleAtFixedRate(() -> this.channel.flush(), 25L, 25L, TimeUnit.MILLISECONDS);
        this.packetListener.onConnect();
    }

    public void channelInactive(ChannelHandlerContext ctx) throws Exception {
        if (this.autoFlusher != null) {
            this.autoFlusher.cancel(true);
        }
        this.packetListener.onDisconnect();
    }

    protected void channelRead0(ChannelHandlerContext ctx, HadesPacket<?> msg) throws Exception {
        if (this.channel == null || !this.channel.isOpen() || this.packetListener == null) {
            return;
        }
        msg.process(this.packetListener);
    }

    public void exceptionCaught(ChannelHandlerContext ctx, Throwable cause) {
        cause.printStackTrace();
    }
}

