/*
 * Decompiled with CFR 0.152.
 */
package com.wynntils.hades.protocol.io;

import com.wynntils.hades.utils.HadesBuffer;
import io.netty.buffer.ByteBuf;
import io.netty.buffer.Unpooled;
import io.netty.channel.ChannelHandlerContext;
import io.netty.handler.codec.ByteToMessageDecoder;
import io.netty.handler.codec.DecoderException;
import java.util.List;
import java.util.zip.Inflater;

public class HadesCompressionDecoder
extends ByteToMessageDecoder {
    private final HadesBuffer buffer = new HadesBuffer();
    private final Inflater inflater = new Inflater();
    private final int threshold;

    public HadesCompressionDecoder(int threshold) {
        this.threshold = threshold;
    }

    protected void decode(ChannelHandlerContext ctx, ByteBuf in, List<Object> out) throws Exception {
        if (in.readableBytes() == 0) {
            return;
        }
        this.buffer.setBuffer(in);
        int compressionLength = this.buffer.readVarInt();
        if (compressionLength == 0) {
            out.add(this.buffer.readBytes(this.buffer.readableBytes()));
            return;
        }
        if (compressionLength < this.threshold) {
            throw new DecoderException("Invalid compression threshold, size " + compressionLength + " is below " + this.threshold);
        }
        if (compressionLength > 0x200000) {
            throw new DecoderException("Invalid compression threshold, size " + compressionLength + " is over the limit of 2097152");
        }
        byte[] toDecompress = new byte[in.readableBytes()];
        this.buffer.readBytes(toDecompress);
        this.inflater.setInput(toDecompress);
        byte[] output = new byte[compressionLength];
        this.inflater.inflate(output);
        this.inflater.reset();
        out.add(Unpooled.wrappedBuffer((byte[])output));
    }
}

