/*
 * Decompiled with CFR 0.152.
 */
package com.wynntils.hades.protocol.packets.server;

import com.wynntils.hades.protocol.interfaces.HadesPacket;
import com.wynntils.hades.protocol.interfaces.adapters.IHadesClientAdapter;
import com.wynntils.hades.utils.HadesBuffer;
import java.util.UUID;

public class HSPacketUpdateMutual
implements HadesPacket<IHadesClientAdapter> {
    UUID user;
    String name;
    float x;
    float y;
    float z;
    int health;
    int mana;
    int maxHealth;
    int maxMana;
    boolean isPartyMember;
    boolean isMutualFriend;
    boolean isGuildMember;
    String helmet;
    String chestplate;
    String leggings;
    String boots;
    String ringOne;
    String ringTwo;
    String bracelet;
    String necklace;
    String heldItem;

    public HSPacketUpdateMutual() {
    }

    public HSPacketUpdateMutual(UUID user, String name, float x, float y, float z, int health, int maxHealth, int mana, int maxMana, boolean isPartyMember, boolean isMutualFriend, boolean isGuildMember) {
        this.user = user;
        this.name = name;
        this.x = x;
        this.y = y;
        this.z = z;
        this.health = health;
        this.maxHealth = maxHealth;
        this.mana = mana;
        this.maxMana = maxMana;
        this.isPartyMember = isPartyMember;
        this.isMutualFriend = isMutualFriend;
        this.isGuildMember = isGuildMember;
        this.helmet = "";
        this.chestplate = "";
        this.leggings = "";
        this.boots = "";
        this.ringOne = "";
        this.ringTwo = "";
        this.bracelet = "";
        this.necklace = "";
        this.heldItem = "";
    }

    public HSPacketUpdateMutual(UUID user, String name, float x, float y, float z, int health, int maxHealth, int mana, int maxMana, boolean isPartyMember, boolean isMutualFriend, boolean isGuildMember, String helmet, String chestplate, String leggings, String boots, String ringOne, String ringTwo, String bracelet, String necklace, String heldItem) {
        this.user = user;
        this.name = name;
        this.x = x;
        this.y = y;
        this.z = z;
        this.health = health;
        this.maxHealth = maxHealth;
        this.mana = mana;
        this.maxMana = maxMana;
        this.isPartyMember = isPartyMember;
        this.isMutualFriend = isMutualFriend;
        this.isGuildMember = isGuildMember;
        this.helmet = helmet;
        this.chestplate = chestplate;
        this.leggings = leggings;
        this.boots = boots;
        this.ringOne = ringOne;
        this.ringTwo = ringTwo;
        this.bracelet = bracelet;
        this.necklace = necklace;
        this.heldItem = heldItem;
    }

    public UUID getUser() {
        return this.user;
    }

    public String getName() {
        return this.name;
    }

    public float getX() {
        return this.x;
    }

    public float getY() {
        return this.y;
    }

    public float getZ() {
        return this.z;
    }

    public int getHealth() {
        return this.health;
    }

    public int getMaxHealth() {
        return this.maxHealth;
    }

    public int getMana() {
        return this.mana;
    }

    public int getMaxMana() {
        return this.maxMana;
    }

    public boolean isPartyMember() {
        return this.isPartyMember;
    }

    public boolean isMutualFriend() {
        return this.isMutualFriend;
    }

    public boolean isGuildMember() {
        return this.isGuildMember;
    }

    public String getHelmet() {
        return this.helmet;
    }

    public String getChestplate() {
        return this.chestplate;
    }

    public String getLeggings() {
        return this.leggings;
    }

    public String getBoots() {
        return this.boots;
    }

    public String getRingOne() {
        return this.ringOne;
    }

    public String getRingTwo() {
        return this.ringTwo;
    }

    public String getBracelet() {
        return this.bracelet;
    }

    public String getNecklace() {
        return this.necklace;
    }

    public String getHeldItem() {
        return this.heldItem;
    }

    @Override
    public void readData(HadesBuffer buffer) {
        this.user = buffer.readUUID();
        this.name = buffer.readString();
        this.x = buffer.readFloat();
        this.y = buffer.readFloat();
        this.z = buffer.readFloat();
        this.health = buffer.readInt();
        this.maxHealth = buffer.readInt();
        this.mana = buffer.readInt();
        this.maxMana = buffer.readInt();
        this.isPartyMember = buffer.readBoolean();
        this.isMutualFriend = buffer.readBoolean();
        this.isGuildMember = buffer.readBoolean();
        if (buffer.readableBytes() > 0) {
            this.helmet = buffer.readString();
            this.chestplate = buffer.readString();
            this.leggings = buffer.readString();
            this.boots = buffer.readString();
            this.ringOne = buffer.readString();
            this.ringTwo = buffer.readString();
            this.bracelet = buffer.readString();
            this.necklace = buffer.readString();
            this.heldItem = buffer.readString();
        } else {
            this.helmet = "";
            this.chestplate = "";
            this.leggings = "";
            this.boots = "";
            this.ringOne = "";
            this.ringTwo = "";
            this.bracelet = "";
            this.necklace = "";
            this.heldItem = "";
        }
    }

    @Override
    public void writeData(HadesBuffer buffer) {
        buffer.writeUUID(this.user);
        buffer.writeString(this.name);
        buffer.writeFloat(this.x);
        buffer.writeFloat(this.y);
        buffer.writeFloat(this.z);
        buffer.writeInt(this.health);
        buffer.writeInt(this.maxHealth);
        buffer.writeInt(this.mana);
        buffer.writeInt(this.maxMana);
        buffer.writeBoolean(this.isPartyMember);
        buffer.writeBoolean(this.isMutualFriend);
        buffer.writeBoolean(this.isGuildMember);
        if (this.helmet.isEmpty() && this.chestplate.isEmpty() && this.leggings.isEmpty() && this.boots.isEmpty() && this.ringOne.isEmpty() && this.ringTwo.isEmpty() && this.bracelet.isEmpty() && this.necklace.isEmpty() && this.heldItem.isEmpty()) {
            return;
        }
        buffer.writeString(this.helmet);
        buffer.writeString(this.chestplate);
        buffer.writeString(this.leggings);
        buffer.writeString(this.boots);
        buffer.writeString(this.ringOne);
        buffer.writeString(this.ringTwo);
        buffer.writeString(this.bracelet);
        buffer.writeString(this.necklace);
        buffer.writeString(this.heldItem);
    }

    @Override
    public void process(IHadesClientAdapter handler) {
        handler.handleUpdateMutual(this);
    }
}

