/*
 * Decompiled with CFR 0.152.
 */
package com.wynntils.handlers.chat;

import com.wynntils.core.WynntilsMod;
import com.wynntils.core.components.Handlers;
import com.wynntils.core.components.Services;
import com.wynntils.core.text.StyledText;
import com.wynntils.mc.event.SystemMessageEvent;
import com.wynntils.utils.ListUtils;
import com.wynntils.utils.TaskUtils;
import com.wynntils.utils.mc.StyledTextUtils;
import com.wynntils.utils.type.Pair;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Deque;
import java.util.LinkedList;
import java.util.List;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.stream.Stream;
import net.minecraft.class_2561;
import net.minecraft.class_303;
import net.minecraft.class_5250;

public final class ChatPageDetector {
    private static final int PAGE_BACKGROUND_MESSAGES = 4;
    private static final int MIN_MATCHING_LINES = 5;
    private static final int MAX_DIFFERING_LINES = 5;
    private static final int NORMAL_PAGE_WAIT = 20;
    private static final int PARTIAL_PAGE_WAIT = 60;
    private int lastPartialLinesCount = 0;
    private Future<?> pageFinishedTask = null;
    private Deque<class_2561> collectedMessages = new ArrayDeque<class_2561>();
    private List<Runnable> tasksAtNextTick = new ArrayList<Runnable>();
    private List<StyledText> pageBackground = null;
    private List<StyledText> pageContent = List.of();
    private List<StyledText> sentBackgroundLines = new ArrayList<StyledText>();
    private List<StyledText> lastForegroundLines = null;

    public boolean isInPageMode() {
        return this.pageBackground != null;
    }

    public List<StyledText> getPageContent() {
        return this.pageContent;
    }

    public void reset() {
        this.collectedMessages = new ArrayDeque<class_2561>();
        this.pageBackground = null;
        this.pageContent = List.of();
        this.sentBackgroundLines = new ArrayList<StyledText>();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void onTick() {
        ArrayList<Runnable> tasksToRun;
        ChatPageDetector chatPageDetector = this;
        synchronized (chatPageDetector) {
            tasksToRun = new ArrayList<Runnable>(this.tasksAtNextTick);
            this.tasksAtNextTick.clear();
        }
        tasksToRun.forEach(Runnable::run);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean processIncomingChatMessage(SystemMessageEvent.ChatReceivedEvent event) {
        class_2561 message = event.getMessage();
        StyledText styledText = StyledText.fromComponent(message);
        int lineCount = StyledTextUtils.getLineCount(styledText);
        ChatPageDetector chatPageDetector = this;
        synchronized (chatPageDetector) {
            if (this.pageFinishedTask == null) {
                if (lineCount == 1) {
                    if (!this.pageContent.isEmpty() && !Handlers.Chat.isLocalMessage()) {
                        this.reset();
                        Handlers.Chat.handlePage(List.of());
                    }
                    return false;
                }
                this.pageFinishedTask = TaskUtils.schedule(this::onPotentialPageFinished, 20, TimeUnit.MILLISECONDS);
            }
            this.collectedMessages.addLast(message);
        }
        event.setCanceled(true);
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void onPotentialPageFinished() {
        Deque<class_2561> pageMessages;
        ChatPageDetector chatPageDetector = this;
        synchronized (chatPageDetector) {
            if (this.isPartialPage(this.collectedMessages) && this.collectedMessages.size() != this.lastPartialLinesCount) {
                this.lastPartialLinesCount = this.collectedMessages.size();
                this.pageFinishedTask = TaskUtils.schedule(this::onPotentialPageFinished, 60, TimeUnit.MILLISECONDS);
                return;
            }
            this.lastPartialLinesCount = 0;
            pageMessages = this.collectedMessages;
            this.collectedMessages = new ArrayDeque<class_2561>();
            this.pageFinishedTask = null;
        }
        if (!this.isPage(pageMessages)) {
            for (class_2561 message : pageMessages) {
                this.enqueueSendDelayedChat(message);
            }
        } else {
            this.splitMultiplePages(pageMessages).forEach(this::handlePage);
        }
    }

    private boolean isPartialPage(Deque<class_2561> collectedMessages) {
        if (collectedMessages.size() >= 4) {
            return false;
        }
        if (this.pageBackground == null) {
            return false;
        }
        ArrayList<StyledText> partialPage = new ArrayList<StyledText>();
        for (class_2561 message : collectedMessages) {
            StyledText styledText = StyledText.fromComponent(message);
            List<StyledText> lines = List.of(styledText.split("\n", true));
            if (lines.size() == 1) {
                return false;
            }
            partialPage.addAll(lines);
        }
        int matchingLines = ListUtils.countMatchingElements(this.pageBackground, 0, partialPage, 0);
        return matchingLines == partialPage.size();
    }

    private boolean isPage(Deque<class_2561> collectedMessages) {
        if (collectedMessages.size() < 4) {
            return false;
        }
        for (class_2561 message : collectedMessages) {
            StyledText styledText = StyledText.fromComponent(message);
            if (StyledTextUtils.getLineCount(styledText) != 1) continue;
            return false;
        }
        return true;
    }

    public List<Deque<class_2561>> splitMultiplePages(Deque<class_2561> collectedMessages) {
        if (collectedMessages.size() < 4) {
            return List.of(new ArrayDeque<class_2561>(collectedMessages));
        }
        int lastPageStart = 0;
        ArrayList<class_2561> messages = new ArrayList<class_2561>(collectedMessages);
        ArrayList<Deque<class_2561>> separatedPages = new ArrayList<Deque<class_2561>>();
        int i = 0;
        while (i < messages.size()) {
            ArrayDeque<class_2561> page = new ArrayDeque<class_2561>(messages.subList(i, i + 4));
            i += 4;
            while (i < messages.size()) {
                if (this.isPageStart(messages, lastPageStart, i)) {
                    lastPageStart = i;
                    break;
                }
                page.add((class_2561)messages.get(i));
                ++i;
            }
            separatedPages.add(page);
        }
        return separatedPages;
    }

    private boolean isPageStart(List<class_2561> messageList, int oldPageIndex, int startIndex) {
        if (startIndex > messageList.size() - 4) {
            return false;
        }
        if (ListUtils.countMatchingElements(messageList, oldPageIndex, messageList, startIndex) >= 4) {
            return true;
        }
        List referenceLines = messageList.subList(oldPageIndex, oldPageIndex + 4).stream().flatMap(this::splitIntoLines).toList();
        List compareLines = messageList.subList(startIndex, startIndex + 4).stream().flatMap(this::splitIntoLines).toList();
        int numReferenceLines = referenceLines.size();
        int minRequiredMatches = numReferenceLines - 10;
        block0: for (int refStart = 0; refStart <= 5; ++refStart) {
            for (int i = 0; i < numReferenceLines - refStart; ++i) {
                if (i >= minRequiredMatches) {
                    return true;
                }
                if (i >= compareLines.size() || !((StyledText)referenceLines.get(refStart + i)).getStringWithoutFormatting().equals(((StyledText)compareLines.get(i)).getStringWithoutFormatting())) continue block0;
            }
        }
        return false;
    }

    private void handlePage(Deque<class_2561> collectedMessages) {
        Pair<List<StyledText>, List<StyledText>> page = this.splitPage(collectedMessages);
        List<StyledText> background = page.a();
        List<StyledText> pageContent = page.b();
        this.handleBackground(background, collectedMessages.size());
        this.enqueueSendPageContent(pageContent);
    }

    private Pair<List<StyledText>, List<StyledText>> splitPage(Deque<class_2561> collectedMessages) {
        List background = collectedMessages.stream().limit(4L).flatMap(this::splitIntoLines).toList();
        List pageContent = collectedMessages.stream().skip(4L).flatMap(this::splitIntoLines).toList();
        return Pair.of(background, pageContent);
    }

    private Stream<StyledText> splitIntoLines(class_2561 message) {
        StyledText styledText = StyledText.fromComponent(message);
        List<StyledText> lines = List.of(styledText.split("\n", true));
        return lines.stream();
    }

    private void handleBackground(List<StyledText> background, int numCollectedMessages) {
        int matchingLines;
        if (this.lastForegroundLines != null && (matchingLines = ListUtils.countMatchingElements(this.lastForegroundLines, 0, background, 0)) == background.size()) {
            return;
        }
        this.lastForegroundLines = null;
        List<StyledText> oldBackground = this.pageBackground;
        this.pageBackground = background;
        if (oldBackground == null) {
            return;
        }
        List<StyledText> newBackgroundMessages = this.getMessageDiff(oldBackground, background);
        if (newBackgroundMessages != null) {
            for (StyledText message : newBackgroundMessages) {
                this.sentBackgroundLines.add(message);
                this.enqueueSendBackgroundLine(message);
            }
        } else if (numCollectedMessages == 4) {
            List<StyledText> sentLines = List.copyOf(this.sentBackgroundLines);
            this.pageBackground = null;
            this.pageContent = List.of();
            this.sentBackgroundLines.clear();
            this.lastForegroundLines = background;
            this.enqueueSendForegroundReplacements(background, oldBackground, sentLines);
        } else {
            WynntilsMod.error("Could not calculate updated background messages");
            for (StyledText message : background) {
                this.sentBackgroundLines.add(message);
                this.enqueueSendBackgroundLine(message);
            }
            this.reset();
            Handlers.Chat.handlePage(List.of());
        }
    }

    private List<StyledText> getMessageDiff(List<StyledText> oldBackground, List<StyledText> newBackground) {
        if (newBackground.isEmpty()) {
            return List.of();
        }
        if (oldBackground.isEmpty()) {
            return newBackground;
        }
        int oldSize = oldBackground.size();
        int newSize = newBackground.size();
        List<StyledText> strippedOldBackground = StyledTextUtils.stripEventsAndLinks(oldBackground);
        List<StyledText> strippedNewBackground = StyledTextUtils.stripEventsAndLinks(newBackground);
        for (int pos = 0; pos < oldSize; ++pos) {
            int remainingOld;
            int matchCount = ListUtils.countMatchingElements(strippedOldBackground, pos, strippedNewBackground, 0);
            if (matchCount != (remainingOld = oldSize - pos) || matchCount < 5) continue;
            if (newSize > remainingOld) {
                return newBackground.subList(remainingOld, newSize);
            }
            return List.of();
        }
        return null;
    }

    private List<Pair<StyledText, StyledText>> calculateForegroundReplacements(List<StyledText> lastBackground, List<StyledText> foreground, List<StyledText> sentBackgroundLines) {
        LinkedList<Pair<StyledText, StyledText>> replacements = new LinkedList<Pair<StyledText, StyledText>>();
        int lastBackgroundStartPos = lastBackground.size() - sentBackgroundLines.size();
        if (lastBackground.size() != foreground.size()) {
            WynntilsMod.warn("Page size mismatch in foreground replacements, skipping");
            return List.of();
        }
        for (int i = 0; i < sentBackgroundLines.size(); ++i) {
            if (!lastBackground.get(lastBackgroundStartPos + i).getString().equals(sentBackgroundLines.get(i).getString())) {
                WynntilsMod.warn("Line mismatch in foreground replacements, skipping line: " + String.valueOf(sentBackgroundLines.get(i)));
                continue;
            }
            replacements.addFirst(Pair.of(sentBackgroundLines.get(i), foreground.get(lastBackgroundStartPos + i)));
        }
        return replacements;
    }

    private static void processChatComponentReplacements(List<class_303> allMessages, List<Pair<StyledText, StyledText>> replacements) {
        LinkedList<Pair<StyledText, StyledText>> remainingReplacements = new LinkedList<Pair<StyledText, StyledText>>(replacements);
        block0: for (int i = 0; i < allMessages.size() && !remainingReplacements.isEmpty(); ++i) {
            class_303 guiMessage = allMessages.get(i);
            class_2561 content = guiMessage.comp_893();
            StyledText styledText = StyledText.fromComponent(content);
            for (int j = 0; j < remainingReplacements.size(); ++j) {
                Pair replacement = (Pair)remainingReplacements.get(j);
                if (!styledText.getString().equals(((StyledText)replacement.a()).getString())) continue;
                class_5250 newContent = ((StyledText)replacement.b()).getComponent();
                class_303 newMessage = new class_303(guiMessage.comp_892(), (class_2561)newContent, guiMessage.comp_915(), guiMessage.comp_894());
                allMessages.set(i, newMessage);
                for (int k = 0; k <= j; ++k) {
                    remainingReplacements.removeFirst();
                }
                continue block0;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void enqueueSendDelayedChat(class_2561 message) {
        ChatPageDetector chatPageDetector = this;
        synchronized (chatPageDetector) {
            this.tasksAtNextTick.add(new SendDelayedChatTask(message));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void enqueueSendBackgroundLine(StyledText message) {
        ChatPageDetector chatPageDetector = this;
        synchronized (chatPageDetector) {
            this.tasksAtNextTick.add(new SendBackgroundLineTask(message));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void enqueueSendForegroundReplacements(List<StyledText> background, List<StyledText> oldBackground, List<StyledText> sentLines) {
        List<Pair<StyledText, StyledText>> replacements = this.calculateForegroundReplacements(oldBackground, background, sentLines);
        ChatPageDetector chatPageDetector = this;
        synchronized (chatPageDetector) {
            this.tasksAtNextTick.add(new SendForegroundReplacementsTask(replacements));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void enqueueSendPageContent(List<StyledText> pageContent) {
        this.pageContent = pageContent;
        ChatPageDetector chatPageDetector = this;
        synchronized (chatPageDetector) {
            this.tasksAtNextTick.add(new SendPageContentTask(pageContent));
        }
    }

    private static final class SendDelayedChatTask
    implements Runnable {
        private final class_2561 message;

        private SendDelayedChatTask(class_2561 message) {
            this.message = message;
        }

        @Override
        public void run() {
            Handlers.Chat.sendDelayedChat(this.message);
        }
    }

    private static final class SendBackgroundLineTask
    implements Runnable {
        private final StyledText message;

        private SendBackgroundLineTask(StyledText message) {
            this.message = message;
        }

        @Override
        public void run() {
            Handlers.Chat.handleBackgroundLine(this.message);
        }
    }

    private static final class SendForegroundReplacementsTask
    implements Runnable {
        private List<Pair<StyledText, StyledText>> replacements;

        private SendForegroundReplacementsTask(List<Pair<StyledText, StyledText>> replacements) {
            this.replacements = replacements;
        }

        @Override
        public void run() {
            Services.ChatTab.modifyChatHistory(allMessages -> ChatPageDetector.processChatComponentReplacements(allMessages, this.replacements));
        }
    }

    private static final class SendPageContentTask
    implements Runnable {
        private final List<StyledText> pageContent;

        private SendPageContentTask(List<StyledText> pageContent) {
            this.pageContent = pageContent;
        }

        @Override
        public void run() {
            Handlers.Chat.handlePage(this.pageContent);
        }
    }
}

