/*
 * Decompiled with CFR 0.152.
 */
package com.wynntils.handlers.scoreboard;

import com.google.common.collect.ImmutableList;
import com.wynntils.core.WynntilsMod;
import com.wynntils.core.components.Handler;
import com.wynntils.core.text.StyledText;
import com.wynntils.core.text.type.StyleType;
import com.wynntils.handlers.scoreboard.ScoreboardPart;
import com.wynntils.handlers.scoreboard.ScoreboardSegment;
import com.wynntils.handlers.scoreboard.event.ScoreboardSegmentAdditionEvent;
import com.wynntils.handlers.scoreboard.type.ScoreboardLine;
import com.wynntils.handlers.scoreboard.type.SegmentMatcher;
import com.wynntils.mc.event.ScoreboardEvent;
import com.wynntils.mc.event.ScoreboardSetDisplayObjectiveEvent;
import com.wynntils.mc.event.ScoreboardSetObjectiveEvent;
import com.wynntils.models.worlds.event.WorldStateEvent;
import com.wynntils.models.worlds.type.WorldState;
import com.wynntils.utils.mc.McUtils;
import com.wynntils.utils.type.Pair;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import java.util.Optional;
import java.util.regex.Pattern;
import net.minecraft.class_124;
import net.minecraft.class_2561;
import net.minecraft.class_266;
import net.minecraft.class_267;
import net.minecraft.class_269;
import net.minecraft.class_274;
import net.minecraft.class_5250;
import net.minecraft.class_8646;
import net.minecraft.class_9012;
import net.minecraft.class_9015;
import net.minecraft.class_9020;
import net.minecraft.class_9022;
import net.neoforged.bus.api.EventPriority;
import net.neoforged.bus.api.SubscribeEvent;
import org.apache.commons.lang3.StringUtils;

public final class ScoreboardHandler
extends Handler {
    private static final Pattern NEXT_LINE_PATTERN = Pattern.compile("\u00c0+");
    private static final String SCOREBOARD_KEY = "wynntilsSB";
    private static final class_5250 SCOREBOARD_TITLE_COMPONENT = class_2561.method_43470((String)"play.wynncraft.com").method_27692(class_124.field_1067).method_27692(class_124.field_1065);
    private static final int MAX_SCOREBOARD_LINE = 16;
    private static final ScoreboardPart FALLBACK_SCOREBOARD_PART = new FallbackScoreboardPart();
    private String currentScoreboardName = "";
    private List<Pair<ScoreboardPart, ScoreboardSegment>> scoreboardSegments = new ArrayList<Pair<ScoreboardPart, ScoreboardSegment>>();
    private final List<ScoreboardPart> scoreboardParts = new ArrayList<ScoreboardPart>();

    public void addPart(ScoreboardPart scoreboardPart) {
        this.scoreboardParts.add(scoreboardPart);
    }

    private boolean isValidScoreboardName(String scoreboardName) {
        String name = McUtils.player().method_5820();
        name = name.length() > 14 ? name.substring(0, 14) : name;
        return (scoreboardName.startsWith("sb") || scoreboardName.startsWith("bf")) && scoreboardName.endsWith(name);
    }

    @SubscribeEvent(priority=EventPriority.HIGHEST)
    public void onSetScore(ScoreboardEvent.Set event) {
        if (!this.currentScoreboardName.equals(event.getObjectiveName())) {
            return;
        }
        this.handleUpdate();
    }

    @SubscribeEvent(priority=EventPriority.HIGHEST)
    public void onSetScore(ScoreboardEvent.Reset event) {
        if (!this.currentScoreboardName.equals(event.getObjectiveName())) {
            return;
        }
        this.handleUpdate();
    }

    @SubscribeEvent(priority=EventPriority.HIGHEST)
    public void onSetObjective(ScoreboardSetObjectiveEvent event) {
        if (!this.currentScoreboardName.equals(event.getObjectiveName())) {
            return;
        }
        this.handleUpdate();
    }

    @SubscribeEvent(priority=EventPriority.HIGHEST)
    public void onSetObjectiveDisplay(ScoreboardSetDisplayObjectiveEvent event) {
        if (!this.isValidScoreboardName(event.getObjectiveName())) {
            return;
        }
        this.currentScoreboardName = event.getObjectiveName();
        this.handleUpdate();
        event.setCanceled(true);
    }

    @SubscribeEvent
    public void onWorldStateChange(WorldStateEvent event) {
        if (event.getNewState() == WorldState.WORLD) {
            return;
        }
        this.scoreboardSegments.forEach(pair -> ((ScoreboardPart)pair.key()).reset());
        this.scoreboardSegments = new ArrayList<Pair<ScoreboardPart, ScoreboardSegment>>();
        this.currentScoreboardName = "";
    }

    private void handleUpdate() {
        List<ScoreboardLine> reconstructedScoreboard = this.getCurrentScoreboardState(this.currentScoreboardName);
        List<ScoreboardPart> validParts = this.getValidScoreboardParts(reconstructedScoreboard);
        this.calculateScoreboardSegments(reconstructedScoreboard, validParts);
        this.createScoreboardFromSegments();
    }

    private List<ScoreboardLine> getCurrentScoreboardState(String currentScoreboardName) {
        class_269 scoreboard = McUtils.mc().field_1687.method_8428();
        class_266 currentObjective = scoreboard.method_1170(currentScoreboardName);
        if (currentObjective == null) {
            WynntilsMod.warn("Could not find the current scoreboard objective: " + currentScoreboardName);
            return List.of();
        }
        return scoreboard.field_1431.entrySet().stream().map(entry -> Pair.of((String)entry.getKey(), ((class_9012)entry.getValue()).method_55389(currentObjective))).filter(pair -> pair.value() != null).map(entry -> new ScoreboardLine(StyledText.fromString((String)entry.key()), ((class_267)entry.value()).method_55397())).sorted(Comparator.comparing(ScoreboardLine::score).reversed()).toList();
    }

    /*
     * WARNING - void declaration
     */
    private List<ScoreboardPart> getValidScoreboardParts(List<ScoreboardLine> reconstructedScoreboard) {
        void var4_8;
        if (reconstructedScoreboard.isEmpty()) {
            return List.of();
        }
        ArrayList<StyledText> lines = new ArrayList<StyledText>();
        for (ScoreboardLine scoreboardLine : reconstructedScoreboard) {
            if (lines.contains(scoreboardLine.line())) {
                return List.of();
            }
            lines.add(scoreboardLine.line());
        }
        int lastScore = reconstructedScoreboard.stream().map(ScoreboardLine::score).findFirst().orElse(0);
        for (ScoreboardLine line : reconstructedScoreboard.stream().skip(1L).toList()) {
            if (line.score() >= lastScore) {
                return List.of();
            }
            lastScore = line.score();
        }
        if (!reconstructedScoreboard.stream().findFirst().map(ScoreboardLine::line).orElse(StyledText.EMPTY).equals(StyledText.fromString("\u00c0"))) {
            return List.of();
        }
        boolean bl = true;
        List scoreboardLines = reconstructedScoreboard.stream().toList();
        ArrayList<ScoreboardPart> scoreboardParts = new ArrayList<ScoreboardPart>();
        block2: while (var4_8 < scoreboardLines.size()) {
            ScoreboardPart part = this.getScoreboardPartForHeader((ScoreboardLine)scoreboardLines.get((int)var4_8));
            if (part == null) {
                return scoreboardParts;
            }
            if (part != FALLBACK_SCOREBOARD_PART && scoreboardParts.contains(part)) {
                return List.of();
            }
            if (var4_8 + true == scoreboardLines.size()) {
                return scoreboardParts;
            }
            if (((ScoreboardLine)scoreboardLines.get((int)(var4_8 + true))).line().getMatcher(NEXT_LINE_PATTERN).matches()) {
                return List.of();
            }
            scoreboardParts.add(part);
            ++var4_8;
            while (var4_8 < scoreboardLines.size()) {
                ScoreboardLine line = (ScoreboardLine)scoreboardLines.get((int)var4_8);
                if (line.line().getMatcher(NEXT_LINE_PATTERN).matches()) {
                    ++var4_8;
                    continue block2;
                }
                ++var4_8;
            }
        }
        return scoreboardParts;
    }

    private void calculateScoreboardSegments(List<ScoreboardLine> reconstructedScoreboard, List<ScoreboardPart> validParts) {
        int currentIndex = 1;
        List scoreboardLines = reconstructedScoreboard.stream().toList();
        ImmutableList oldSegments = ImmutableList.copyOf(this.scoreboardSegments);
        this.scoreboardSegments = new ArrayList<Pair<ScoreboardPart, ScoreboardSegment>>();
        int validPartIndex = 0;
        while (currentIndex < scoreboardLines.size() && validPartIndex < validParts.size()) {
            boolean eventCanceled;
            ScoreboardSegment segment;
            ScoreboardLine headerLine = (ScoreboardLine)scoreboardLines.get(currentIndex);
            ScoreboardPart scoreboardPart = this.getScoreboardPartForHeader(headerLine);
            if (scoreboardPart == null) {
                WynntilsMod.error("Scoreboard passed validness check, but we could not find a scoreboard part for the line: " + String.valueOf(((ScoreboardLine)scoreboardLines.get(currentIndex)).line()));
                return;
            }
            if (scoreboardPart != validParts.get(validPartIndex)) {
                WynntilsMod.error("Scoreboard passed validness check, but the scoreboard part for the line: " + String.valueOf(((ScoreboardLine)scoreboardLines.get(currentIndex)).line()) + " does not match the valid part: " + String.valueOf(validParts.get(validPartIndex)));
                return;
            }
            ++validPartIndex;
            ArrayList<StyledText> contentLines = new ArrayList<StyledText>();
            ++currentIndex;
            while (currentIndex < scoreboardLines.size()) {
                ScoreboardLine line = (ScoreboardLine)scoreboardLines.get(currentIndex);
                if (line.line().getMatcher(NEXT_LINE_PATTERN).matches()) {
                    ++currentIndex;
                    break;
                }
                contentLines.add(line.line());
                ++currentIndex;
            }
            segment.setVisibility(!(eventCanceled = WynntilsMod.postEvent(new ScoreboardSegmentAdditionEvent(segment = new ScoreboardSegment(scoreboardPart, headerLine.line(), contentLines)))));
            this.scoreboardSegments.add(new Pair<ScoreboardPart, ScoreboardSegment>(scoreboardPart, segment));
        }
        for (Pair pair2 : oldSegments) {
            Optional<Pair> segmentOpt;
            if (pair2.key() == FALLBACK_SCOREBOARD_PART || !(segmentOpt = this.scoreboardSegments.stream().filter(pair -> pair.key() == oldPair2.key()).findFirst()).isEmpty()) continue;
            ((ScoreboardPart)pair2.key()).onSegmentRemove((ScoreboardSegment)pair2.value());
        }
        for (Pair pair3 : this.scoreboardSegments) {
            Optional<Pair> oldSegmentOpt;
            if (pair3.key() == FALLBACK_SCOREBOARD_PART || !(oldSegmentOpt = oldSegments.stream().filter(oldPair -> oldPair.key() == pair2.key()).findFirst()).isEmpty() && ((ScoreboardSegment)oldSegmentOpt.get().value()).equals(pair3.value())) continue;
            ((ScoreboardPart)pair3.key()).onSegmentChange((ScoreboardSegment)pair3.value());
        }
    }

    private void createScoreboardFromSegments() {
        class_269 scoreboard = McUtils.player().method_7327();
        class_266 oldObjective = scoreboard.method_1170(SCOREBOARD_KEY);
        if (oldObjective != null) {
            scoreboard.method_1194(oldObjective);
        }
        class_266 wynntilsObjective = scoreboard.method_1168(SCOREBOARD_KEY, class_274.field_1468, (class_2561)SCOREBOARD_TITLE_COMPONENT, class_274.class_275.field_1472, true, (class_9022)class_9020.field_47557);
        if (this.scoreboardSegments.stream().map(Pair::value).noneMatch(ScoreboardSegment::isVisible)) {
            return;
        }
        scoreboard.method_1158(class_8646.field_45157, wynntilsObjective);
        int currentScoreboardLine = 16;
        scoreboard.method_1180(class_9015.method_55422((String)"\u00c0"), wynntilsObjective).method_55410(currentScoreboardLine);
        --currentScoreboardLine;
        int separatorCount = 2;
        List<ScoreboardSegment> segments = this.scoreboardSegments.stream().map(Pair::value).toList();
        for (int i = 0; i < segments.size(); ++i) {
            ScoreboardSegment scoreboardSegment = segments.get(i);
            if (!scoreboardSegment.isVisible()) continue;
            scoreboard.method_1180(class_9015.method_55422((String)scoreboardSegment.getHeader().getString()), wynntilsObjective).method_55410(currentScoreboardLine);
            --currentScoreboardLine;
            for (StyledText line : scoreboardSegment.getContent()) {
                scoreboard.method_1180(class_9015.method_55422((String)line.getString()), wynntilsObjective).method_55410(currentScoreboardLine);
                --currentScoreboardLine;
            }
            if (i == segments.size() - 1) continue;
            scoreboard.method_1180(class_9015.method_55422((String)StringUtils.repeat((char)'\u00c0', (int)separatorCount)), wynntilsObjective).method_55410(currentScoreboardLine);
            --currentScoreboardLine;
            ++separatorCount;
        }
    }

    private ScoreboardPart getScoreboardPartForHeader(ScoreboardLine scoreboardLine) {
        String unformattedLine = scoreboardLine.line().getString(StyleType.NONE);
        for (ScoreboardPart part : this.scoreboardParts) {
            if (!part.getSegmentMatcher().headerPattern().matcher(unformattedLine).matches()) continue;
            return part;
        }
        return FALLBACK_SCOREBOARD_PART;
    }

    private static final class FallbackScoreboardPart
    extends ScoreboardPart {
        private static final SegmentMatcher FALLBACK_MATCHER = SegmentMatcher.fromPattern(".*");

        private FallbackScoreboardPart() {
        }

        @Override
        public SegmentMatcher getSegmentMatcher() {
            return FALLBACK_MATCHER;
        }

        @Override
        public void onSegmentChange(ScoreboardSegment newValue) {
        }

        @Override
        public void onSegmentRemove(ScoreboardSegment segment) {
        }

        @Override
        public void reset() {
        }

        @Override
        public String toString() {
            return "FallbackScoreboardPart{}";
        }
    }
}

