/*
 * Decompiled with CFR 0.152.
 */
package com.wynntils.models.abilities.bossbars;

import com.wynntils.core.WynntilsMod;
import com.wynntils.handlers.bossbar.TrackedBar;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class CommanderBar
extends TrackedBar {
    private static final Pattern COMMANDER_PATTERN = Pattern.compile("\u00a7(c|a)Commander: ([0-9]+)s");
    private int duration = 0;
    private boolean activated = false;

    public CommanderBar() {
        super(COMMANDER_PATTERN);
    }

    public int getDuration() {
        return this.duration;
    }

    public boolean isActivated() {
        return this.activated;
    }

    @Override
    public void onUpdateName(Matcher match) {
        try {
            this.activated = match.group(1).equals("a");
            this.duration = Integer.parseInt(match.group(2));
        }
        catch (NumberFormatException e) {
            WynntilsMod.error(String.format("Failed to parse active state and duration for commander bar (%b, %ds)", this.activated, this.duration));
        }
    }
}

