/*
 * Decompiled with CFR 0.152.
 */
package com.wynntils.models.abilitytree.parser;

import com.wynntils.core.text.StyledText;
import com.wynntils.core.text.type.StyleType;
import com.wynntils.models.abilitytree.type.AbilityTreeLocation;
import com.wynntils.models.abilitytree.type.AbilityTreeNodeState;
import com.wynntils.models.abilitytree.type.AbilityTreeSkillNode;
import com.wynntils.models.abilitytree.type.ArchetypeRequirement;
import com.wynntils.models.abilitytree.type.ItemInformation;
import com.wynntils.utils.mc.LoreUtils;
import com.wynntils.utils.type.IterationDecision;
import com.wynntils.utils.type.Pair;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1802;

public final class AbilityTreeParser {
    private static final Pattern NODE_NAME_PATTERN = Pattern.compile("\u00a7.(Unlock )?\u00a7l(.+)(\u00a7r\u00a7. ability)?");
    private static final Pattern NODE_POINT_COST_PATTERN = Pattern.compile("\u00a7.. \u00a77Ability Points: \u00a7f(\\d+)");
    private static final Pattern NODE_BLOCKS_ABILITY_PATTERN = Pattern.compile("\u00a7c- \u00a77(.+)");
    private static final Pattern NODE_REQUIRED_ABILITY_PATTERN = Pattern.compile("\u00a7.. \u00a77Required Ability: \u00a7f(.+)");
    private static final Pattern NODE_REQUIRED_ARCHETYPE_PATTERN = Pattern.compile("\u00a7.. \u00a77Min (.+) Archetype: \u00a7.(\\d+)\u00a77/(\\d+)");
    private static final Pattern NODE_ARCHETYPE_PATTERN = Pattern.compile("\u00a7.\u00a7l(.+) Archetype");
    private static final Pattern NODE_BLOCKED_BY = Pattern.compile("\u00a7c\u00a7lBlocked by:");
    private static final Pattern NODE_BLOCKED = Pattern.compile("\u00a7cBlocked by another ability");
    private static final Pattern NODE_REQUIREMENT_NOT_MET = Pattern.compile("\u00a7cYou do not meet the requirements");
    private static final Pattern NODE_UNLOCKED = Pattern.compile("\u00a7eYou already unlocked this ability");
    private static final StyledText CONNECTION_NAME = StyledText.fromString(" ");

    public Pair<AbilityTreeSkillNode, AbilityTreeNodeState> parseNodeFromItem(class_1799 itemStack, int page, int slot, int id) {
        StyledText actualName;
        StyledText nameStyledText = StyledText.fromComponent(itemStack.method_7964());
        AbilityTreeNodeState state = AbilityTreeNodeState.LOCKED;
        if (nameStyledText.getPartCount() == 1) {
            actualName = nameStyledText;
        } else {
            actualName = nameStyledText.iterate((part, changes) -> {
                if (!part.getPartStyle().isBold()) {
                    changes.clear();
                }
                return IterationDecision.CONTINUE;
            });
            state = AbilityTreeNodeState.UNLOCKABLE;
        }
        LinkedList<StyledText> loreStyledText = LoreUtils.getLore(itemStack);
        int cost = 0;
        ArrayList<String> blocks = new ArrayList<String>();
        String requiredAbility = null;
        ArchetypeRequirement requiredArchetype = null;
        String archetype = null;
        List<StyledText> includedLines = new ArrayList<StyledText>(loreStyledText);
        for (StyledText styledText2 : loreStyledText) {
            Matcher matcher = styledText2.getMatcher(NODE_POINT_COST_PATTERN);
            if (matcher.matches()) {
                cost = Integer.parseInt(matcher.group(1));
                includedLines.remove(styledText2);
                continue;
            }
            matcher = styledText2.getMatcher(NODE_BLOCKS_ABILITY_PATTERN);
            if (matcher.matches()) {
                blocks.add(matcher.group(1));
                continue;
            }
            matcher = styledText2.getMatcher(NODE_REQUIRED_ABILITY_PATTERN);
            if (matcher.matches()) {
                requiredAbility = matcher.group(1);
                includedLines.remove(styledText2);
                continue;
            }
            matcher = styledText2.getMatcher(NODE_REQUIRED_ARCHETYPE_PATTERN);
            if (matcher.matches()) {
                requiredArchetype = new ArchetypeRequirement(matcher.group(1), Integer.parseInt(matcher.group(3)));
                includedLines.remove(styledText2);
                continue;
            }
            matcher = styledText2.getMatcher(NODE_ARCHETYPE_PATTERN);
            if (matcher.matches()) {
                archetype = matcher.group(1);
                continue;
            }
            matcher = styledText2.getMatcher(NODE_BLOCKED);
            if (matcher.matches()) {
                state = AbilityTreeNodeState.BLOCKED;
                continue;
            }
            matcher = styledText2.getMatcher(NODE_UNLOCKED);
            if (!matcher.matches()) continue;
            state = AbilityTreeNodeState.UNLOCKED;
        }
        if (state == AbilityTreeNodeState.UNLOCKABLE || state == AbilityTreeNodeState.UNLOCKED) {
            includedLines = includedLines.subList(0, includedLines.size() - 2);
        } else if (state == AbilityTreeNodeState.BLOCKED) {
            ArrayList<StyledText> tempList = new ArrayList<StyledText>();
            for (StyledText text : includedLines) {
                if (text.getMatcher(NODE_BLOCKED_BY).matches()) break;
                tempList.add(text);
            }
            includedLines = tempList.subList(0, tempList.size() - 1);
        } else if (state == AbilityTreeNodeState.LOCKED && includedLines.getLast().getMatcher(NODE_REQUIREMENT_NOT_MET).matches()) {
            includedLines = includedLines.subList(0, includedLines.size() - 2);
        }
        int n = class_1792.method_7880((class_1792)itemStack.method_7909());
        ItemInformation itemInformation = new ItemInformation(n, switch (state) {
            default -> throw new MatchException(null, null);
            case AbilityTreeNodeState.LOCKED -> itemStack.method_7919();
            case AbilityTreeNodeState.UNLOCKABLE -> itemStack.method_7919() - 1;
            case AbilityTreeNodeState.UNLOCKED -> itemStack.method_7919() - 2;
            case AbilityTreeNodeState.BLOCKED -> itemStack.method_7919() - 3;
        });
        while (includedLines.getLast().getString(StyleType.NONE).isBlank()) {
            includedLines.removeLast();
        }
        AbilityTreeSkillNode abilityTreeSkillNode = new AbilityTreeSkillNode(id, actualName.getString(StyleType.NONE), actualName.getString(StyleType.DEFAULT), includedLines.stream().map(styledText -> styledText.getString(StyleType.DEFAULT)).toList(), itemInformation, cost, blocks, requiredAbility, requiredArchetype, archetype, AbilityTreeLocation.fromSlot(slot, page), new ArrayList<Integer>());
        return Pair.of(abilityTreeSkillNode, state);
    }

    public boolean isNodeItem(class_1799 itemStack, int slot) {
        StyledText nameStyledText = StyledText.fromComponent(itemStack.method_7964());
        return itemStack.method_7909() == class_1802.field_8062 && slot < 54 && nameStyledText.getMatcher(NODE_NAME_PATTERN).matches();
    }

    public boolean isConnectionItem(class_1799 itemStack) {
        return itemStack.method_7909() == class_1802.field_8062 && StyledText.fromComponent(itemStack.method_7964()).equals(CONNECTION_NAME);
    }
}

