/*
 * Decompiled with CFR 0.152.
 */
package com.wynntils.models.abilitytree.type;

import com.wynntils.core.WynntilsMod;
import com.wynntils.utils.type.Pair;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_1935;
import net.minecraft.class_9300;
import net.minecraft.class_9334;

public enum AbilityTreeConnectionType {
    VERTICAL(41, Map.of(new boolean[]{true, false, true, false}, 42), new boolean[]{true, false, true, false}, List.of()),
    HORIZONTAL(43, Map.of(new boolean[]{false, true, false, true}, 44), new boolean[]{false, true, false, true}, List.of()),
    DOWN_LEFT_TURN(37, Map.of(new boolean[]{false, true, true, false}, 38), new boolean[]{false, true, true, false}, List.of()),
    DOWN_RIGHT_TURN(39, Map.of(new boolean[]{false, false, true, true}, 40), new boolean[]{false, false, true, true}, List.of()),
    UP_LEFT_TURN(33, Map.of(new boolean[]{true, false, false, true}, 34), new boolean[]{true, false, false, true}, List.of()),
    UP_RIGHT_TURN(35, Map.of(new boolean[]{true, true, false, false}, 36), new boolean[]{true, true, false, false}, List.of()),
    THREE_WAY_UP(13, Map.of(new boolean[]{true, true, false, true}, 14, new boolean[]{true, false, false, true}, 15, new boolean[]{true, true, false, false}, 16, new boolean[]{false, true, false, true}, 17), new boolean[]{true, true, false, true}, List.of(Pair.of(HORIZONTAL, UP_LEFT_TURN), Pair.of(HORIZONTAL, UP_RIGHT_TURN), Pair.of(UP_LEFT_TURN, UP_RIGHT_TURN))),
    THREE_WAY_RIGHT(18, Map.of(new boolean[]{true, true, true, false}, 19, new boolean[]{true, true, false, false}, 20, new boolean[]{false, true, true, false}, 21, new boolean[]{true, false, true, false}, 22), new boolean[]{true, true, true, false}, List.of(Pair.of(VERTICAL, DOWN_RIGHT_TURN), Pair.of(VERTICAL, UP_RIGHT_TURN), Pair.of(DOWN_LEFT_TURN, UP_LEFT_TURN))),
    THREE_WAY_DOWN(23, Map.of(new boolean[]{false, true, true, true}, 24, new boolean[]{false, false, true, true}, 25, new boolean[]{false, true, true, false}, 26, new boolean[]{false, true, false, true}, 27), new boolean[]{false, true, true, true}, List.of(Pair.of(HORIZONTAL, DOWN_LEFT_TURN), Pair.of(HORIZONTAL, DOWN_RIGHT_TURN), Pair.of(DOWN_LEFT_TURN, DOWN_RIGHT_TURN))),
    THREE_WAY_LEFT(28, Map.of(new boolean[]{true, false, true, true}, 29, new boolean[]{true, false, false, true}, 30, new boolean[]{false, false, true, true}, 31, new boolean[]{true, false, true, false}, 32), new boolean[]{true, false, true, true}, List.of(Pair.of(VERTICAL, DOWN_LEFT_TURN), Pair.of(VERTICAL, UP_LEFT_TURN), Pair.of(DOWN_RIGHT_TURN, UP_RIGHT_TURN))),
    FOUR_WAY(1, Map.ofEntries(Map.entry(new boolean[]{true, true, true, true}, 2), Map.entry(new boolean[]{true, true, false, true}, 3), Map.entry(new boolean[]{true, true, true, false}, 4), Map.entry(new boolean[]{false, true, true, true}, 5), Map.entry(new boolean[]{true, false, true, true}, 6), Map.entry(new boolean[]{true, false, false, true}, 7), Map.entry(new boolean[]{true, true, false, false}, 8), Map.entry(new boolean[]{false, true, true, false}, 9), Map.entry(new boolean[]{false, false, true, true}, 10), Map.entry(new boolean[]{true, false, true, false}, 11), Map.entry(new boolean[]{false, true, false, true}, 12)), new boolean[]{true, true, true, true}, List.of(Pair.of(VERTICAL, HORIZONTAL), Pair.of(DOWN_LEFT_TURN, UP_RIGHT_TURN), Pair.of(DOWN_RIGHT_TURN, UP_LEFT_TURN), Pair.of(VERTICAL, THREE_WAY_UP), Pair.of(DOWN_LEFT_TURN, THREE_WAY_UP), Pair.of(DOWN_RIGHT_TURN, THREE_WAY_UP), Pair.of(HORIZONTAL, THREE_WAY_RIGHT), Pair.of(DOWN_LEFT_TURN, THREE_WAY_RIGHT), Pair.of(UP_LEFT_TURN, THREE_WAY_RIGHT), Pair.of(VERTICAL, THREE_WAY_DOWN), Pair.of(UP_LEFT_TURN, THREE_WAY_DOWN), Pair.of(UP_RIGHT_TURN, THREE_WAY_DOWN), Pair.of(HORIZONTAL, THREE_WAY_LEFT), Pair.of(DOWN_RIGHT_TURN, THREE_WAY_LEFT), Pair.of(UP_RIGHT_TURN, THREE_WAY_LEFT)));

    private final int baseDamage;
    private final Map<boolean[], Integer> activeDamageMap;
    private final boolean[] possibleDirections;
    private final List<Pair<AbilityTreeConnectionType, AbilityTreeConnectionType>> possibleMerges;
    private final Set<AbilityTreeConnectionType> selfMergeTypes;
    private final class_1799 baseItemStack;
    private final Map<Integer, class_1799> itemStackMap;

    private AbilityTreeConnectionType(int baseDamage, Map<boolean[], Integer> activeDamageMap, boolean[] possibleDirections, List<Pair<AbilityTreeConnectionType, AbilityTreeConnectionType>> possibleMerges) {
        this.baseDamage = baseDamage;
        this.activeDamageMap = activeDamageMap;
        this.possibleDirections = possibleDirections;
        this.possibleMerges = possibleMerges;
        this.itemStackMap = new HashMap<Integer, class_1799>();
        this.baseItemStack = this.generateItemStack(baseDamage);
        for (boolean[] blArray : activeDamageMap.keySet()) {
            this.itemStackMap.put(Arrays.hashCode(blArray), this.generateItemStack(activeDamageMap.get(blArray)));
        }
        this.selfMergeTypes = new HashSet<AbilityTreeConnectionType>();
        this.selfMergeTypes.add(this);
        for (Pair pair : possibleMerges) {
            this.selfMergeTypes.add((AbilityTreeConnectionType)((Object)pair.a()));
            this.selfMergeTypes.add((AbilityTreeConnectionType)((Object)pair.b()));
        }
    }

    public static AbilityTreeConnectionType fromDamage(int damage) {
        for (AbilityTreeConnectionType type : AbilityTreeConnectionType.values()) {
            if (type.baseDamage == damage) {
                return type;
            }
            for (int activeDamage : type.activeDamageMap.values()) {
                if (activeDamage != damage) continue;
                return type;
            }
        }
        return null;
    }

    public class_1799 getItemStack(boolean[] active) {
        return this.itemStackMap.getOrDefault(Arrays.hashCode(active), this.baseItemStack);
    }

    public boolean[] getPossibleDirections() {
        return this.possibleDirections;
    }

    public boolean isCompatible(AbilityTreeConnectionType other) {
        return this.selfMergeTypes.contains((Object)other);
    }

    public static AbilityTreeConnectionType merge(AbilityTreeConnectionType first, AbilityTreeConnectionType second) {
        if (first == second) {
            return first;
        }
        if (first.selfMergeTypes.contains((Object)second)) {
            return first;
        }
        if (second.selfMergeTypes.contains((Object)first)) {
            return second;
        }
        if (second.ordinal() < first.ordinal()) {
            AbilityTreeConnectionType temp = first;
            first = second;
            second = temp;
        }
        for (AbilityTreeConnectionType type : AbilityTreeConnectionType.values()) {
            for (Pair<AbilityTreeConnectionType, AbilityTreeConnectionType> pair : type.possibleMerges) {
                if (pair.a() != first || pair.b() != second) continue;
                return type;
            }
        }
        WynntilsMod.error("Tried to merge two incompatbilty AbilityTreeConnectionTypes: " + String.valueOf((Object)first) + " and " + String.valueOf((Object)second) + ".");
        return first;
    }

    private class_1799 generateItemStack(int damage) {
        class_1799 itemStack = new class_1799((class_1935)class_1802.field_8062);
        itemStack.method_7974(damage);
        itemStack.method_57379(class_9334.field_49630, (Object)new class_9300(false));
        return itemStack;
    }
}

