/*
 * Decompiled with CFR 0.152.
 */
package com.wynntils.models.activities.markers;

import com.wynntils.core.components.Managers;
import com.wynntils.core.components.Models;
import com.wynntils.features.combat.ContentTrackerFeature;
import com.wynntils.models.activities.type.ActivityType;
import com.wynntils.models.marker.type.MarkerInfo;
import com.wynntils.models.marker.type.MarkerProvider;
import com.wynntils.models.marker.type.StaticLocationSupplier;
import com.wynntils.services.map.pois.MarkerPoi;
import com.wynntils.utils.colors.CommonColors;
import com.wynntils.utils.mc.type.Location;
import com.wynntils.utils.mc.type.PoiLocation;
import java.util.Optional;
import java.util.stream.Stream;

public class ActivityMarkerProvider
implements MarkerProvider<MarkerPoi> {
    private static final String ACTIVITY_LOCATION_NAME = "Activity Location";
    private ActivityMarkerInfo spawnInfo;
    private ActivityMarkerInfo trackedActivityInfo;

    public void setSpawnLocation(ActivityType activityType, Location spawnLocation) {
        this.spawnInfo = spawnLocation == null ? null : new ActivityMarkerInfo(spawnLocation, new MarkerInfo(ACTIVITY_LOCATION_NAME, new StaticLocationSupplier(spawnLocation), activityType.getTexture(), activityType.getColor(), CommonColors.WHITE, CommonColors.WHITE, (Boolean)Managers.Feature.getFeatureInstance(ContentTrackerFeature.class).showAdditionalTextInWorld.get() != false ? Models.Activity.getTrackedName() : null), new MarkerPoi(PoiLocation.fromLocation(spawnLocation), ACTIVITY_LOCATION_NAME, activityType.getTexture()));
    }

    public Optional<Location> getSpawnLocation() {
        return this.spawnInfo == null ? Optional.empty() : Optional.ofNullable(this.spawnInfo.location());
    }

    public void setTrackedActivityLocation(ActivityType activityType, Location trackedActivityLocation) {
        this.trackedActivityInfo = trackedActivityLocation == null ? null : new ActivityMarkerInfo(trackedActivityLocation, new MarkerInfo(ACTIVITY_LOCATION_NAME, new StaticLocationSupplier(trackedActivityLocation), activityType.getTexture(), activityType.getColor(), CommonColors.WHITE, CommonColors.WHITE, (Boolean)Managers.Feature.getFeatureInstance(ContentTrackerFeature.class).showAdditionalTextInWorld.get() != false ? Models.Activity.getTrackedName() : null), new MarkerPoi(PoiLocation.fromLocation(trackedActivityLocation), ACTIVITY_LOCATION_NAME, activityType.getTexture()));
    }

    public Location getTrackedActivityLocation() {
        return this.trackedActivityInfo.location();
    }

    @Override
    public Stream<MarkerInfo> getMarkerInfos() {
        Stream<MarkerInfo> stream = Stream.empty();
        if (this.spawnInfo != null) {
            stream = Stream.concat(stream, Stream.of(this.spawnInfo.markerInfo()));
        }
        if (this.trackedActivityInfo != null) {
            stream = Stream.concat(stream, Stream.of(this.trackedActivityInfo.markerInfo()));
        }
        return stream;
    }

    @Override
    public Stream<MarkerPoi> getPois() {
        Stream<MarkerPoi> stream = Stream.empty();
        if (this.spawnInfo != null) {
            stream = Stream.concat(stream, Stream.of(this.spawnInfo.markerPoi()));
        }
        if (this.trackedActivityInfo != null) {
            stream = Stream.concat(stream, Stream.of(this.trackedActivityInfo.markerPoi()));
        }
        return stream;
    }

    @Override
    public boolean isEnabled() {
        return (Boolean)Managers.Feature.getFeatureInstance(ContentTrackerFeature.class).autoTrackCoordinates.get() != false && (this.spawnInfo != null || this.trackedActivityInfo != null);
    }

    private record ActivityMarkerInfo(Location location, MarkerInfo markerInfo, MarkerPoi markerPoi) {
    }
}

