/*
 * Decompiled with CFR 0.152.
 */
package com.wynntils.models.activities.type;

import com.wynntils.utils.colors.CustomColor;
import com.wynntils.utils.render.Texture;
import java.util.Objects;

public enum ActivityType {
    RECOMMENDED("Recommended", "recommended", null, null),
    QUEST("Quest", "quests", CustomColor.fromInt(2739350), Texture.QUEST_ICON),
    STORYLINE_QUEST("Quest", "quests", CustomColor.fromInt(0x33B33B), Texture.STORYLINE_QUEST_ICON),
    MINI_QUEST("Mini-Quest", "mini-quests", CustomColor.fromInt(11767725), Texture.MINI_QUEST_ICON),
    WORLD_EVENT("World Event", "world events", CustomColor.fromInt(48575), Texture.WORLD_EVENT_ICON),
    SECRET_DISCOVERY("Secret Discovery", "secret discoveries", CustomColor.fromInt(10601446), Texture.DISCOVERY_ICON),
    WORLD_DISCOVERY("World Discovery", "world discoveries", CustomColor.fromInt(10601446), Texture.DISCOVERY_ICON),
    TERRITORIAL_DISCOVERY("Territorial Discovery", "territorial discoveries", CustomColor.fromInt(10601446), Texture.DISCOVERY_ICON),
    CAVE("Cave", "caves", CustomColor.fromInt(16747545), Texture.CAVE),
    DUNGEON("Dungeon", "dungeons", CustomColor.fromInt(0xCC6677), Texture.DUNGEON_ENTRANCE),
    RAID("Raid", "raids", CustomColor.fromInt(14041118), Texture.RAID_ENTRANCE),
    BOSS_ALTAR("Boss Altar", "boss altars", CustomColor.fromInt(15913801), Texture.BOSS_ALTAR),
    LOOTRUN_CAMP("Lootrun Camp", "lootrun camps", CustomColor.fromInt(0x3399CC), Texture.LOOTRUN_CAMP);

    private final String displayName;
    private final String groupName;
    private final CustomColor color;
    private final Texture texture;

    private ActivityType(String displayName, String groupName, CustomColor color, Texture texture) {
        this.displayName = displayName;
        this.groupName = groupName;
        this.color = color;
        this.texture = texture;
    }

    public static ActivityType from(CustomColor color, String displayName) {
        for (ActivityType type : ActivityType.values()) {
            if (!Objects.equals(type.getColor(), color) || !type.getDisplayName().equals(displayName)) continue;
            return type;
        }
        return null;
    }

    public static ActivityType from(String displayName) {
        for (ActivityType type : ActivityType.values()) {
            if (!type.getDisplayName().equals(displayName)) continue;
            return type;
        }
        if (displayName.equals("Discovery")) {
            return WORLD_DISCOVERY;
        }
        return null;
    }

    public String getDisplayName() {
        return this.displayName;
    }

    public String getGroupName() {
        return this.groupName;
    }

    public CustomColor getColor() {
        return this.color;
    }

    public Texture getTexture() {
        return this.texture;
    }

    public boolean isQuest() {
        return this == QUEST || this == STORYLINE_QUEST || this == MINI_QUEST;
    }

    public boolean isDiscovery() {
        return this == SECRET_DISCOVERY || this == WORLD_DISCOVERY || this == TERRITORIAL_DISCOVERY;
    }

    public boolean matchesTracking(ActivityType activityType) {
        return switch (this.ordinal()) {
            case 2, 3 -> {
                if (activityType == this || activityType == QUEST) {
                    yield true;
                }
                yield false;
            }
            default -> activityType == this;
        };
    }
}

