/*
 * Decompiled with CFR 0.152.
 */
package com.wynntils.models.activities.type;

import com.wynntils.utils.EnumUtils;
import java.util.Arrays;
import java.util.stream.Collectors;

public enum Dungeon {
    DECREPIT_SEWERS,
    INFESTED_PIT,
    LOST_SANCTUARY(true, false),
    UNDERWORLD_CRYPT,
    TIMELOST_SANCTUM,
    SAND_SWEPT_TOMB("Sand-Swept Tomb"),
    ICE_BARROWS,
    UNDERGROWTH_RUINS,
    GALLEONS_GRAVEYARD("Galleon's Graveyard"),
    FALLEN_FACTORY,
    ELDRITCH_OUTLOOK;

    private final String name;
    private final boolean removed;
    private final boolean corruptedRemoved;

    private Dungeon() {
        this(false, false);
    }

    private Dungeon(boolean removed, boolean corruptedRemoved) {
        this.name = EnumUtils.toNiceString(this.name());
        this.removed = removed;
        this.corruptedRemoved = corruptedRemoved;
    }

    private Dungeon(String name) {
        this.name = name;
        this.removed = false;
        this.corruptedRemoved = false;
    }

    public static Dungeon fromName(String name) {
        for (Dungeon dungeon : Dungeon.values()) {
            if (!dungeon.getName().equals(name)) continue;
            return dungeon;
        }
        return null;
    }

    public String getName() {
        return this.name;
    }

    public boolean isRemoved() {
        return this.removed;
    }

    public boolean isCorruptedRemoved() {
        return this.corruptedRemoved;
    }

    public String getInitials() {
        return Arrays.stream(this.name.split(" ", 2)).map(s -> s.substring(0, 1)).collect(Collectors.joining());
    }

    public String toString() {
        return "Dungeon{name='" + this.name + "', removed=" + this.removed + ", corruptedRemoved=" + this.corruptedRemoved + "}";
    }
}

