/*
 * Decompiled with CFR 0.152.
 */
package com.wynntils.models.activities.worldevents;

import com.wynntils.core.WynntilsMod;
import com.wynntils.core.components.Handlers;
import com.wynntils.core.components.Model;
import com.wynntils.core.components.Models;
import com.wynntils.core.persisted.Persisted;
import com.wynntils.core.persisted.storage.Storage;
import com.wynntils.core.text.StyledText;
import com.wynntils.handlers.chat.event.ChatMessageEvent;
import com.wynntils.handlers.labels.event.LabelIdentifiedEvent;
import com.wynntils.handlers.labels.event.LabelsRemovedEvent;
import com.wynntils.handlers.labels.type.LabelInfo;
import com.wynntils.mc.event.ContainerSetSlotEvent;
import com.wynntils.mc.event.ScreenClosedEvent;
import com.wynntils.mc.event.ScreenInitEvent;
import com.wynntils.mc.event.TickEvent;
import com.wynntils.models.activities.bossbars.AnnihilationSunBar;
import com.wynntils.models.activities.event.AnnihilationEvent;
import com.wynntils.models.activities.label.WorldEventCountdownInfo;
import com.wynntils.models.activities.label.WorldEventCountdownParser;
import com.wynntils.models.activities.label.WorldEventNameInfo;
import com.wynntils.models.activities.label.WorldEventNameParser;
import com.wynntils.models.activities.type.ActivityDifficulty;
import com.wynntils.models.activities.type.ActivityDistance;
import com.wynntils.models.activities.type.ActivityInfo;
import com.wynntils.models.activities.type.ActivityLength;
import com.wynntils.models.activities.type.WorldEvent;
import com.wynntils.models.activities.worldevents.WorldEventInfo;
import com.wynntils.models.containers.Container;
import com.wynntils.models.containers.containers.reward.EventContainer;
import com.wynntils.models.containers.event.ValuableFoundEvent;
import com.wynntils.models.items.items.game.CorruptedCacheItem;
import com.wynntils.models.worlds.event.WorldStateEvent;
import com.wynntils.utils.VectorUtils;
import com.wynntils.utils.mc.McUtils;
import com.wynntils.utils.mc.StyledTextUtils;
import com.wynntils.utils.type.Time;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import net.minecraft.class_1799;
import net.minecraft.class_2374;
import net.minecraft.class_243;
import net.neoforged.bus.api.SubscribeEvent;

public final class WorldEventModel
extends Model {
    public static final AnnihilationSunBar annihilationSunBar = new AnnihilationSunBar();
    private static final String ANNIHILATION_WORLD_EVENT_NAME = "Prelude to Annihilation";
    private static final class_2374 ANNIHILATION_WORLD_EVENT_LOCATION = new class_243(315.5, 29.0, -1291.5);
    private static final Integer ANNIHILATION_WORLD_EVENT_RADIUS = 50;
    @Persisted
    public final Storage<Integer> dryAnnihilations = new Storage<Integer>(0);
    private static final Pattern IN_RADIUS_PATTERN = Pattern.compile("\u00a7#00bdbfff(\ue00d\ue002|\ue001) You are now within the event radius");
    private static final Pattern OUT_OF_RADIUS_PATTERN = Pattern.compile("\u00a7#00bdbfff(\ue00d\ue002|\ue001) You are no longer within the event radius");
    private static final Pattern DID_NOT_ENTER_PATTERN = Pattern.compile("\u00a7#00bdbfff(\ue00d\ue002|\ue001) You did not enter the event radius in time");
    private static final Pattern ANNIHILATION_TIMER_PATTERN = Pattern.compile("\u00a7#00bdbfff(\ue00d\ue002|\ue001) \u00a7cPrepare to defend the province at the Corruption Portal in(?: (?<hour>\\d+)h)?(?: (?<minute>\\d+)m)?(?: (?<second>\\d+)s)?!");
    private static final Pattern WORLD_EVENT_PATTERN = Pattern.compile("\u00a7#00bdbfff(\ue00d\ue002|\ue001) (?<worldEventName>.+?) World Event starts in(?: (?<hour>\\d+)h)?(?: (?<minute>\\d+)m)?(?: (?<second>\\d+)s)?! \u00a77\\(\\d+ blocks away\\) \u00a7d\u00a7nClick to track");
    private static final Pattern WORLD_EVENT_COMPLETE_PATTERN = Pattern.compile("\u00a7#00bdbfff\ue001 \u00a7fEvent Completed");
    private static final Pattern WORLD_EVENT_FAIL_PATTERN = Pattern.compile("\u00a7#00bdbfff\ue001 \u00a7fEvent Failed");
    private final Map<String, WorldEvent> activeWorldEvents = new HashMap<String, WorldEvent>();
    private boolean inWorldEventRadius = false;
    private String nearestWorldEventName = "";
    private Time nearestWorldEventStartTime = Time.NONE;
    private WorldEvent currentWorldEvent = null;
    private WorldEvent nearestWorldEvent = null;
    private boolean nextEventRewardIsAnnihilation = false;
    private int nextExpectedRewardContainerId = -2;

    public WorldEventModel() {
        super(List.of());
        Handlers.BossBar.registerBar(annihilationSunBar);
        Handlers.Label.registerParser(new WorldEventCountdownParser());
        Handlers.Label.registerParser(new WorldEventNameParser());
    }

    @SubscribeEvent
    public void onLabelIdentified(LabelIdentifiedEvent event) {
        LabelInfo labelInfo = event.getLabelInfo();
        if (labelInfo instanceof WorldEventCountdownInfo) {
            WorldEventCountdownInfo labelInfo2 = (WorldEventCountdownInfo)labelInfo;
            if (this.nearestWorldEventStartTime != Time.NONE) {
                return;
            }
            this.nearestWorldEventStartTime = labelInfo2.getStartTime();
            if (this.currentWorldEvent != null) {
                this.currentWorldEvent.setStartTime(this.nearestWorldEventStartTime);
            }
            if (this.nearestWorldEvent != null) {
                this.nearestWorldEvent.setStartTime(this.nearestWorldEventStartTime);
            } else if (!this.nearestWorldEventName.isEmpty()) {
                this.nearestWorldEvent = new WorldEvent(this.nearestWorldEventName, this.nearestWorldEventStartTime);
                this.activeWorldEvents.put(this.nearestWorldEventName, this.nearestWorldEvent);
            }
        } else {
            labelInfo = event.getLabelInfo();
            if (labelInfo instanceof WorldEventNameInfo) {
                WorldEventNameInfo labelInfo3 = (WorldEventNameInfo)labelInfo;
                if (this.currentWorldEvent != null) {
                    return;
                }
                if (this.nearestWorldEventStartTime == Time.NONE) {
                    this.nearestWorldEventName = labelInfo3.getWorldEventName();
                    return;
                }
                this.nearestWorldEvent = new WorldEvent(labelInfo3.getWorldEventName(), this.nearestWorldEventStartTime);
                this.activeWorldEvents.put(labelInfo3.getWorldEventName(), this.nearestWorldEvent);
            }
        }
    }

    @SubscribeEvent
    public void onLabelsRemoved(LabelsRemovedEvent event) {
        Optional<LabelInfo> labelOpt = event.getRemovedLabels().stream().filter(labelInfo -> labelInfo instanceof WorldEventNameInfo).findAny();
        if (labelOpt.isPresent() && !this.inWorldEventRadius) {
            this.exitWorldEvent();
        }
    }

    @SubscribeEvent
    public void onChatMessage(ChatMessageEvent.Match event) {
        StyledText styledText = StyledTextUtils.unwrap(event.getMessage()).stripAlignment();
        if (styledText.matches(IN_RADIUS_PATTERN)) {
            this.inWorldEventRadius = true;
            if (this.nearestWorldEvent == null && VectorUtils.distanceIgnoringY((class_2374)McUtils.player().method_19538(), ANNIHILATION_WORLD_EVENT_LOCATION) < (float)ANNIHILATION_WORLD_EVENT_RADIUS.intValue()) {
                this.nearestWorldEvent = new WorldEvent(ANNIHILATION_WORLD_EVENT_NAME, this.nearestWorldEventStartTime);
                if (this.activeWorldEvents.containsKey(this.nearestWorldEvent.getName())) {
                    this.nearestWorldEvent.setStartTime(this.activeWorldEvents.get(this.nearestWorldEvent.getName()).getStartTime());
                } else {
                    this.activeWorldEvents.put(this.nearestWorldEvent.getName(), this.nearestWorldEvent);
                }
            }
            this.currentWorldEvent = this.nearestWorldEvent;
            return;
        }
        if (styledText.matches(OUT_OF_RADIUS_PATTERN)) {
            this.inWorldEventRadius = false;
            this.nearestWorldEvent = this.currentWorldEvent;
            this.exitWorldEvent();
            return;
        }
        if (styledText.matches(DID_NOT_ENTER_PATTERN) && this.nearestWorldEvent != null) {
            this.activeWorldEvents.remove(this.nearestWorldEvent.getName());
            this.nearestWorldEvent = null;
            this.nearestWorldEventStartTime = Time.NONE;
            return;
        }
        if (styledText.matches(WORLD_EVENT_COMPLETE_PATTERN)) {
            if (this.currentWorldEvent == null) {
                WynntilsMod.warn("Completed a world event but current world event was unknown");
                return;
            }
            if (this.currentWorldEvent.getName().equals(ANNIHILATION_WORLD_EVENT_NAME)) {
                this.nextEventRewardIsAnnihilation = true;
                WynntilsMod.postEvent(new AnnihilationEvent.Completed());
            }
            this.currentWorldEvent = null;
            return;
        }
        if (styledText.matches(WORLD_EVENT_FAIL_PATTERN)) {
            this.currentWorldEvent = null;
            if (this.currentWorldEvent.getName().equals(ANNIHILATION_WORLD_EVENT_NAME)) {
                WynntilsMod.postEvent(new AnnihilationEvent.Failed());
            }
            return;
        }
        Matcher matcher = styledText.getMatcher(ANNIHILATION_TIMER_PATTERN);
        if (!this.activeWorldEvents.containsKey(ANNIHILATION_WORLD_EVENT_NAME) && matcher.matches()) {
            Time anniStartTime = this.parseWorldEventStartTime(matcher.group("hour"), matcher.group("minute"), matcher.group("second"));
            this.activeWorldEvents.put(ANNIHILATION_WORLD_EVENT_NAME, new WorldEvent(ANNIHILATION_WORLD_EVENT_NAME, anniStartTime));
            return;
        }
        matcher = styledText.getMatcher(WORLD_EVENT_PATTERN);
        if (matcher.matches()) {
            String worldEventName = matcher.group("worldEventName");
            Time startTime = this.parseWorldEventStartTime(matcher.group("hour"), matcher.group("minute"), matcher.group("second"));
            this.activeWorldEvents.put(worldEventName, new WorldEvent(worldEventName, startTime));
            return;
        }
    }

    @SubscribeEvent
    public void onWorldStateChange(WorldStateEvent e) {
        this.nearestWorldEvent = null;
        this.nearestWorldEventStartTime = Time.NONE;
        this.exitWorldEvent();
    }

    @SubscribeEvent
    public void onTickAlways(TickEvent e) {
        if (McUtils.player().field_6012 % 20 != 0) {
            return;
        }
        this.activeWorldEvents.entrySet().removeIf(entry -> ((WorldEvent)entry.getValue()).getStartTime().getOffset(Time.now()) >= 0L);
    }

    @SubscribeEvent
    public void onScreenInit(ScreenInitEvent.Pre e) {
        Container container = Models.Container.getCurrentContainer();
        if (container instanceof EventContainer) {
            EventContainer eventContainer = (EventContainer)container;
            this.nextExpectedRewardContainerId = eventContainer.getContainerId();
        }
    }

    @SubscribeEvent
    public void onScreenClose(ScreenClosedEvent.Post e) {
        if (this.nextEventRewardIsAnnihilation) {
            this.dryAnnihilations.store((Integer)this.dryAnnihilations.get() + 1);
            this.nextEventRewardIsAnnihilation = false;
        }
        this.nextExpectedRewardContainerId = -2;
    }

    @SubscribeEvent
    public void onSetSlot(ContainerSetSlotEvent.Post event) {
        if (event.getContainerId() != this.nextExpectedRewardContainerId) {
            return;
        }
        if (event.getSlot() >= 27) {
            return;
        }
        class_1799 itemStack = event.getItemStack();
        Optional<CorruptedCacheItem> cacheItem = Models.Item.asWynnItem(itemStack, CorruptedCacheItem.class);
        if (cacheItem.isPresent()) {
            WynntilsMod.postEvent(new ValuableFoundEvent(itemStack, ValuableFoundEvent.ItemSource.WORLD_EVENT));
            this.dryAnnihilations.store(0);
            this.nextExpectedRewardContainerId = -2;
            this.nextEventRewardIsAnnihilation = false;
            return;
        }
    }

    public WorldEvent getCurrentWorldEvent() {
        return this.currentWorldEvent;
    }

    public WorldEvent getWorldEvent(String worldEventName) {
        return this.activeWorldEvents.get(worldEventName);
    }

    public Time parseWorldEventStartTime(String hour, String minute, String second) {
        int hours = hour != null ? Integer.parseInt(hour) : 0;
        int minutes = minute != null ? Integer.parseInt(minute) : 0;
        int seconds = second != null ? Integer.parseInt(second) : 0;
        long currentTime = System.currentTimeMillis();
        long countDown = (((long)hours * 60L + (long)minutes) * 60L + (long)seconds) * 1000L;
        long rawStartTime = currentTime + countDown;
        long remainder = rawStartTime % 60000L;
        long startTime = remainder == 0L ? rawStartTime : rawStartTime + (60000L - remainder);
        return Time.of(startTime);
    }

    private void exitWorldEvent() {
        this.nearestWorldEvent = this.currentWorldEvent;
        this.nearestWorldEventStartTime = Time.NONE;
        this.currentWorldEvent = null;
    }

    private WorldEventInfo getWorldEventInfoFromActivity(ActivityInfo activity) {
        return new WorldEventInfo(activity.name(), activity.specialInfo().orElse(""), activity.description().orElse(StyledText.EMPTY).getString(), activity.status(), activity.requirements().level().key(), activity.distance().orElse(ActivityDistance.NEAR), activity.length().orElse(ActivityLength.SHORT), activity.difficulty().orElse(ActivityDifficulty.EASY), activity.rewards());
    }
}

