/*
 * Decompiled with CFR 0.152.
 */
package com.wynntils.models.aspects;

import com.wynntils.core.WynntilsMod;
import com.wynntils.core.components.Model;
import com.wynntils.core.components.Models;
import com.wynntils.core.net.DownloadRegistry;
import com.wynntils.core.persisted.Persisted;
import com.wynntils.core.persisted.storage.Storage;
import com.wynntils.core.text.StyledText;
import com.wynntils.handlers.item.ItemAnnotation;
import com.wynntils.mc.event.ContainerSetContentEvent;
import com.wynntils.mc.event.ContainerSetSlotEvent;
import com.wynntils.models.aspects.AspectInfoRegistry;
import com.wynntils.models.aspects.type.AspectInfo;
import com.wynntils.models.character.type.ClassType;
import com.wynntils.models.containers.Container;
import com.wynntils.models.containers.containers.AspectsContainer;
import com.wynntils.models.containers.containers.RaidRewardChestContainer;
import com.wynntils.models.containers.containers.RaidRewardPreviewContainer;
import com.wynntils.models.items.items.game.AspectItem;
import com.wynntils.utils.mc.McUtils;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Optional;
import java.util.TreeMap;
import java.util.regex.Pattern;
import java.util.stream.Stream;
import net.minecraft.class_1799;
import net.neoforged.bus.api.SubscribeEvent;

public final class AspectModel
extends Model {
    private static final Pattern NO_ASPECT_PATTERN = Pattern.compile("\u00a78\u00a7l(?:Empty|Locked) Aspect Slot");
    private final AspectInfoRegistry aspectInfoRegistry = new AspectInfoRegistry();
    @Persisted
    private final Storage<Map<String, List<String>>> equippedAspects = new Storage(new TreeMap());
    @Persisted
    private final Storage<Map<String, Integer>> ownedAspects = new Storage(new TreeMap());

    public AspectModel() {
        super(List.of());
    }

    @Override
    public void registerDownloads(DownloadRegistry registry) {
        this.aspectInfoRegistry.registerDownloads(registry);
    }

    @SubscribeEvent
    public void onContentSet(ContainerSetContentEvent.Pre event) {
        List<Integer> ownedSlots;
        Container currentContainer = Models.Container.getCurrentContainer();
        ArrayList<Object> equippedSlots = new ArrayList();
        if (currentContainer instanceof AspectsContainer) {
            AspectsContainer aspectsContainer = (AspectsContainer)currentContainer;
            equippedSlots = new ArrayList<Integer>(aspectsContainer.getEquippedSlots());
        }
        if ((ownedSlots = this.getOwnedSlotsFromContainer(currentContainer)).isEmpty()) {
            return;
        }
        ArrayList<String> characterEquippedAspects = new ArrayList<String>();
        Map newOwnedAspects = (Map)this.ownedAspects.get();
        for (int i = 0; i < event.getItems().size(); ++i) {
            StyledText itemName;
            class_1799 itemStack;
            boolean owned = ownedSlots.contains(i);
            boolean equipped = equippedSlots.contains(i);
            if (!equipped && !owned || (itemStack = event.getItems().get(i)).method_7960() || equipped && (itemName = StyledText.fromComponent(itemStack.method_7964())).matches(NO_ASPECT_PATTERN)) continue;
            Optional<AspectItem> aspectItemOpt = Models.Item.asWynnItem(itemStack, AspectItem.class);
            if (aspectItemOpt.isEmpty()) break;
            newOwnedAspects.put(aspectItemOpt.get().getName(), aspectItemOpt.get().getTier());
            if (!equipped) continue;
            characterEquippedAspects.add(aspectItemOpt.get().getName());
        }
        if (!equippedSlots.isEmpty()) {
            Map currentEquippedAspects = (Map)this.equippedAspects.get();
            currentEquippedAspects.put(Models.Character.getId(), characterEquippedAspects);
            this.equippedAspects.store(currentEquippedAspects);
            this.equippedAspects.touched();
        }
        this.ownedAspects.store(newOwnedAspects);
        this.ownedAspects.touched();
    }

    @SubscribeEvent
    public void onContainerSetSlot(ContainerSetSlotEvent.Pre event) {
        Container container = Models.Container.getCurrentContainer();
        if (!(container instanceof AspectsContainer)) {
            return;
        }
        AspectsContainer aspectsContainer = (AspectsContainer)container;
        ArrayList characterAspects = new ArrayList();
        McUtils.mc().field_1724.field_7512.field_7761.forEach(slot -> {
            if (aspectsContainer.getEquippedSlots().contains(slot.field_7874)) {
                class_1799 itemStack = slot.method_7677();
                if (itemStack.method_7960()) {
                    return;
                }
                StyledText itemName = StyledText.fromComponent(itemStack.method_7964());
                if (itemName.matches(NO_ASPECT_PATTERN)) {
                    return;
                }
                Optional<AspectItem> aspectItemOpt = Models.Item.asWynnItem(itemStack, AspectItem.class);
                if (aspectItemOpt.isEmpty()) {
                    return;
                }
                characterAspects.add(aspectItemOpt.get().getName());
            }
        });
        Map currentEquippedAspects = (Map)this.equippedAspects.get();
        currentEquippedAspects.put(Models.Character.getId(), characterAspects);
        this.equippedAspects.store(currentEquippedAspects);
        this.equippedAspects.touched();
    }

    public Stream<AspectInfo> getAllAspectInfos() {
        return this.aspectInfoRegistry.getAllAspectInfos();
    }

    public Optional<String> getEquippedAspect(int index) {
        List characterAspects = ((Map)this.equippedAspects.get()).getOrDefault(Models.Character.getId(), new ArrayList());
        if (index < 0 || index >= characterAspects.size()) {
            return Optional.empty();
        }
        return Optional.of((String)characterAspects.get(index));
    }

    public Optional<String> getEquippedAspectByName(String aspectName) {
        List characterAspects = ((Map)this.equippedAspects.get()).getOrDefault(Models.Character.getId(), new ArrayList());
        return characterAspects.stream().filter(aspect -> aspect.toLowerCase(Locale.ROOT).endsWith(aspectName.toLowerCase(Locale.ROOT))).findFirst();
    }

    public Optional<Integer> getAspectTierByName(String aspectName) {
        return ((Map)this.ownedAspects.get()).entrySet().stream().filter(entry -> ((String)entry.getKey()).toLowerCase(Locale.ROOT).endsWith(aspectName.toLowerCase(Locale.ROOT))).map(Map.Entry::getValue).findFirst();
    }

    public ItemAnnotation fromNameAndClass(StyledText name, ClassType classType, int tier) {
        AspectInfo aspectInfo = this.aspectInfoRegistry.getFromClassAndDisplayName(classType, name.getStringWithoutFormatting());
        if (aspectInfo == null) {
            WynntilsMod.warn("Could not find aspect info for " + name.getStringWithoutFormatting());
            return null;
        }
        return new AspectItem(aspectInfo, tier);
    }

    private List<Integer> getOwnedSlotsFromContainer(Container container) {
        if (container instanceof AspectsContainer) {
            AspectsContainer aspectsContainer = (AspectsContainer)container;
            return aspectsContainer.getAspectBounds().getSlots();
        }
        if (container instanceof RaidRewardChestContainer) {
            RaidRewardChestContainer rewardChestContainer = (RaidRewardChestContainer)container;
            return rewardChestContainer.getAspectBounds().getSlots();
        }
        if (container instanceof RaidRewardPreviewContainer) {
            RaidRewardPreviewContainer rewardPreviewContainer = (RaidRewardPreviewContainer)container;
            return rewardPreviewContainer.getRewardBounds().getSlots();
        }
        return List.of();
    }
}

