/*
 * Decompiled with CFR 0.152.
 */
package com.wynntils.models.character;

import com.wynntils.core.WynntilsMod;
import com.wynntils.core.components.Model;
import com.wynntils.core.components.Models;
import com.wynntils.core.text.StyledText;
import com.wynntils.handlers.container.scriptedquery.QueryBuilder;
import com.wynntils.handlers.container.scriptedquery.QueryStep;
import com.wynntils.handlers.container.scriptedquery.ScriptedContainerQuery;
import com.wynntils.handlers.container.type.ContainerContent;
import com.wynntils.mc.event.ContainerClickEvent;
import com.wynntils.mc.event.SetLocalPlayerVehicleEvent;
import com.wynntils.models.character.event.CharacterUpdateEvent;
import com.wynntils.models.character.type.ClassType;
import com.wynntils.models.character.type.VehicleType;
import com.wynntils.models.items.items.gui.CharacterItem;
import com.wynntils.models.worlds.event.WorldStateEvent;
import com.wynntils.models.worlds.type.WorldState;
import com.wynntils.utils.mc.LoreUtils;
import com.wynntils.utils.mc.McUtils;
import java.util.LinkedList;
import java.util.List;
import java.util.Optional;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import net.minecraft.class_1297;
import net.minecraft.class_1496;
import net.minecraft.class_1799;
import net.minecraft.class_8113;
import net.neoforged.bus.api.EventPriority;
import net.neoforged.bus.api.SubscribeEvent;

public final class CharacterModel
extends Model {
    private static final Pattern CHARACTER_ID_PATTERN = Pattern.compile("^[a-z0-9]{8}$");
    private static final Pattern INFO_MENU_CLASS_PATTERN = Pattern.compile("\u00a77Class: \u00a7f(.+)");
    private static final Pattern INFO_MENU_LEVEL_PATTERN = Pattern.compile("\u00a77Combat Lv: \u00a7f(\\d+)");
    public static final int CHARACTER_INFO_SLOT = 7;
    private static final int PROFESSION_INFO_SLOT = 17;
    public static final int GUILD_MENU_SLOT = 26;
    private boolean hasCharacter;
    private ClassType classType = ClassType.NONE;
    private boolean reskinned;
    private int level;
    private String id = "-";
    private String previousScanId = "";
    private VehicleType vehicle = VehicleType.NONE;

    public CharacterModel() {
        super(List.of());
    }

    public ClassType getClassType() {
        if (!this.hasCharacter) {
            return ClassType.NONE;
        }
        return this.classType;
    }

    public boolean isReskinned() {
        if (!this.hasCharacter) {
            return false;
        }
        return this.reskinned;
    }

    public String getActualName() {
        return this.getClassType().getActualName(this.isReskinned());
    }

    public boolean hasCharacter() {
        return this.hasCharacter;
    }

    public String getId() {
        if (!this.hasCharacter) {
            return "-";
        }
        return this.id;
    }

    public boolean isHuntedMode() {
        return false;
    }

    @SubscribeEvent(priority=EventPriority.HIGHEST)
    public void onWorldStateChanged(WorldStateEvent e) {
        if (e.getOldState() == WorldState.WORLD) {
            this.hasCharacter = false;
        }
        if (e.getNewState() == WorldState.WORLD) {
            this.updateCharacterId();
            this.scanCharacterInfo();
        }
    }

    @SubscribeEvent
    public void onContainerClick(ContainerClickEvent e) {
        if (Models.WorldState.getCurrentState() == WorldState.CHARACTER_SELECTION && e.getMouseButton() != 1) {
            this.handleSelectedCharacter(e.getItemStack());
        }
    }

    public void handleSelectedCharacter(class_1799 itemStack) {
        if (!this.parseCharacter(itemStack)) {
            return;
        }
        this.hasCharacter = true;
        WynntilsMod.info("Selected character " + this.getCharacterString());
    }

    public void setSelectedCharacterFromCharacterSelection(ClassType classType, boolean isReskinned, int level) {
        this.hasCharacter = true;
        this.updateCharacterInfo(classType, isReskinned, level);
        WynntilsMod.info("Selected character " + this.getCharacterString());
    }

    public void scanCharacterInfo() {
        if (this.id.equals(this.previousScanId)) {
            this.hasCharacter = true;
            return;
        }
        WynntilsMod.info("Scheduling character info query");
        QueryBuilder queryBuilder = ScriptedContainerQuery.builder("Character Info Query");
        queryBuilder.onError(msg -> WynntilsMod.warn("Error querying Character Info: " + msg));
        queryBuilder.then(QueryStep.useItemInHotbar(7).expectContainerTitle("\udaff\udfdc\ue003").processIncomingContainer(this::parseCharacterContainer));
        Models.Guild.addGuildContainerQuerySteps(queryBuilder);
        queryBuilder.build().executeQuery();
        this.previousScanId = this.id;
    }

    public VehicleType getVehicle() {
        return this.vehicle;
    }

    public void setVehicle(VehicleType vehicle) {
        this.vehicle = vehicle;
    }

    @SubscribeEvent
    public void onVehicleSet(SetLocalPlayerVehicleEvent event) {
        if (event.getVehicle() == null) {
            this.setVehicle(VehicleType.NONE);
            return;
        }
        class_1297 vehicle = event.getVehicle();
        if (vehicle instanceof class_1496) {
            this.setVehicle(VehicleType.HORSE);
        } else if (vehicle instanceof class_8113) {
            this.setVehicle(VehicleType.DISPLAY);
        } else {
            this.setVehicle(VehicleType.OTHER);
        }
    }

    private void parseCharacterContainer(ContainerContent container) {
        class_1799 characterInfoItem = container.items().get(7);
        class_1799 professionInfoItem = container.items().get(17);
        class_1799 guildInfoItem = container.items().get(26);
        Models.Profession.resetValueFromItem(professionInfoItem);
        Models.Guild.parseGuildInfoFromGuildMenu(guildInfoItem);
        this.parseCharacterFromCharacterMenu(characterInfoItem);
        this.hasCharacter = true;
        WynntilsMod.postEvent(new CharacterUpdateEvent());
        WynntilsMod.info("Deducing character " + this.getCharacterString());
    }

    private void updateCharacterId() {
        class_1799 compassItem = (class_1799)McUtils.inventory().field_7547.get(7);
        LinkedList<StyledText> compassLore = LoreUtils.getLore(compassItem);
        StyledText idLine = (StyledText)compassLore.getFirst();
        if (idLine == null || !idLine.matches(CHARACTER_ID_PATTERN)) {
            WynntilsMod.warn("Compass item had unexpected character ID line: " + String.valueOf(idLine));
            return;
        }
        this.id = idLine.getString();
        WynntilsMod.info("Selected character: " + this.id);
    }

    private String getCharacterString() {
        return "CharacterInfo{classType=" + String.valueOf((Object)this.classType) + ", reskinned=" + this.reskinned + ", level=" + this.level + ", id=" + this.id + "}";
    }

    private void parseCharacterFromCharacterMenu(class_1799 characterInfoItem) {
        ClassType foundClassType;
        LinkedList<StyledText> lore = LoreUtils.getLore(characterInfoItem);
        int foundLevel = 0;
        String className = "";
        for (StyledText line : lore) {
            Matcher levelMatcher = line.getMatcher(INFO_MENU_LEVEL_PATTERN);
            if (levelMatcher.matches()) {
                foundLevel = Integer.parseInt(levelMatcher.group(1));
                continue;
            }
            Matcher classMatcher = line.getMatcher(INFO_MENU_CLASS_PATTERN);
            if (!classMatcher.matches()) continue;
            className = classMatcher.group(1);
        }
        this.updateCharacterInfo(foundClassType, (foundClassType = ClassType.fromName(className)) != null && ClassType.isReskinned(className), foundLevel);
    }

    private boolean parseCharacter(class_1799 itemStack) {
        Optional<CharacterItem> characterItemOpt = Models.Item.asWynnItem(itemStack, CharacterItem.class);
        if (characterItemOpt.isEmpty()) {
            return false;
        }
        CharacterItem characterItem = characterItemOpt.get();
        this.updateCharacterInfo(characterItem.getClassType(), characterItem.isReskinned(), characterItem.getLevel());
        return true;
    }

    private void updateCharacterInfo(ClassType classType, boolean reskinned, int level) {
        this.classType = classType;
        this.reskinned = reskinned;
        this.level = level;
    }
}

