/*
 * Decompiled with CFR 0.152.
 */
package com.wynntils.models.characterstats.actionbar.matchers;

import com.wynntils.core.WynntilsMod;
import com.wynntils.handlers.actionbar.ActionBarSegment;
import com.wynntils.handlers.actionbar.ActionBarSegmentMatcher;
import com.wynntils.utils.type.CappedValue;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public abstract class AbstractTextSegmentMatcher
implements ActionBarSegmentMatcher {
    protected static final char POSITIVE_SPACE_HIGH_SURROGATE = '\udb00';
    protected static final char NEGATIVE_SPACE_HIGH_SURROGATE = '\udaff';
    private static final String CHAR_SEPARATOR = "\udaff\udfff";
    private static final String SLASH_SEPARATOR = "\udb00\udc02";
    private static final char DISPLAY_CHARACTER_START = '\ue010';
    private static final char DISPLAY_CHARACTER_END = '\ue01f';
    private static final List<String> DISPLAY_CHARACTER_TRANSLATION = List.of("0", "1", "2", "3", "4", "5", "6", "7", "8", "9", "k", "m", "b", "t", ".", "/");
    private static final Map<Character, Long> NUMBER_SHORT_MULTIPLIERS = Map.of(Character.valueOf('k'), 1000L, Character.valueOf('m'), 1000000L, Character.valueOf('b'), 1000000000L, Character.valueOf('t'), 1000000000000L);
    private static final Pattern VALUE_PATTERN = Pattern.compile("(?<current>\\d+[kmbt]?)/(?<max>\\d+[kmbt]?)");
    private final Pattern segmentPattern = Pattern.compile(".(?<value>[\ue010-\ue01f\udaff\udfff\udb00\udc02]+).");

    protected abstract SegmentSeparators segmentSeparators();

    protected abstract ActionBarSegment createSegment(String var1, CappedValue var2);

    @Override
    public ActionBarSegment parse(String actionBar) {
        Matcher matcher = this.segmentPattern.matcher(actionBar);
        if (!matcher.find()) {
            return null;
        }
        do {
            boolean validEnd;
            String segmentText = matcher.group();
            SegmentSeparators separators = this.segmentSeparators();
            char startChar = segmentText.charAt(0);
            char endChar = segmentText.charAt(segmentText.length() - 2);
            boolean validStart = startChar == separators.segmentStart;
            boolean bl = validEnd = endChar == separators.segmentEnd;
            if (!validStart || !validEnd) continue;
            CappedValue value = this.valueFromDisplayCharacters(matcher.group("value"));
            return this.createSegment(segmentText, value);
        } while (matcher.find());
        return null;
    }

    private CappedValue valueFromDisplayCharacters(String displayCharacters) {
        displayCharacters = displayCharacters.replace(CHAR_SEPARATOR, "");
        displayCharacters = displayCharacters.replace(SLASH_SEPARATOR, "");
        StringBuilder valueBuilder = new StringBuilder();
        for (char current : displayCharacters.toCharArray()) {
            int index = current - 57360;
            if (index < 0 || DISPLAY_CHARACTER_TRANSLATION.size() <= index) {
                WynntilsMod.warn("Unknown display character: " + current);
                continue;
            }
            valueBuilder.append(DISPLAY_CHARACTER_TRANSLATION.get(index));
        }
        String value = valueBuilder.toString();
        Matcher matcher = VALUE_PATTERN.matcher(value);
        if (!matcher.matches()) {
            WynntilsMod.warn("Could not parse text action bar segment value as capped: " + value);
            return CappedValue.EMPTY;
        }
        long current = AbstractTextSegmentMatcher.parseShortNumber(matcher.group("current"));
        long max = AbstractTextSegmentMatcher.parseShortNumber(matcher.group("max"));
        if (current > Integer.MAX_VALUE) {
            WynntilsMod.warn("Current health/mana value is too large: " + current);
            return CappedValue.EMPTY;
        }
        if (max > Integer.MAX_VALUE) {
            WynntilsMod.warn("Max health/mana value is too large: " + max);
            return CappedValue.EMPTY;
        }
        return new CappedValue((int)current, (int)max);
    }

    private static long parseShortNumber(String value) {
        if (value.isEmpty()) {
            return 0L;
        }
        char lastChar = value.charAt(value.length() - 1);
        long multiplier = NUMBER_SHORT_MULTIPLIERS.getOrDefault(Character.valueOf(lastChar), 1L);
        if (multiplier == 1L) {
            try {
                return Long.parseLong(value);
            }
            catch (NumberFormatException e) {
                return 0L;
            }
        }
        try {
            return Long.parseLong(value.substring(0, value.length() - 1)) * multiplier;
        }
        catch (NumberFormatException e) {
            return 0L;
        }
    }

    protected record SegmentSeparators(char segmentStart, char segmentEnd) {
    }
}

