/*
 * Decompiled with CFR 0.152.
 */
package com.wynntils.models.characterstats.actionbar.matchers;

import com.wynntils.core.WynntilsMod;
import com.wynntils.handlers.actionbar.ActionBarSegment;
import com.wynntils.models.characterstats.actionbar.matchers.AbstractMeterSegmentMatcher;
import com.wynntils.models.characterstats.actionbar.segments.MeterBarSegment;
import com.wynntils.models.characterstats.type.MeterBarInfo;
import com.wynntils.utils.type.CappedValue;
import java.util.List;
import java.util.regex.Pattern;

public class MeterBarSegmentMatcher
extends AbstractMeterSegmentMatcher {
    private static final int ACTION_STEPS = 25;
    private static final CappedValue FULL_METER = new CappedValue(25, 25);
    private static final char FULL_METER_CHARACTER = '\ue090';
    private static final char EMPTY_METER_CHARACTER = '\ue091';
    private static final String DEFAULT_METER_CHARACTERS = "\ue090-\ue091";
    private static final String SPRINT_METER_CHARACTERS = "\ue0a0-\ue0b8";
    private static final String BREATH_METER_CHARACTERS = "\ue0c0-\ue0d8";
    private static final List<String> METER_CHARACTERS = List.of("\ue090-\ue091", "\ue0a0-\ue0b8", "\ue0c0-\ue0d8");
    private static final Pattern BREATH_METER_PATTERN = Pattern.compile("[\ue0c0-\ue0d8]");
    private static final Pattern SPRINT_METER_PATTERN = Pattern.compile("[\ue0a0-\ue0b8]");

    @Override
    protected List<String> getCharacterRange() {
        return METER_CHARACTERS;
    }

    @Override
    protected ActionBarSegment createSegment(String segmentText, String segmentValue) {
        MeterBarInfo meterBarInfo = this.fromSegmentText(segmentValue);
        return new MeterBarSegment(segmentText, meterBarInfo);
    }

    private MeterBarInfo fromSegmentText(String segmentValue) {
        char firstActionCharacter;
        MeterBarInfo.MeterActionType actionType;
        char meterChar = segmentValue.charAt(0);
        if (meterChar == '\ue091') {
            return MeterBarInfo.EMPTY;
        }
        if (meterChar == '\ue090') {
            return new MeterBarInfo(MeterBarInfo.MeterActionType.BOTH, FULL_METER);
        }
        if (SPRINT_METER_PATTERN.matcher(segmentValue).matches()) {
            actionType = MeterBarInfo.MeterActionType.SPRINT;
            firstActionCharacter = SPRINT_METER_CHARACTERS.charAt(0);
        } else if (BREATH_METER_PATTERN.matcher(segmentValue).matches()) {
            actionType = MeterBarInfo.MeterActionType.BREATH;
            firstActionCharacter = BREATH_METER_CHARACTERS.charAt(0);
        } else {
            WynntilsMod.warn("Unknown meter bar action type: " + segmentValue);
            return MeterBarInfo.EMPTY;
        }
        int actionStep = 25 - (meterChar - firstActionCharacter);
        if (actionStep < 0 || actionStep > 25) {
            WynntilsMod.warn("Invalid meter bar action step: " + actionStep);
            return MeterBarInfo.EMPTY;
        }
        return new MeterBarInfo(actionType, new CappedValue(actionStep, 25));
    }
}

