/*
 * Decompiled with CFR 0.152.
 */
package com.wynntils.models.combat.bossbar;

import com.wynntils.core.components.Models;
import com.wynntils.handlers.bossbar.TrackedBar;
import com.wynntils.models.combat.type.MobElementals;
import com.wynntils.models.elements.type.Element;
import com.wynntils.utils.StringUtils;
import com.wynntils.utils.type.CappedValue;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;

public final class DamageBar
extends TrackedBar {
    private static final Pattern DAMAGE_BAR_PATTERN = Pattern.compile("^\\s*\u00a7(?:#)?[0-9a-f]{1,8}(?:\u00a7l)?(.*?)\u00a7r - \u00a7c(\\d+(?:\\.\\d+)?[km]?)\u00a74\u2764(?:\u00a7r - ((?:\u00a7.|\\S)*?Weak))?(?:.*?((?:\u00a7.|\\S)*?Dam))?(?:.*?((?:\u00a7.|\\S)*?Def))?\\s*$");
    private static final Pattern ELEMENT_PATTERN = Pattern.compile("\u00a7[0-9a-f](" + Arrays.stream(Element.values()).map(e -> Pattern.quote(e.getSymbol())).collect(Collectors.joining("|")) + ")");

    public DamageBar() {
        super(DAMAGE_BAR_PATTERN);
    }

    @Override
    public void onUpdateName(Matcher match) {
        String mobName = match.group(1);
        long health = StringUtils.parseSuffixedInteger(match.group(2));
        List<Element> weaknesses = this.parseElements(match.group(3));
        List<Element> damages = this.parseElements(match.group(4));
        List<Element> defenses = this.parseElements(match.group(5));
        MobElementals mobElementals = new MobElementals(weaknesses, damages, defenses);
        Models.Combat.checkFocusedMobValidity();
        if (mobName.equals(Models.Combat.getFocusedMobName()) && mobElementals.equals(Models.Combat.getFocusedMobElementals())) {
            Models.Combat.updateFocusedMobHealth(health);
        } else {
            Models.Combat.updateFocusedMob(mobName, mobElementals, health);
        }
        Models.Combat.revalidateFocusedMob();
        Models.Combat.setLastDamageDealtTimestamp(System.currentTimeMillis());
    }

    @Override
    public void onUpdateProgress(float progress) {
        Models.Combat.updateFocusedMobHealthPercent(new CappedValue(Math.round(progress * 100.0f), 100));
        Models.Combat.revalidateFocusedMob();
    }

    @Override
    protected void reset() {
        Models.Combat.invalidateFocusedMob();
    }

    private List<Element> parseElements(String elementPart) {
        ArrayList<Element> elements = new ArrayList<Element>();
        if (elementPart == null || elementPart.isEmpty()) {
            return elements;
        }
        Matcher matcher = ELEMENT_PATTERN.matcher(elementPart);
        while (matcher.find()) {
            String symbol = matcher.group(1);
            Element element = Element.fromSymbol(symbol);
            if (element == null || elements.contains((Object)element)) continue;
            elements.add(element);
        }
        return elements;
    }
}

