/*
 * Decompiled with CFR 0.152.
 */
package com.wynntils.models.ingredients;

import com.wynntils.core.components.Model;
import com.wynntils.core.components.Models;
import com.wynntils.core.net.DownloadRegistry;
import com.wynntils.models.ingredients.IngredientInfoRegistry;
import com.wynntils.models.ingredients.type.IngredientInfo;
import com.wynntils.models.wynnitem.type.ItemObtainInfo;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.stream.Stream;
import net.minecraft.class_124;

public final class IngredientModel
extends Model {
    private static final Map<class_124, Integer> TIER_COLOR_CODES = Map.of(class_124.field_1063, 0, class_124.field_1054, 1, class_124.field_1076, 2, class_124.field_1075, 3);
    private final IngredientInfoRegistry ingredientInfoRegistry = new IngredientInfoRegistry();

    public IngredientModel() {
        super(List.of());
    }

    @Override
    public void registerDownloads(DownloadRegistry registry) {
        this.ingredientInfoRegistry.registerDownloads(registry);
    }

    public int getTierFromColorCode(String tierColor) {
        return TIER_COLOR_CODES.getOrDefault(class_124.method_544((char)tierColor.charAt(0)), 0);
    }

    public IngredientInfo getIngredientInfoFromName(String ingredientName) {
        return this.ingredientInfoRegistry.getFromDisplayName(ingredientName);
    }

    public IngredientInfo getIngredientInfoFromApiName(String ingredientName) {
        return this.ingredientInfoRegistry.getFromApiName(ingredientName);
    }

    public List<ItemObtainInfo> getObtainInfo(IngredientInfo ingredientInfo) {
        ArrayList<ItemObtainInfo> obtainInfo = new ArrayList<ItemObtainInfo>(ingredientInfo.obtainInfo());
        if (obtainInfo.size() == 1 && ((ItemObtainInfo)obtainInfo.getFirst()).equals(ItemObtainInfo.UNKNOWN)) {
            obtainInfo.clear();
        }
        obtainInfo.addAll(Models.WynnItem.getObtainInfo(ingredientInfo.name()));
        return obtainInfo;
    }

    public Stream<IngredientInfo> getAllIngredientInfos() {
        return this.ingredientInfoRegistry.getIngredientInfoStream();
    }
}

