/*
 * Decompiled with CFR 0.152.
 */
package com.wynntils.models.items.annotators.game;

import com.wynntils.core.text.StyledText;
import com.wynntils.handlers.item.GameItemAnnotator;
import com.wynntils.handlers.item.ItemAnnotation;
import com.wynntils.models.gear.type.GearTier;
import com.wynntils.models.items.items.game.TrinketItem;
import com.wynntils.utils.mc.LoreUtils;
import com.wynntils.utils.type.CappedValue;
import java.util.NoSuchElementException;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import net.minecraft.class_1799;

public final class TrinketAnnotator
implements GameItemAnnotator {
    private static final Pattern TRINKET_PATTERN = Pattern.compile("^\u00a7[5abcdef](.*?)(?: \\[(\\d+)/(\\d+)\\])?$");
    private static final Pattern TRINKET_LORE_PATTERN = Pattern.compile("^\u00a77Right-Click to (use|toggle)$");

    @Override
    public ItemAnnotation getAnnotation(class_1799 itemStack, StyledText name) {
        Matcher matcher = name.getMatcher(TRINKET_PATTERN);
        if (!matcher.matches()) {
            return null;
        }
        try {
            Matcher loreMatcher = LoreUtils.matchLoreLine(itemStack, 0, TRINKET_LORE_PATTERN);
            if (!loreMatcher.matches()) {
                return null;
            }
            String trinketName = matcher.group(1);
            GearTier gearTier = GearTier.fromStyledText(name);
            if (matcher.group(2) != null) {
                CappedValue uses = new CappedValue(Integer.parseInt(matcher.group(2)), Integer.parseInt(matcher.group(3)));
                return new TrinketItem(trinketName, gearTier, uses);
            }
            return new TrinketItem(trinketName, gearTier);
        }
        catch (NoSuchElementException ignored) {
            return null;
        }
    }
}

